/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnSortWith;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;

public final class ArraySortWith
extends FnSortWith {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        long as = array.structSize();
        ValueList values = new ValueList(Seq.initialCapacity(as));
        for (Value member : array.iterable()) {
            values.add(member);
        }
        this.sort(values, qc);
        ArrayBuilder ab = new ArrayBuilder(qc, as);
        for (Value value : values) {
            ab.add(value);
        }
        return ab.array(this);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr array = this.arg(0);
        Type type = array.seqType().type;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            this.exprType.assign(at);
        }
        return this;
    }

    @Override
    public long structSize() {
        Expr expr1 = this.arg(0);
        return expr1.seqType().instanceOf(Types.ARRAY_O) ? expr1.structSize() : -1L;
    }
}

