/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jSpyLogDelegator
implements SpyLogDelegator {
    private final Logger jdbcLogger = LoggerFactory.getLogger((String)"jdbc.audit");
    private final Logger resultSetLogger = LoggerFactory.getLogger((String)"jdbc.resultset");
    private final Logger sqlOnlyLogger = LoggerFactory.getLogger((String)"jdbc.sqlonly");
    private final Logger sqlTimingLogger = LoggerFactory.getLogger((String)"jdbc.sqltiming");
    private final Logger debugLogger = LoggerFactory.getLogger((String)"log4jdbc.debug");
    private static String nl = System.getProperty("line.separator");

    @Override
    public boolean isJdbcLoggingEnabled() {
        return this.jdbcLogger.isErrorEnabled() || this.resultSetLogger.isErrorEnabled() || this.sqlOnlyLogger.isErrorEnabled() || this.sqlTimingLogger.isErrorEnabled();
    }

    @Override
    public void exceptionOccured(Spy spy, String methodCall, Exception e, String sql, long execTime) {
        String classType = spy.getClassType();
        int spyNo = spy.getConnectionNumber();
        String header = spyNo + ". " + classType + "." + methodCall;
        if (sql == null) {
            this.jdbcLogger.error(header, (Throwable)e);
            this.sqlOnlyLogger.error(header, (Throwable)e);
            this.sqlTimingLogger.error(header, (Throwable)e);
        } else {
            this.jdbcLogger.error(header + " " + sql, (Throwable)e);
            if (this.sqlOnlyLogger.isDebugEnabled()) {
                this.sqlOnlyLogger.error(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql, (Throwable)e);
            } else {
                this.sqlOnlyLogger.error(header + " " + sql, (Throwable)e);
            }
            if (this.sqlTimingLogger.isDebugEnabled()) {
                this.sqlTimingLogger.error(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql + " {FAILED after " + execTime + " msec}", (Throwable)e);
            } else {
                this.sqlTimingLogger.error(header + " FAILED! " + sql + " {FAILED after " + execTime + " msec}", (Throwable)e);
            }
        }
    }

    @Override
    public void methodReturned(Spy spy, String methodCall, String returnMsg) {
        String classType = spy.getClassType();
        int spyNo = spy.getConnectionNumber();
        String header = spyNo + ". " + classType + "." + methodCall + " returned " + returnMsg;
        if ("ResultSet".equals(classType)) {
            if (this.resultSetLogger.isDebugEnabled()) {
                this.resultSetLogger.debug(header + " " + Slf4jSpyLogDelegator.getDebugInfo());
            } else if (this.resultSetLogger.isInfoEnabled()) {
                this.resultSetLogger.info(header);
            }
        } else if (this.jdbcLogger.isDebugEnabled()) {
            this.jdbcLogger.debug(header + " " + Slf4jSpyLogDelegator.getDebugInfo());
        } else if (this.jdbcLogger.isInfoEnabled()) {
            this.jdbcLogger.info(header);
        }
    }

    @Override
    public void constructorReturned(Spy spy, String constructionInfo) {
    }

    @Override
    public void sqlOccured(Spy spy, String methodCall, String sql) {
        int spyNo = spy.getConnectionNumber();
        if (this.sqlOnlyLogger.isDebugEnabled()) {
            this.sqlOnlyLogger.debug(Slf4jSpyLogDelegator.getDebugInfo() + nl + spyNo + ". " + sql);
        } else if (this.sqlOnlyLogger.isInfoEnabled()) {
            this.sqlOnlyLogger.info(sql);
        }
    }

    @Override
    public void sqlTimingOccured(Spy spy, long execTime, String methodCall, String sql) {
        if (this.sqlTimingLogger.isErrorEnabled()) {
            if (DriverSpy.SqlTimingErrorThresholdEnabled && execTime >= DriverSpy.SqlTimingErrorThresholdMsec) {
                this.sqlTimingLogger.error(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
            } else if (this.sqlTimingLogger.isWarnEnabled()) {
                if (DriverSpy.SqlTimingWarnThresholdEnabled && execTime >= DriverSpy.SqlTimingWarnThresholdMsec) {
                    this.sqlTimingLogger.warn(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
                } else if (this.sqlTimingLogger.isDebugEnabled()) {
                    this.sqlTimingLogger.debug(this.buildSqlTimingDump(spy, execTime, methodCall, sql, true));
                } else if (this.sqlTimingLogger.isInfoEnabled()) {
                    this.sqlTimingLogger.info(this.buildSqlTimingDump(spy, execTime, methodCall, sql, false));
                }
            }
        }
    }

    private String buildSqlTimingDump(Spy spy, long execTime, String methodCall, String sql, boolean debugInfo) {
        StringBuffer out = new StringBuffer();
        if (debugInfo) {
            out.append(Slf4jSpyLogDelegator.getDebugInfo());
            out.append(nl);
            out.append(spy.getConnectionNumber());
            out.append(". ");
        }
        out.append(sql);
        out.append(" {executed in ");
        out.append(execTime);
        out.append(" msec}");
        return out.toString();
    }

    private static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null) {
            int firstLog4jdbcCall = 0;
            int lastApplicationCall = 0;
            for (int i = 0; i < stackTrace.length; ++i) {
                String className = stackTrace[i].getClassName();
                if (className.startsWith("net.sf.log4jdbc")) {
                    firstLog4jdbcCall = i;
                    continue;
                }
                if (!DriverSpy.TraceFromApplication || !className.startsWith(DriverSpy.DebugStackPrefix)) continue;
                lastApplicationCall = i;
                break;
            }
            StringBuffer dump = new StringBuffer(" ");
            int j = lastApplicationCall;
            if (j == 0) {
                j = 1 + firstLog4jdbcCall;
            }
            dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
            return dump.toString();
        }
        return null;
    }

    @Override
    public void debug(String msg) {
        this.debugLogger.debug(msg);
    }
}

