/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.pdfbox.util.PDFText2HTML;
import org.pdfbox.util.PDFTextStripper;

public class ExtractText {
    public static final String DEFAULT_ENCODING = null;
    private static final String PASSWORD = "-password";
    private static final String ENCODING = "-encoding";
    private static final String CONSOLE = "-console";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String SORT = "-sort";
    private static final String HTML = "-html";

    private ExtractText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        PDDocument document;
        block23: {
            boolean toConsole = false;
            boolean toHTML = false;
            boolean sort = false;
            String password = "";
            String encoding = DEFAULT_ENCODING;
            String pdfFile = null;
            String textFile = null;
            int startPage = 1;
            int endPage = Integer.MAX_VALUE;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(ENCODING)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    encoding = args[i];
                    continue;
                }
                if (args[i].equals(START_PAGE)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    startPage = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals(HTML)) {
                    toHTML = true;
                    continue;
                }
                if (args[i].equals(SORT)) {
                    sort = true;
                    continue;
                }
                if (args[i].equals(END_PAGE)) {
                    if (++i >= args.length) {
                        ExtractText.usage();
                    }
                    endPage = Integer.parseInt(args[i]);
                    continue;
                }
                if (args[i].equals(CONSOLE)) {
                    toConsole = true;
                    continue;
                }
                if (pdfFile == null) {
                    pdfFile = args[i];
                    continue;
                }
                textFile = args[i];
            }
            if (pdfFile == null) {
                ExtractText.usage();
                return;
            }
            Writer output = null;
            document = null;
            try {
                block22: {
                    try {
                        URL url = new URL(pdfFile);
                        document = PDDocument.load(url);
                        String fileName = url.getFile();
                        if (textFile == null && fileName.length() > 4) {
                            File outputFile = new File(fileName.substring(0, fileName.length() - 4) + ".txt");
                            textFile = outputFile.getName();
                        }
                    }
                    catch (MalformedURLException e) {
                        document = PDDocument.load(pdfFile);
                        if (textFile != null || pdfFile.length() <= 4) break block22;
                        textFile = pdfFile.substring(0, pdfFile.length() - 4) + ".txt";
                    }
                }
                if (document.isEncrypted()) {
                    StandardDecryptionMaterial sdm = new StandardDecryptionMaterial(password);
                    document.openProtection(sdm);
                    AccessPermission ap = document.getCurrentAccessPermission();
                    if (!ap.canExtractContent()) {
                        throw new IOException("You do not have permission to extract text");
                    }
                }
                output = toConsole ? new OutputStreamWriter(System.out) : (encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(textFile), encoding) : new OutputStreamWriter(new FileOutputStream(textFile)));
                PDFTextStripper stripper = null;
                stripper = toHTML ? new PDFText2HTML() : new PDFTextStripper();
                stripper.setSortByPosition(sort);
                stripper.setStartPage(startPage);
                stripper.setEndPage(endPage);
                stripper.writeText(document, output);
                Object var16_17 = null;
                if (output == null) break block23;
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (output != null) {
                    output.close();
                }
                if (document == null) throw throwable;
                document.close();
                throw throwable;
            }
            output.close();
        }
        if (document == null) return;
        document.close();
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.ExtractText [OPTIONS] <PDF file> [Text File]\n  -password  <password>        Password to decrypt document\n  -encoding  <output encoding> (ISO-8859-1,UTF-16BE,UTF-16LE,...)\n  -console                     Send text to console instead of file\n  -html                        Output in HTML format instead of raw text\n  -sort                        Sort the text before writing\n  -startPage <number>          The first page to start extraction(1 based)\n  -endPage <number>            The last page to extract(inclusive)\n  <PDF file>                   The PDF document to use\n  [Text File]                  The file to write the text to\n");
        System.exit(1);
    }
}

