<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/taskqueue/taskqueue_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/datastore/datastore_v3_pb.php';
}
namespace google\appengine\TaskQueueServiceError {
  class ErrorCode {
    const OK = 0;
    const UNKNOWN_QUEUE = 1;
    const TRANSIENT_ERROR = 2;
    const INTERNAL_ERROR = 3;
    const TASK_TOO_LARGE = 4;
    const INVALID_TASK_NAME = 5;
    const INVALID_QUEUE_NAME = 6;
    const INVALID_URL = 7;
    const INVALID_QUEUE_RATE = 8;
    const PERMISSION_DENIED = 9;
    const TASK_ALREADY_EXISTS = 10;
    const TOMBSTONED_TASK = 11;
    const INVALID_ETA = 12;
    const INVALID_REQUEST = 13;
    const UNKNOWN_TASK = 14;
    const TOMBSTONED_QUEUE = 15;
    const DUPLICATE_TASK_NAME = 16;
    const SKIPPED = 17;
    const TOO_MANY_TASKS = 18;
    const INVALID_PAYLOAD = 19;
    const INVALID_RETRY_PARAMETERS = 20;
    const INVALID_QUEUE_MODE = 21;
    const ACL_LOOKUP_ERROR = 22;
    const TRANSACTIONAL_REQUEST_TOO_LARGE = 23;
    const INCORRECT_CREATOR_NAME = 24;
    const TASK_LEASE_EXPIRED = 25;
    const QUEUE_PAUSED = 26;
    const INVALID_TAG = 27;
    const DATASTORE_ERROR = 10000;
  }
}
namespace google\appengine {
  class TaskQueueServiceError extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskPayload extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueRetryParameters extends \google\net\ProtocolMessage {
    public function getRetryLimit() {
      if (!isset($this->retry_limit)) {
        return 0;
      }
      return $this->retry_limit;
    }
    public function setRetryLimit($val) {
      $this->retry_limit = $val;
      return $this;
    }
    public function clearRetryLimit() {
      unset($this->retry_limit);
      return $this;
    }
    public function hasRetryLimit() {
      return isset($this->retry_limit);
    }
    public function getAgeLimitSec() {
      if (!isset($this->age_limit_sec)) {
        return "0";
      }
      return $this->age_limit_sec;
    }
    public function setAgeLimitSec($val) {
      if (is_double($val)) {
        $this->age_limit_sec = sprintf('%0.0F', $val);
      } else {
        $this->age_limit_sec = $val;
      }
      return $this;
    }
    public function clearAgeLimitSec() {
      unset($this->age_limit_sec);
      return $this;
    }
    public function hasAgeLimitSec() {
      return isset($this->age_limit_sec);
    }
    public function getMinBackoffSec() {
      if (!isset($this->min_backoff_sec)) {
        return 0.1;
      }
      return $this->min_backoff_sec;
    }
    public function setMinBackoffSec($val) {
      $this->min_backoff_sec = $val;
      return $this;
    }
    public function clearMinBackoffSec() {
      unset($this->min_backoff_sec);
      return $this;
    }
    public function hasMinBackoffSec() {
      return isset($this->min_backoff_sec);
    }
    public function getMaxBackoffSec() {
      if (!isset($this->max_backoff_sec)) {
        return 3600;
      }
      return $this->max_backoff_sec;
    }
    public function setMaxBackoffSec($val) {
      $this->max_backoff_sec = $val;
      return $this;
    }
    public function clearMaxBackoffSec() {
      unset($this->max_backoff_sec);
      return $this;
    }
    public function hasMaxBackoffSec() {
      return isset($this->max_backoff_sec);
    }
    public function getMaxDoublings() {
      if (!isset($this->max_doublings)) {
        return 16;
      }
      return $this->max_doublings;
    }
    public function setMaxDoublings($val) {
      $this->max_doublings = $val;
      return $this;
    }
    public function clearMaxDoublings() {
      unset($this->max_doublings);
      return $this;
    }
    public function hasMaxDoublings() {
      return isset($this->max_doublings);
    }
    public function clear() {
      $this->clearRetryLimit();
      $this->clearAgeLimitSec();
      $this->clearMinBackoffSec();
      $this->clearMaxBackoffSec();
      $this->clearMaxDoublings();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->retry_limit)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->retry_limit);
      }
      if (isset($this->age_limit_sec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->age_limit_sec);
      }
      if (isset($this->min_backoff_sec)) {
        $res += 9;
      }
      if (isset($this->max_backoff_sec)) {
        $res += 9;
      }
      if (isset($this->max_doublings)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_doublings);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->retry_limit)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->retry_limit);
      }
      if (isset($this->age_limit_sec)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->age_limit_sec);
      }
      if (isset($this->min_backoff_sec)) {
        $out->putVarInt32(25);
        $out->putDouble($this->min_backoff_sec);
      }
      if (isset($this->max_backoff_sec)) {
        $out->putVarInt32(33);
        $out->putDouble($this->max_backoff_sec);
      }
      if (isset($this->max_doublings)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->max_doublings);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setRetryLimit($d->getVarInt32());
            break;
          case 16:
            $this->setAgeLimitSec($d->getVarInt64());
            break;
          case 25:
            $this->setMinBackoffSec($d->getDouble());
            break;
          case 33:
            $this->setMaxBackoffSec($d->getDouble());
            break;
          case 40:
            $this->setMaxDoublings($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasRetryLimit()) {
        $this->setRetryLimit($x->getRetryLimit());
      }
      if ($x->hasAgeLimitSec()) {
        $this->setAgeLimitSec($x->getAgeLimitSec());
      }
      if ($x->hasMinBackoffSec()) {
        $this->setMinBackoffSec($x->getMinBackoffSec());
      }
      if ($x->hasMaxBackoffSec()) {
        $this->setMaxBackoffSec($x->getMaxBackoffSec());
      }
      if ($x->hasMaxDoublings()) {
        $this->setMaxDoublings($x->getMaxDoublings());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->retry_limit) !== isset($x->retry_limit)) return false;
      if (isset($this->retry_limit) && !$this->integerEquals($this->retry_limit, $x->retry_limit)) return false;
      if (isset($this->age_limit_sec) !== isset($x->age_limit_sec)) return false;
      if (isset($this->age_limit_sec) && !$this->integerEquals($this->age_limit_sec, $x->age_limit_sec)) return false;
      if (isset($this->min_backoff_sec) !== isset($x->min_backoff_sec)) return false;
      if (isset($this->min_backoff_sec) && $this->min_backoff_sec !== $x->min_backoff_sec) return false;
      if (isset($this->max_backoff_sec) !== isset($x->max_backoff_sec)) return false;
      if (isset($this->max_backoff_sec) && $this->max_backoff_sec !== $x->max_backoff_sec) return false;
      if (isset($this->max_doublings) !== isset($x->max_doublings)) return false;
      if (isset($this->max_doublings) && !$this->integerEquals($this->max_doublings, $x->max_doublings)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->retry_limit)) {
        $res .= $prefix . "retry_limit: " . $this->debugFormatInt32($this->retry_limit) . "\n";
      }
      if (isset($this->age_limit_sec)) {
        $res .= $prefix . "age_limit_sec: " . $this->debugFormatInt64($this->age_limit_sec) . "\n";
      }
      if (isset($this->min_backoff_sec)) {
        $res .= $prefix . "min_backoff_sec: " . $this->debugFormatDouble($this->min_backoff_sec) . "\n";
      }
      if (isset($this->max_backoff_sec)) {
        $res .= $prefix . "max_backoff_sec: " . $this->debugFormatDouble($this->max_backoff_sec) . "\n";
      }
      if (isset($this->max_doublings)) {
        $res .= $prefix . "max_doublings: " . $this->debugFormatInt32($this->max_doublings) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueAcl extends \google\net\ProtocolMessage {
    private $user_email = array();
    private $writer_email = array();
    public function getUserEmailSize() {
      return sizeof($this->user_email);
    }
    public function getUserEmailList() {
      return $this->user_email;
    }
    public function getUserEmail($idx) {
      return $this->user_email[$idx];
    }
    public function setUserEmail($idx, $val) {
      $this->user_email[$idx] = $val;
      return $this;
    }
    public function addUserEmail($val) {
      $this->user_email[] = $val;
      return $this;
    }
    public function clearUserEmail() {
      $this->user_email = array();
    }
    public function getWriterEmailSize() {
      return sizeof($this->writer_email);
    }
    public function getWriterEmailList() {
      return $this->writer_email;
    }
    public function getWriterEmail($idx) {
      return $this->writer_email[$idx];
    }
    public function setWriterEmail($idx, $val) {
      $this->writer_email[$idx] = $val;
      return $this;
    }
    public function addWriterEmail($val) {
      $this->writer_email[] = $val;
      return $this;
    }
    public function clearWriterEmail() {
      $this->writer_email = array();
    }
    public function clear() {
      $this->clearUserEmail();
      $this->clearWriterEmail();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->user_email);
      $res += 1 * sizeof($this->user_email);
      foreach ($this->user_email as $value) {
        $res += $this->lengthString(strlen($value));
      }
      $this->checkProtoArray($this->writer_email);
      $res += 1 * sizeof($this->writer_email);
      foreach ($this->writer_email as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->user_email);
      foreach ($this->user_email as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
      $this->checkProtoArray($this->writer_email);
      foreach ($this->writer_email as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addUserEmail(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addWriterEmail(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getUserEmailList() as $v) {
        $this->addUserEmail($v);
      }
      foreach ($x->getWriterEmailList() as $v) {
        $this->addWriterEmail($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->user_email) !== sizeof($x->user_email)) return false;
      foreach (array_map(null, $this->user_email, $x->user_email) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (sizeof($this->writer_email) !== sizeof($x->writer_email)) return false;
      foreach (array_map(null, $this->writer_email, $x->writer_email) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->user_email as $value) {
        $res .= $prefix . "user_email: " . $this->debugFormatString($value) . "\n";
      }
      foreach ($this->writer_email as $value) {
        $res .= $prefix . "writer_email: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueHttpHeader extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueMode {
  class Mode {
    const PUSH = 0;
    const PULL = 1;
  }
}
namespace google\appengine {
  class TaskQueueMode extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueAddRequest {
  class RequestMethod {
    const GET = 1;
    const POST = 2;
    const HEAD = 3;
    const PUT = 4;
    const DELETE = 5;
  }
}
namespace google\appengine\TaskQueueAddRequest {
  class Header extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(58);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(66);
        $out->putPrefixedString($this->value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 52: return;
          case 58:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 66:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueAddRequest {
  class CronTimetable extends \google\net\ProtocolMessage {
    public function getSchedule() {
      if (!isset($this->schedule)) {
        return '';
      }
      return $this->schedule;
    }
    public function setSchedule($val) {
      $this->schedule = $val;
      return $this;
    }
    public function clearSchedule() {
      unset($this->schedule);
      return $this;
    }
    public function hasSchedule() {
      return isset($this->schedule);
    }
    public function getTimezone() {
      if (!isset($this->timezone)) {
        return '';
      }
      return $this->timezone;
    }
    public function setTimezone($val) {
      $this->timezone = $val;
      return $this;
    }
    public function clearTimezone() {
      unset($this->timezone);
      return $this;
    }
    public function hasTimezone() {
      return isset($this->timezone);
    }
    public function clear() {
      $this->clearSchedule();
      $this->clearTimezone();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->schedule)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->schedule));
      }
      if (isset($this->timezone)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->timezone));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->schedule)) {
        $out->putVarInt32(106);
        $out->putPrefixedString($this->schedule);
      }
      if (isset($this->timezone)) {
        $out->putVarInt32(114);
        $out->putPrefixedString($this->timezone);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 100: return;
          case 106:
            $length = $d->getVarInt32();
            $this->setSchedule(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 114:
            $length = $d->getVarInt32();
            $this->setTimezone(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->schedule)) return 'schedule';
      if (!isset($this->timezone)) return 'timezone';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasSchedule()) {
        $this->setSchedule($x->getSchedule());
      }
      if ($x->hasTimezone()) {
        $this->setTimezone($x->getTimezone());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->schedule) !== isset($x->schedule)) return false;
      if (isset($this->schedule) && $this->schedule !== $x->schedule) return false;
      if (isset($this->timezone) !== isset($x->timezone)) return false;
      if (isset($this->timezone) && $this->timezone !== $x->timezone) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->schedule)) {
        $res .= $prefix . "schedule: " . $this->debugFormatString($this->schedule) . "\n";
      }
      if (isset($this->timezone)) {
        $res .= $prefix . "timezone: " . $this->debugFormatString($this->timezone) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueAddRequest extends \google\net\ProtocolMessage {
    private $header = array();
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function getEtaUsec() {
      if (!isset($this->eta_usec)) {
        return "0";
      }
      return $this->eta_usec;
    }
    public function setEtaUsec($val) {
      if (is_double($val)) {
        $this->eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->eta_usec = $val;
      }
      return $this;
    }
    public function clearEtaUsec() {
      unset($this->eta_usec);
      return $this;
    }
    public function hasEtaUsec() {
      return isset($this->eta_usec);
    }
    public function getUrl() {
      if (!isset($this->url)) {
        return '';
      }
      return $this->url;
    }
    public function setUrl($val) {
      $this->url = $val;
      return $this;
    }
    public function clearUrl() {
      unset($this->url);
      return $this;
    }
    public function hasUrl() {
      return isset($this->url);
    }
    public function getMethod() {
      if (!isset($this->method)) {
        return 2;
      }
      return $this->method;
    }
    public function setMethod($val) {
      $this->method = $val;
      return $this;
    }
    public function clearMethod() {
      unset($this->method);
      return $this;
    }
    public function hasMethod() {
      return isset($this->method);
    }
    public function getHeaderSize() {
      return sizeof($this->header);
    }
    public function getHeaderList() {
      return $this->header;
    }
    public function mutableHeader($idx) {
      if (!isset($this->header[$idx])) {
        $val = new \google\appengine\TaskQueueAddRequest\Header();
        $this->header[$idx] = $val;
        return $val;
      }
      return $this->header[$idx];
    }
    public function getHeader($idx) {
      if (isset($this->header[$idx])) {
        return $this->header[$idx];
      }
      if ($idx >= end(array_keys($this->header))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueAddRequest\Header();
    }
    public function addHeader() {
      $val = new \google\appengine\TaskQueueAddRequest\Header();
      $this->header[] = $val;
      return $val;
    }
    public function clearHeader() {
      $this->header = array();
    }
    public function getBody() {
      if (!isset($this->body)) {
        return '';
      }
      return $this->body;
    }
    public function setBody($val) {
      $this->body = $val;
      return $this;
    }
    public function clearBody() {
      unset($this->body);
      return $this;
    }
    public function hasBody() {
      return isset($this->body);
    }
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return new \google\appengine_datastore_v3\Transaction();
      }
      return $this->transaction;
    }
    public function mutableTransaction() {
      if (!isset($this->transaction)) {
        $res = new \google\appengine_datastore_v3\Transaction();
        $this->transaction = $res;
        return $res;
      }
      return $this->transaction;
    }
    public function clearTransaction() {
      if (isset($this->transaction)) {
        unset($this->transaction);
      }
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getCronTimetable() {
      if (!isset($this->crontimetable)) {
        return new \google\appengine\TaskQueueAddRequest\CronTimetable();
      }
      return $this->crontimetable;
    }
    public function mutableCronTimetable() {
      if (!isset($this->crontimetable)) {
        $res = new \google\appengine\TaskQueueAddRequest\CronTimetable();
        $this->crontimetable = $res;
        return $res;
      }
      return $this->crontimetable;
    }
    public function clearCronTimetable() {
      if (isset($this->crontimetable)) {
        unset($this->crontimetable);
      }
    }
    public function hasCronTimetable() {
      return isset($this->crontimetable);
    }
    public function getDescription() {
      if (!isset($this->description)) {
        return '';
      }
      return $this->description;
    }
    public function setDescription($val) {
      $this->description = $val;
      return $this;
    }
    public function clearDescription() {
      unset($this->description);
      return $this;
    }
    public function hasDescription() {
      return isset($this->description);
    }
    public function getPayload() {
      if (!isset($this->payload)) {
        return new \google\appengine\TaskPayload();
      }
      return $this->payload;
    }
    public function mutablePayload() {
      if (!isset($this->payload)) {
        $res = new \google\appengine\TaskPayload();
        $this->payload = $res;
        return $res;
      }
      return $this->payload;
    }
    public function clearPayload() {
      if (isset($this->payload)) {
        unset($this->payload);
      }
    }
    public function hasPayload() {
      return isset($this->payload);
    }
    public function getRetryParameters() {
      if (!isset($this->retry_parameters)) {
        return new \google\appengine\TaskQueueRetryParameters();
      }
      return $this->retry_parameters;
    }
    public function mutableRetryParameters() {
      if (!isset($this->retry_parameters)) {
        $res = new \google\appengine\TaskQueueRetryParameters();
        $this->retry_parameters = $res;
        return $res;
      }
      return $this->retry_parameters;
    }
    public function clearRetryParameters() {
      if (isset($this->retry_parameters)) {
        unset($this->retry_parameters);
      }
    }
    public function hasRetryParameters() {
      return isset($this->retry_parameters);
    }
    public function getMode() {
      if (!isset($this->mode)) {
        return 0;
      }
      return $this->mode;
    }
    public function setMode($val) {
      $this->mode = $val;
      return $this;
    }
    public function clearMode() {
      unset($this->mode);
      return $this;
    }
    public function hasMode() {
      return isset($this->mode);
    }
    public function getTag() {
      if (!isset($this->tag)) {
        return '';
      }
      return $this->tag;
    }
    public function setTag($val) {
      $this->tag = $val;
      return $this;
    }
    public function clearTag() {
      unset($this->tag);
      return $this;
    }
    public function hasTag() {
      return isset($this->tag);
    }
    public function clear() {
      $this->clearQueueName();
      $this->clearTaskName();
      $this->clearEtaUsec();
      $this->clearUrl();
      $this->clearMethod();
      $this->clearHeader();
      $this->clearBody();
      $this->clearTransaction();
      $this->clearAppId();
      $this->clearCronTimetable();
      $this->clearDescription();
      $this->clearPayload();
      $this->clearRetryParameters();
      $this->clearMode();
      $this->clearTag();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->task_name));
      }
      if (isset($this->eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->eta_usec);
      }
      if (isset($this->url)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->url));
      }
      if (isset($this->method)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->method);
      }
      $this->checkProtoArray($this->header);
      $res += 2 * sizeof($this->header);
      foreach ($this->header as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->body)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->body));
      }
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString($this->transaction->byteSizePartial());
      }
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->crontimetable)) {
        $res += 2;
        $res += $this->crontimetable->byteSizePartial();
      }
      if (isset($this->description)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->description));
      }
      if (isset($this->payload)) {
        $res += 2;
        $res += $this->lengthString($this->payload->byteSizePartial());
      }
      if (isset($this->retry_parameters)) {
        $res += 2;
        $res += $this->lengthString($this->retry_parameters->byteSizePartial());
      }
      if (isset($this->mode)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->mode);
      }
      if (isset($this->tag)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->tag));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->queue_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->task_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->task_name);
      }
      if (isset($this->eta_usec)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->eta_usec);
      }
      if (isset($this->url)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->url);
      }
      if (isset($this->method)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->method);
      }
      $this->checkProtoArray($this->header);
      foreach ($this->header as $value) {
        $out->putVarInt32(51);
        $value->outputPartial($out);
        $out->putVarInt32(52);
      }
      if (isset($this->body)) {
        $out->putVarInt32(74);
        $out->putPrefixedString($this->body);
      }
      if (isset($this->transaction)) {
        $out->putVarInt32(82);
        $out->putVarInt32($this->transaction->byteSizePartial());
        $this->transaction->outputPartial($out);
      }
      if (isset($this->app_id)) {
        $out->putVarInt32(90);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->crontimetable)) {
        $out->putVarInt32(99);
        $this->crontimetable->outputPartial($out);
        $out->putVarInt32(100);
      }
      if (isset($this->description)) {
        $out->putVarInt32(122);
        $out->putPrefixedString($this->description);
      }
      if (isset($this->payload)) {
        $out->putVarInt32(130);
        $out->putVarInt32($this->payload->byteSizePartial());
        $this->payload->outputPartial($out);
      }
      if (isset($this->retry_parameters)) {
        $out->putVarInt32(138);
        $out->putVarInt32($this->retry_parameters->byteSizePartial());
        $this->retry_parameters->outputPartial($out);
      }
      if (isset($this->mode)) {
        $out->putVarInt32(144);
        $out->putVarInt32($this->mode);
      }
      if (isset($this->tag)) {
        $out->putVarInt32(154);
        $out->putPrefixedString($this->tag);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setEtaUsec($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setUrl(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 40:
            $this->setMethod($d->getVarInt32());
            break;
          case 51:
            $this->addHeader()->tryMerge($d);
            break;
          case 74:
            $length = $d->getVarInt32();
            $this->setBody(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 82:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTransaction()->tryMerge($tmp);
            break;
          case 90:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 99:
            $this->mutableCronTimetable()->tryMerge($d);
            break;
          case 122:
            $length = $d->getVarInt32();
            $this->setDescription(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 130:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePayload()->tryMerge($tmp);
            break;
          case 138:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableRetryParameters()->tryMerge($tmp);
            break;
          case 144:
            $this->setMode($d->getVarInt32());
            break;
          case 154:
            $length = $d->getVarInt32();
            $this->setTag(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->task_name)) return 'task_name';
      if (!isset($this->eta_usec)) return 'eta_usec';
      foreach ($this->header as $value) {
        if (!$value->isInitialized()) return 'header';
      }
      if (isset($this->transaction) && (!$this->transaction->isInitialized())) return 'transaction';
      if (isset($this->crontimetable) && (!$this->crontimetable->isInitialized())) return 'crontimetable';
      if (isset($this->payload) && (!$this->payload->isInitialized())) return 'payload';
      if (isset($this->retry_parameters) && (!$this->retry_parameters->isInitialized())) return 'retry_parameters';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
      if ($x->hasEtaUsec()) {
        $this->setEtaUsec($x->getEtaUsec());
      }
      if ($x->hasUrl()) {
        $this->setUrl($x->getUrl());
      }
      if ($x->hasMethod()) {
        $this->setMethod($x->getMethod());
      }
      foreach ($x->getHeaderList() as $v) {
        $this->addHeader()->copyFrom($v);
      }
      if ($x->hasBody()) {
        $this->setBody($x->getBody());
      }
      if ($x->hasTransaction()) {
        $this->mutableTransaction()->mergeFrom($x->getTransaction());
      }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasCronTimetable()) {
        $this->mutableCronTimetable()->mergeFrom($x->getCronTimetable());
      }
      if ($x->hasDescription()) {
        $this->setDescription($x->getDescription());
      }
      if ($x->hasPayload()) {
        $this->mutablePayload()->mergeFrom($x->getPayload());
      }
      if ($x->hasRetryParameters()) {
        $this->mutableRetryParameters()->mergeFrom($x->getRetryParameters());
      }
      if ($x->hasMode()) {
        $this->setMode($x->getMode());
      }
      if ($x->hasTag()) {
        $this->setTag($x->getTag());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      if (isset($this->eta_usec) !== isset($x->eta_usec)) return false;
      if (isset($this->eta_usec) && !$this->integerEquals($this->eta_usec, $x->eta_usec)) return false;
      if (isset($this->url) !== isset($x->url)) return false;
      if (isset($this->url) && $this->url !== $x->url) return false;
      if (isset($this->method) !== isset($x->method)) return false;
      if (isset($this->method) && $this->method !== $x->method) return false;
      if (sizeof($this->header) !== sizeof($x->header)) return false;
      foreach (array_map(null, $this->header, $x->header) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->body) !== isset($x->body)) return false;
      if (isset($this->body) && $this->body !== $x->body) return false;
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && !$this->transaction->equals($x->transaction)) return false;
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->crontimetable) !== isset($x->crontimetable)) return false;
      if (isset($this->crontimetable) && !$this->crontimetable->equals($x->crontimetable)) return false;
      if (isset($this->description) !== isset($x->description)) return false;
      if (isset($this->description) && $this->description !== $x->description) return false;
      if (isset($this->payload) !== isset($x->payload)) return false;
      if (isset($this->payload) && !$this->payload->equals($x->payload)) return false;
      if (isset($this->retry_parameters) !== isset($x->retry_parameters)) return false;
      if (isset($this->retry_parameters) && !$this->retry_parameters->equals($x->retry_parameters)) return false;
      if (isset($this->mode) !== isset($x->mode)) return false;
      if (isset($this->mode) && $this->mode !== $x->mode) return false;
      if (isset($this->tag) !== isset($x->tag)) return false;
      if (isset($this->tag) && $this->tag !== $x->tag) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      if (isset($this->eta_usec)) {
        $res .= $prefix . "eta_usec: " . $this->debugFormatInt64($this->eta_usec) . "\n";
      }
      if (isset($this->url)) {
        $res .= $prefix . "url: " . $this->debugFormatString($this->url) . "\n";
      }
      if (isset($this->method)) {
        $res .= $prefix . "method: " . ($this->method) . "\n";
      }
      foreach ($this->header as $value) {
        $res .= $prefix . "Header {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->body)) {
        $res .= $prefix . "body: " . $this->debugFormatString($this->body) . "\n";
      }
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction <\n" . $this->transaction->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->crontimetable)) {
        $res .= $prefix . "CronTimetable {\n" . $this->crontimetable->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->description)) {
        $res .= $prefix . "description: " . $this->debugFormatString($this->description) . "\n";
      }
      if (isset($this->payload)) {
        $res .= $prefix . "payload <\n" . $this->payload->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->retry_parameters)) {
        $res .= $prefix . "retry_parameters <\n" . $this->retry_parameters->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->mode)) {
        $res .= $prefix . "mode: " . ($this->mode) . "\n";
      }
      if (isset($this->tag)) {
        $res .= $prefix . "tag: " . $this->debugFormatString($this->tag) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueAddResponse extends \google\net\ProtocolMessage {
    public function getChosenTaskName() {
      if (!isset($this->chosen_task_name)) {
        return '';
      }
      return $this->chosen_task_name;
    }
    public function setChosenTaskName($val) {
      $this->chosen_task_name = $val;
      return $this;
    }
    public function clearChosenTaskName() {
      unset($this->chosen_task_name);
      return $this;
    }
    public function hasChosenTaskName() {
      return isset($this->chosen_task_name);
    }
    public function clear() {
      $this->clearChosenTaskName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->chosen_task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->chosen_task_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->chosen_task_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->chosen_task_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setChosenTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasChosenTaskName()) {
        $this->setChosenTaskName($x->getChosenTaskName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->chosen_task_name) !== isset($x->chosen_task_name)) return false;
      if (isset($this->chosen_task_name) && $this->chosen_task_name !== $x->chosen_task_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->chosen_task_name)) {
        $res .= $prefix . "chosen_task_name: " . $this->debugFormatString($this->chosen_task_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueBulkAddRequest extends \google\net\ProtocolMessage {
    private $add_request = array();
    public function getAddRequestSize() {
      return sizeof($this->add_request);
    }
    public function getAddRequestList() {
      return $this->add_request;
    }
    public function mutableAddRequest($idx) {
      if (!isset($this->add_request[$idx])) {
        $val = new \google\appengine\TaskQueueAddRequest();
        $this->add_request[$idx] = $val;
        return $val;
      }
      return $this->add_request[$idx];
    }
    public function getAddRequest($idx) {
      if (isset($this->add_request[$idx])) {
        return $this->add_request[$idx];
      }
      if ($idx >= end(array_keys($this->add_request))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueAddRequest();
    }
    public function addAddRequest() {
      $val = new \google\appengine\TaskQueueAddRequest();
      $this->add_request[] = $val;
      return $val;
    }
    public function clearAddRequest() {
      $this->add_request = array();
    }
    public function clear() {
      $this->clearAddRequest();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->add_request);
      $res += 1 * sizeof($this->add_request);
      foreach ($this->add_request as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->add_request);
      foreach ($this->add_request as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addAddRequest()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->add_request as $value) {
        if (!$value->isInitialized()) return 'add_request';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getAddRequestList() as $v) {
        $this->addAddRequest()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->add_request) !== sizeof($x->add_request)) return false;
      foreach (array_map(null, $this->add_request, $x->add_request) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->add_request as $value) {
        $res .= $prefix . "add_request <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueBulkAddResponse {
  class TaskResult extends \google\net\ProtocolMessage {
    public function getResult() {
      if (!isset($this->result)) {
        return 0;
      }
      return $this->result;
    }
    public function setResult($val) {
      $this->result = $val;
      return $this;
    }
    public function clearResult() {
      unset($this->result);
      return $this;
    }
    public function hasResult() {
      return isset($this->result);
    }
    public function getChosenTaskName() {
      if (!isset($this->chosen_task_name)) {
        return '';
      }
      return $this->chosen_task_name;
    }
    public function setChosenTaskName($val) {
      $this->chosen_task_name = $val;
      return $this;
    }
    public function clearChosenTaskName() {
      unset($this->chosen_task_name);
      return $this;
    }
    public function hasChosenTaskName() {
      return isset($this->chosen_task_name);
    }
    public function clear() {
      $this->clearResult();
      $this->clearChosenTaskName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->result)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->result);
      }
      if (isset($this->chosen_task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->chosen_task_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->result)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->result);
      }
      if (isset($this->chosen_task_name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->chosen_task_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 16:
            $this->setResult($d->getVarInt32());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setChosenTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->result)) return 'result';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasResult()) {
        $this->setResult($x->getResult());
      }
      if ($x->hasChosenTaskName()) {
        $this->setChosenTaskName($x->getChosenTaskName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->result) !== isset($x->result)) return false;
      if (isset($this->result) && $this->result !== $x->result) return false;
      if (isset($this->chosen_task_name) !== isset($x->chosen_task_name)) return false;
      if (isset($this->chosen_task_name) && $this->chosen_task_name !== $x->chosen_task_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->result)) {
        $res .= $prefix . "result: " . ($this->result) . "\n";
      }
      if (isset($this->chosen_task_name)) {
        $res .= $prefix . "chosen_task_name: " . $this->debugFormatString($this->chosen_task_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueBulkAddResponse extends \google\net\ProtocolMessage {
    private $taskresult = array();
    public function getTaskResultSize() {
      return sizeof($this->taskresult);
    }
    public function getTaskResultList() {
      return $this->taskresult;
    }
    public function mutableTaskResult($idx) {
      if (!isset($this->taskresult[$idx])) {
        $val = new \google\appengine\TaskQueueBulkAddResponse\TaskResult();
        $this->taskresult[$idx] = $val;
        return $val;
      }
      return $this->taskresult[$idx];
    }
    public function getTaskResult($idx) {
      if (isset($this->taskresult[$idx])) {
        return $this->taskresult[$idx];
      }
      if ($idx >= end(array_keys($this->taskresult))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueBulkAddResponse\TaskResult();
    }
    public function addTaskResult() {
      $val = new \google\appengine\TaskQueueBulkAddResponse\TaskResult();
      $this->taskresult[] = $val;
      return $val;
    }
    public function clearTaskResult() {
      $this->taskresult = array();
    }
    public function clear() {
      $this->clearTaskResult();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->taskresult);
      $res += 2 * sizeof($this->taskresult);
      foreach ($this->taskresult as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->taskresult);
      foreach ($this->taskresult as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addTaskResult()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->taskresult as $value) {
        if (!$value->isInitialized()) return 'taskresult';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getTaskResultList() as $v) {
        $this->addTaskResult()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->taskresult) !== sizeof($x->taskresult)) return false;
      foreach (array_map(null, $this->taskresult, $x->taskresult) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->taskresult as $value) {
        $res .= $prefix . "TaskResult {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueDeleteRequest extends \google\net\ProtocolMessage {
    private $task_name = array();
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getTaskNameSize() {
      return sizeof($this->task_name);
    }
    public function getTaskNameList() {
      return $this->task_name;
    }
    public function getTaskName($idx) {
      return $this->task_name[$idx];
    }
    public function setTaskName($idx, $val) {
      $this->task_name[$idx] = $val;
      return $this;
    }
    public function addTaskName($val) {
      $this->task_name[] = $val;
      return $this;
    }
    public function clearTaskName() {
      $this->task_name = array();
    }
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function clear() {
      $this->clearQueueName();
      $this->clearTaskName();
      $this->clearAppId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      $this->checkProtoArray($this->task_name);
      $res += 1 * sizeof($this->task_name);
      foreach ($this->task_name as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->queue_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->queue_name);
      }
      $this->checkProtoArray($this->task_name);
      foreach ($this->task_name as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
      if (isset($this->app_id)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->app_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      foreach ($x->getTaskNameList() as $v) {
        $this->addTaskName($v);
      }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (sizeof($this->task_name) !== sizeof($x->task_name)) return false;
      foreach (array_map(null, $this->task_name, $x->task_name) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      foreach ($this->task_name as $value) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueDeleteResponse extends \google\net\ProtocolMessage {
    private $result = array();
    public function getResultSize() {
      return sizeof($this->result);
    }
    public function getResultList() {
      return $this->result;
    }
    public function getResult($idx) {
      return $this->result[$idx];
    }
    public function setResult($idx, $val) {
      $this->result[$idx] = $val;
      return $this;
    }
    public function addResult($val) {
      $this->result[] = $val;
      return $this;
    }
    public function clearResult() {
      $this->result = array();
    }
    public function clear() {
      $this->clearResult();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->result);
      $res += 1 * sizeof($this->result);
      foreach ($this->result as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->result);
      foreach ($this->result as $value) {
        $out->putVarInt32(24);
        $out->putVarInt32($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 24:
            $this->addResult($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getResultList() as $v) {
        $this->addResult($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->result) !== sizeof($x->result)) return false;
      foreach (array_map(null, $this->result, $x->result) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->result as $value) {
        $res .= $prefix . "result: " . ($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueForceRunRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
      $this->clearTaskName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->task_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->task_name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->task_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->task_name)) return 'task_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueForceRunResponse extends \google\net\ProtocolMessage {
    public function getResult() {
      if (!isset($this->result)) {
        return 0;
      }
      return $this->result;
    }
    public function setResult($val) {
      $this->result = $val;
      return $this;
    }
    public function clearResult() {
      unset($this->result);
      return $this;
    }
    public function hasResult() {
      return isset($this->result);
    }
    public function clear() {
      $this->clearResult();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->result)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->result);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->result)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->result);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 24:
            $this->setResult($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->result)) return 'result';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasResult()) {
        $this->setResult($x->getResult());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->result) !== isset($x->result)) return false;
      if (isset($this->result) && $this->result !== $x->result) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->result)) {
        $res .= $prefix . "result: " . ($this->result) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueUpdateQueueRequest extends \google\net\ProtocolMessage {
    private $header_override = array();
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getBucketRefillPerSecond() {
      if (!isset($this->bucket_refill_per_second)) {
        return 0.0;
      }
      return $this->bucket_refill_per_second;
    }
    public function setBucketRefillPerSecond($val) {
      $this->bucket_refill_per_second = $val;
      return $this;
    }
    public function clearBucketRefillPerSecond() {
      unset($this->bucket_refill_per_second);
      return $this;
    }
    public function hasBucketRefillPerSecond() {
      return isset($this->bucket_refill_per_second);
    }
    public function getBucketCapacity() {
      if (!isset($this->bucket_capacity)) {
        return 0;
      }
      return $this->bucket_capacity;
    }
    public function setBucketCapacity($val) {
      $this->bucket_capacity = $val;
      return $this;
    }
    public function clearBucketCapacity() {
      unset($this->bucket_capacity);
      return $this;
    }
    public function hasBucketCapacity() {
      return isset($this->bucket_capacity);
    }
    public function getUserSpecifiedRate() {
      if (!isset($this->user_specified_rate)) {
        return '';
      }
      return $this->user_specified_rate;
    }
    public function setUserSpecifiedRate($val) {
      $this->user_specified_rate = $val;
      return $this;
    }
    public function clearUserSpecifiedRate() {
      unset($this->user_specified_rate);
      return $this;
    }
    public function hasUserSpecifiedRate() {
      return isset($this->user_specified_rate);
    }
    public function getRetryParameters() {
      if (!isset($this->retry_parameters)) {
        return new \google\appengine\TaskQueueRetryParameters();
      }
      return $this->retry_parameters;
    }
    public function mutableRetryParameters() {
      if (!isset($this->retry_parameters)) {
        $res = new \google\appengine\TaskQueueRetryParameters();
        $this->retry_parameters = $res;
        return $res;
      }
      return $this->retry_parameters;
    }
    public function clearRetryParameters() {
      if (isset($this->retry_parameters)) {
        unset($this->retry_parameters);
      }
    }
    public function hasRetryParameters() {
      return isset($this->retry_parameters);
    }
    public function getMaxConcurrentRequests() {
      if (!isset($this->max_concurrent_requests)) {
        return 0;
      }
      return $this->max_concurrent_requests;
    }
    public function setMaxConcurrentRequests($val) {
      $this->max_concurrent_requests = $val;
      return $this;
    }
    public function clearMaxConcurrentRequests() {
      unset($this->max_concurrent_requests);
      return $this;
    }
    public function hasMaxConcurrentRequests() {
      return isset($this->max_concurrent_requests);
    }
    public function getMode() {
      if (!isset($this->mode)) {
        return 0;
      }
      return $this->mode;
    }
    public function setMode($val) {
      $this->mode = $val;
      return $this;
    }
    public function clearMode() {
      unset($this->mode);
      return $this;
    }
    public function hasMode() {
      return isset($this->mode);
    }
    public function getAcl() {
      if (!isset($this->acl)) {
        return new \google\appengine\TaskQueueAcl();
      }
      return $this->acl;
    }
    public function mutableAcl() {
      if (!isset($this->acl)) {
        $res = new \google\appengine\TaskQueueAcl();
        $this->acl = $res;
        return $res;
      }
      return $this->acl;
    }
    public function clearAcl() {
      if (isset($this->acl)) {
        unset($this->acl);
      }
    }
    public function hasAcl() {
      return isset($this->acl);
    }
    public function getHeaderOverrideSize() {
      return sizeof($this->header_override);
    }
    public function getHeaderOverrideList() {
      return $this->header_override;
    }
    public function mutableHeaderOverride($idx) {
      if (!isset($this->header_override[$idx])) {
        $val = new \google\appengine\TaskQueueHttpHeader();
        $this->header_override[$idx] = $val;
        return $val;
      }
      return $this->header_override[$idx];
    }
    public function getHeaderOverride($idx) {
      if (isset($this->header_override[$idx])) {
        return $this->header_override[$idx];
      }
      if ($idx >= end(array_keys($this->header_override))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueHttpHeader();
    }
    public function addHeaderOverride() {
      $val = new \google\appengine\TaskQueueHttpHeader();
      $this->header_override[] = $val;
      return $val;
    }
    public function clearHeaderOverride() {
      $this->header_override = array();
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
      $this->clearBucketRefillPerSecond();
      $this->clearBucketCapacity();
      $this->clearUserSpecifiedRate();
      $this->clearRetryParameters();
      $this->clearMaxConcurrentRequests();
      $this->clearMode();
      $this->clearAcl();
      $this->clearHeaderOverride();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->bucket_refill_per_second)) {
        $res += 9;
      }
      if (isset($this->bucket_capacity)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->bucket_capacity);
      }
      if (isset($this->user_specified_rate)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->user_specified_rate));
      }
      if (isset($this->retry_parameters)) {
        $res += 1;
        $res += $this->lengthString($this->retry_parameters->byteSizePartial());
      }
      if (isset($this->max_concurrent_requests)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_concurrent_requests);
      }
      if (isset($this->mode)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mode);
      }
      if (isset($this->acl)) {
        $res += 1;
        $res += $this->lengthString($this->acl->byteSizePartial());
      }
      $this->checkProtoArray($this->header_override);
      $res += 1 * sizeof($this->header_override);
      foreach ($this->header_override as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->bucket_refill_per_second)) {
        $out->putVarInt32(25);
        $out->putDouble($this->bucket_refill_per_second);
      }
      if (isset($this->bucket_capacity)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->bucket_capacity);
      }
      if (isset($this->user_specified_rate)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->user_specified_rate);
      }
      if (isset($this->retry_parameters)) {
        $out->putVarInt32(50);
        $out->putVarInt32($this->retry_parameters->byteSizePartial());
        $this->retry_parameters->outputPartial($out);
      }
      if (isset($this->max_concurrent_requests)) {
        $out->putVarInt32(56);
        $out->putVarInt32($this->max_concurrent_requests);
      }
      if (isset($this->mode)) {
        $out->putVarInt32(64);
        $out->putVarInt32($this->mode);
      }
      if (isset($this->acl)) {
        $out->putVarInt32(74);
        $out->putVarInt32($this->acl->byteSizePartial());
        $this->acl->outputPartial($out);
      }
      $this->checkProtoArray($this->header_override);
      foreach ($this->header_override as $value) {
        $out->putVarInt32(82);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 25:
            $this->setBucketRefillPerSecond($d->getDouble());
            break;
          case 32:
            $this->setBucketCapacity($d->getVarInt32());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setUserSpecifiedRate(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 50:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableRetryParameters()->tryMerge($tmp);
            break;
          case 56:
            $this->setMaxConcurrentRequests($d->getVarInt32());
            break;
          case 64:
            $this->setMode($d->getVarInt32());
            break;
          case 74:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableAcl()->tryMerge($tmp);
            break;
          case 82:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addHeaderOverride()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->bucket_refill_per_second)) return 'bucket_refill_per_second';
      if (!isset($this->bucket_capacity)) return 'bucket_capacity';
      if (isset($this->retry_parameters) && (!$this->retry_parameters->isInitialized())) return 'retry_parameters';
      if (isset($this->acl) && (!$this->acl->isInitialized())) return 'acl';
      foreach ($this->header_override as $value) {
        if (!$value->isInitialized()) return 'header_override';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasBucketRefillPerSecond()) {
        $this->setBucketRefillPerSecond($x->getBucketRefillPerSecond());
      }
      if ($x->hasBucketCapacity()) {
        $this->setBucketCapacity($x->getBucketCapacity());
      }
      if ($x->hasUserSpecifiedRate()) {
        $this->setUserSpecifiedRate($x->getUserSpecifiedRate());
      }
      if ($x->hasRetryParameters()) {
        $this->mutableRetryParameters()->mergeFrom($x->getRetryParameters());
      }
      if ($x->hasMaxConcurrentRequests()) {
        $this->setMaxConcurrentRequests($x->getMaxConcurrentRequests());
      }
      if ($x->hasMode()) {
        $this->setMode($x->getMode());
      }
      if ($x->hasAcl()) {
        $this->mutableAcl()->mergeFrom($x->getAcl());
      }
      foreach ($x->getHeaderOverrideList() as $v) {
        $this->addHeaderOverride()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->bucket_refill_per_second) !== isset($x->bucket_refill_per_second)) return false;
      if (isset($this->bucket_refill_per_second) && $this->bucket_refill_per_second !== $x->bucket_refill_per_second) return false;
      if (isset($this->bucket_capacity) !== isset($x->bucket_capacity)) return false;
      if (isset($this->bucket_capacity) && !$this->integerEquals($this->bucket_capacity, $x->bucket_capacity)) return false;
      if (isset($this->user_specified_rate) !== isset($x->user_specified_rate)) return false;
      if (isset($this->user_specified_rate) && $this->user_specified_rate !== $x->user_specified_rate) return false;
      if (isset($this->retry_parameters) !== isset($x->retry_parameters)) return false;
      if (isset($this->retry_parameters) && !$this->retry_parameters->equals($x->retry_parameters)) return false;
      if (isset($this->max_concurrent_requests) !== isset($x->max_concurrent_requests)) return false;
      if (isset($this->max_concurrent_requests) && !$this->integerEquals($this->max_concurrent_requests, $x->max_concurrent_requests)) return false;
      if (isset($this->mode) !== isset($x->mode)) return false;
      if (isset($this->mode) && $this->mode !== $x->mode) return false;
      if (isset($this->acl) !== isset($x->acl)) return false;
      if (isset($this->acl) && !$this->acl->equals($x->acl)) return false;
      if (sizeof($this->header_override) !== sizeof($x->header_override)) return false;
      foreach (array_map(null, $this->header_override, $x->header_override) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->bucket_refill_per_second)) {
        $res .= $prefix . "bucket_refill_per_second: " . $this->debugFormatDouble($this->bucket_refill_per_second) . "\n";
      }
      if (isset($this->bucket_capacity)) {
        $res .= $prefix . "bucket_capacity: " . $this->debugFormatInt32($this->bucket_capacity) . "\n";
      }
      if (isset($this->user_specified_rate)) {
        $res .= $prefix . "user_specified_rate: " . $this->debugFormatString($this->user_specified_rate) . "\n";
      }
      if (isset($this->retry_parameters)) {
        $res .= $prefix . "retry_parameters <\n" . $this->retry_parameters->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->max_concurrent_requests)) {
        $res .= $prefix . "max_concurrent_requests: " . $this->debugFormatInt32($this->max_concurrent_requests) . "\n";
      }
      if (isset($this->mode)) {
        $res .= $prefix . "mode: " . ($this->mode) . "\n";
      }
      if (isset($this->acl)) {
        $res .= $prefix . "acl <\n" . $this->acl->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->header_override as $value) {
        $res .= $prefix . "header_override <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueUpdateQueueResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueFetchQueuesRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getMaxRows() {
      if (!isset($this->max_rows)) {
        return 0;
      }
      return $this->max_rows;
    }
    public function setMaxRows($val) {
      $this->max_rows = $val;
      return $this;
    }
    public function clearMaxRows() {
      unset($this->max_rows);
      return $this;
    }
    public function hasMaxRows() {
      return isset($this->max_rows);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearMaxRows();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->max_rows)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_rows);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->max_rows)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->max_rows);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setMaxRows($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->max_rows)) return 'max_rows';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasMaxRows()) {
        $this->setMaxRows($x->getMaxRows());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->max_rows) !== isset($x->max_rows)) return false;
      if (isset($this->max_rows) && !$this->integerEquals($this->max_rows, $x->max_rows)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->max_rows)) {
        $res .= $prefix . "max_rows: " . $this->debugFormatInt32($this->max_rows) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueFetchQueuesResponse {
  class Queue extends \google\net\ProtocolMessage {
    private $header_override = array();
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getBucketRefillPerSecond() {
      if (!isset($this->bucket_refill_per_second)) {
        return 0.0;
      }
      return $this->bucket_refill_per_second;
    }
    public function setBucketRefillPerSecond($val) {
      $this->bucket_refill_per_second = $val;
      return $this;
    }
    public function clearBucketRefillPerSecond() {
      unset($this->bucket_refill_per_second);
      return $this;
    }
    public function hasBucketRefillPerSecond() {
      return isset($this->bucket_refill_per_second);
    }
    public function getBucketCapacity() {
      if (!isset($this->bucket_capacity)) {
        return 0.0;
      }
      return $this->bucket_capacity;
    }
    public function setBucketCapacity($val) {
      $this->bucket_capacity = $val;
      return $this;
    }
    public function clearBucketCapacity() {
      unset($this->bucket_capacity);
      return $this;
    }
    public function hasBucketCapacity() {
      return isset($this->bucket_capacity);
    }
    public function getUserSpecifiedRate() {
      if (!isset($this->user_specified_rate)) {
        return '';
      }
      return $this->user_specified_rate;
    }
    public function setUserSpecifiedRate($val) {
      $this->user_specified_rate = $val;
      return $this;
    }
    public function clearUserSpecifiedRate() {
      unset($this->user_specified_rate);
      return $this;
    }
    public function hasUserSpecifiedRate() {
      return isset($this->user_specified_rate);
    }
    public function getPaused() {
      if (!isset($this->paused)) {
        return false;
      }
      return $this->paused;
    }
    public function setPaused($val) {
      $this->paused = $val;
      return $this;
    }
    public function clearPaused() {
      unset($this->paused);
      return $this;
    }
    public function hasPaused() {
      return isset($this->paused);
    }
    public function getRetryParameters() {
      if (!isset($this->retry_parameters)) {
        return new \google\appengine\TaskQueueRetryParameters();
      }
      return $this->retry_parameters;
    }
    public function mutableRetryParameters() {
      if (!isset($this->retry_parameters)) {
        $res = new \google\appengine\TaskQueueRetryParameters();
        $this->retry_parameters = $res;
        return $res;
      }
      return $this->retry_parameters;
    }
    public function clearRetryParameters() {
      if (isset($this->retry_parameters)) {
        unset($this->retry_parameters);
      }
    }
    public function hasRetryParameters() {
      return isset($this->retry_parameters);
    }
    public function getMaxConcurrentRequests() {
      if (!isset($this->max_concurrent_requests)) {
        return 0;
      }
      return $this->max_concurrent_requests;
    }
    public function setMaxConcurrentRequests($val) {
      $this->max_concurrent_requests = $val;
      return $this;
    }
    public function clearMaxConcurrentRequests() {
      unset($this->max_concurrent_requests);
      return $this;
    }
    public function hasMaxConcurrentRequests() {
      return isset($this->max_concurrent_requests);
    }
    public function getMode() {
      if (!isset($this->mode)) {
        return 0;
      }
      return $this->mode;
    }
    public function setMode($val) {
      $this->mode = $val;
      return $this;
    }
    public function clearMode() {
      unset($this->mode);
      return $this;
    }
    public function hasMode() {
      return isset($this->mode);
    }
    public function getAcl() {
      if (!isset($this->acl)) {
        return new \google\appengine\TaskQueueAcl();
      }
      return $this->acl;
    }
    public function mutableAcl() {
      if (!isset($this->acl)) {
        $res = new \google\appengine\TaskQueueAcl();
        $this->acl = $res;
        return $res;
      }
      return $this->acl;
    }
    public function clearAcl() {
      if (isset($this->acl)) {
        unset($this->acl);
      }
    }
    public function hasAcl() {
      return isset($this->acl);
    }
    public function getHeaderOverrideSize() {
      return sizeof($this->header_override);
    }
    public function getHeaderOverrideList() {
      return $this->header_override;
    }
    public function mutableHeaderOverride($idx) {
      if (!isset($this->header_override[$idx])) {
        $val = new \google\appengine\TaskQueueHttpHeader();
        $this->header_override[$idx] = $val;
        return $val;
      }
      return $this->header_override[$idx];
    }
    public function getHeaderOverride($idx) {
      if (isset($this->header_override[$idx])) {
        return $this->header_override[$idx];
      }
      if ($idx >= end(array_keys($this->header_override))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueHttpHeader();
    }
    public function addHeaderOverride() {
      $val = new \google\appengine\TaskQueueHttpHeader();
      $this->header_override[] = $val;
      return $val;
    }
    public function clearHeaderOverride() {
      $this->header_override = array();
    }
    public function getCreatorName() {
      if (!isset($this->creator_name)) {
        return "apphosting";
      }
      return $this->creator_name;
    }
    public function setCreatorName($val) {
      $this->creator_name = $val;
      return $this;
    }
    public function clearCreatorName() {
      unset($this->creator_name);
      return $this;
    }
    public function hasCreatorName() {
      return isset($this->creator_name);
    }
    public function clear() {
      $this->clearQueueName();
      $this->clearBucketRefillPerSecond();
      $this->clearBucketCapacity();
      $this->clearUserSpecifiedRate();
      $this->clearPaused();
      $this->clearRetryParameters();
      $this->clearMaxConcurrentRequests();
      $this->clearMode();
      $this->clearAcl();
      $this->clearHeaderOverride();
      $this->clearCreatorName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->bucket_refill_per_second)) {
        $res += 9;
      }
      if (isset($this->bucket_capacity)) {
        $res += 9;
      }
      if (isset($this->user_specified_rate)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->user_specified_rate));
      }
      if (isset($this->paused)) {
        $res += 2;
      }
      if (isset($this->retry_parameters)) {
        $res += 1;
        $res += $this->lengthString($this->retry_parameters->byteSizePartial());
      }
      if (isset($this->max_concurrent_requests)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_concurrent_requests);
      }
      if (isset($this->mode)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mode);
      }
      if (isset($this->acl)) {
        $res += 1;
        $res += $this->lengthString($this->acl->byteSizePartial());
      }
      $this->checkProtoArray($this->header_override);
      $res += 1 * sizeof($this->header_override);
      foreach ($this->header_override as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->creator_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->creator_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->bucket_refill_per_second)) {
        $out->putVarInt32(25);
        $out->putDouble($this->bucket_refill_per_second);
      }
      if (isset($this->bucket_capacity)) {
        $out->putVarInt32(33);
        $out->putDouble($this->bucket_capacity);
      }
      if (isset($this->user_specified_rate)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->user_specified_rate);
      }
      if (isset($this->paused)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->paused);
      }
      if (isset($this->retry_parameters)) {
        $out->putVarInt32(58);
        $out->putVarInt32($this->retry_parameters->byteSizePartial());
        $this->retry_parameters->outputPartial($out);
      }
      if (isset($this->max_concurrent_requests)) {
        $out->putVarInt32(64);
        $out->putVarInt32($this->max_concurrent_requests);
      }
      if (isset($this->mode)) {
        $out->putVarInt32(72);
        $out->putVarInt32($this->mode);
      }
      if (isset($this->acl)) {
        $out->putVarInt32(82);
        $out->putVarInt32($this->acl->byteSizePartial());
        $this->acl->outputPartial($out);
      }
      $this->checkProtoArray($this->header_override);
      foreach ($this->header_override as $value) {
        $out->putVarInt32(90);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->creator_name)) {
        $out->putVarInt32(98);
        $out->putPrefixedString($this->creator_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 25:
            $this->setBucketRefillPerSecond($d->getDouble());
            break;
          case 33:
            $this->setBucketCapacity($d->getDouble());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setUserSpecifiedRate(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 48:
            $this->setPaused($d->getBoolean());
            break;
          case 58:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableRetryParameters()->tryMerge($tmp);
            break;
          case 64:
            $this->setMaxConcurrentRequests($d->getVarInt32());
            break;
          case 72:
            $this->setMode($d->getVarInt32());
            break;
          case 82:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableAcl()->tryMerge($tmp);
            break;
          case 90:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addHeaderOverride()->tryMerge($tmp);
            break;
          case 98:
            $length = $d->getVarInt32();
            $this->setCreatorName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->bucket_refill_per_second)) return 'bucket_refill_per_second';
      if (!isset($this->bucket_capacity)) return 'bucket_capacity';
      if (!isset($this->paused)) return 'paused';
      if (isset($this->retry_parameters) && (!$this->retry_parameters->isInitialized())) return 'retry_parameters';
      if (isset($this->acl) && (!$this->acl->isInitialized())) return 'acl';
      foreach ($this->header_override as $value) {
        if (!$value->isInitialized()) return 'header_override';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasBucketRefillPerSecond()) {
        $this->setBucketRefillPerSecond($x->getBucketRefillPerSecond());
      }
      if ($x->hasBucketCapacity()) {
        $this->setBucketCapacity($x->getBucketCapacity());
      }
      if ($x->hasUserSpecifiedRate()) {
        $this->setUserSpecifiedRate($x->getUserSpecifiedRate());
      }
      if ($x->hasPaused()) {
        $this->setPaused($x->getPaused());
      }
      if ($x->hasRetryParameters()) {
        $this->mutableRetryParameters()->mergeFrom($x->getRetryParameters());
      }
      if ($x->hasMaxConcurrentRequests()) {
        $this->setMaxConcurrentRequests($x->getMaxConcurrentRequests());
      }
      if ($x->hasMode()) {
        $this->setMode($x->getMode());
      }
      if ($x->hasAcl()) {
        $this->mutableAcl()->mergeFrom($x->getAcl());
      }
      foreach ($x->getHeaderOverrideList() as $v) {
        $this->addHeaderOverride()->copyFrom($v);
      }
      if ($x->hasCreatorName()) {
        $this->setCreatorName($x->getCreatorName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->bucket_refill_per_second) !== isset($x->bucket_refill_per_second)) return false;
      if (isset($this->bucket_refill_per_second) && $this->bucket_refill_per_second !== $x->bucket_refill_per_second) return false;
      if (isset($this->bucket_capacity) !== isset($x->bucket_capacity)) return false;
      if (isset($this->bucket_capacity) && $this->bucket_capacity !== $x->bucket_capacity) return false;
      if (isset($this->user_specified_rate) !== isset($x->user_specified_rate)) return false;
      if (isset($this->user_specified_rate) && $this->user_specified_rate !== $x->user_specified_rate) return false;
      if (isset($this->paused) !== isset($x->paused)) return false;
      if (isset($this->paused) && $this->paused !== $x->paused) return false;
      if (isset($this->retry_parameters) !== isset($x->retry_parameters)) return false;
      if (isset($this->retry_parameters) && !$this->retry_parameters->equals($x->retry_parameters)) return false;
      if (isset($this->max_concurrent_requests) !== isset($x->max_concurrent_requests)) return false;
      if (isset($this->max_concurrent_requests) && !$this->integerEquals($this->max_concurrent_requests, $x->max_concurrent_requests)) return false;
      if (isset($this->mode) !== isset($x->mode)) return false;
      if (isset($this->mode) && $this->mode !== $x->mode) return false;
      if (isset($this->acl) !== isset($x->acl)) return false;
      if (isset($this->acl) && !$this->acl->equals($x->acl)) return false;
      if (sizeof($this->header_override) !== sizeof($x->header_override)) return false;
      foreach (array_map(null, $this->header_override, $x->header_override) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->creator_name) !== isset($x->creator_name)) return false;
      if (isset($this->creator_name) && $this->creator_name !== $x->creator_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->bucket_refill_per_second)) {
        $res .= $prefix . "bucket_refill_per_second: " . $this->debugFormatDouble($this->bucket_refill_per_second) . "\n";
      }
      if (isset($this->bucket_capacity)) {
        $res .= $prefix . "bucket_capacity: " . $this->debugFormatDouble($this->bucket_capacity) . "\n";
      }
      if (isset($this->user_specified_rate)) {
        $res .= $prefix . "user_specified_rate: " . $this->debugFormatString($this->user_specified_rate) . "\n";
      }
      if (isset($this->paused)) {
        $res .= $prefix . "paused: " . $this->debugFormatBool($this->paused) . "\n";
      }
      if (isset($this->retry_parameters)) {
        $res .= $prefix . "retry_parameters <\n" . $this->retry_parameters->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->max_concurrent_requests)) {
        $res .= $prefix . "max_concurrent_requests: " . $this->debugFormatInt32($this->max_concurrent_requests) . "\n";
      }
      if (isset($this->mode)) {
        $res .= $prefix . "mode: " . ($this->mode) . "\n";
      }
      if (isset($this->acl)) {
        $res .= $prefix . "acl <\n" . $this->acl->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->header_override as $value) {
        $res .= $prefix . "header_override <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->creator_name)) {
        $res .= $prefix . "creator_name: " . $this->debugFormatString($this->creator_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueFetchQueuesResponse extends \google\net\ProtocolMessage {
    private $queue = array();
    public function getQueueSize() {
      return sizeof($this->queue);
    }
    public function getQueueList() {
      return $this->queue;
    }
    public function mutableQueue($idx) {
      if (!isset($this->queue[$idx])) {
        $val = new \google\appengine\TaskQueueFetchQueuesResponse\Queue();
        $this->queue[$idx] = $val;
        return $val;
      }
      return $this->queue[$idx];
    }
    public function getQueue($idx) {
      if (isset($this->queue[$idx])) {
        return $this->queue[$idx];
      }
      if ($idx >= end(array_keys($this->queue))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueFetchQueuesResponse\Queue();
    }
    public function addQueue() {
      $val = new \google\appengine\TaskQueueFetchQueuesResponse\Queue();
      $this->queue[] = $val;
      return $val;
    }
    public function clearQueue() {
      $this->queue = array();
    }
    public function clear() {
      $this->clearQueue();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->queue);
      $res += 2 * sizeof($this->queue);
      foreach ($this->queue as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->queue);
      foreach ($this->queue as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addQueue()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->queue as $value) {
        if (!$value->isInitialized()) return 'queue';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getQueueList() as $v) {
        $this->addQueue()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->queue) !== sizeof($x->queue)) return false;
      foreach (array_map(null, $this->queue, $x->queue) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->queue as $value) {
        $res .= $prefix . "Queue {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueFetchQueueStatsRequest extends \google\net\ProtocolMessage {
    private $queue_name = array();
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueNameSize() {
      return sizeof($this->queue_name);
    }
    public function getQueueNameList() {
      return $this->queue_name;
    }
    public function getQueueName($idx) {
      return $this->queue_name[$idx];
    }
    public function setQueueName($idx, $val) {
      $this->queue_name[$idx] = $val;
      return $this;
    }
    public function addQueueName($val) {
      $this->queue_name[] = $val;
      return $this;
    }
    public function clearQueueName() {
      $this->queue_name = array();
    }
    public function getMaxNumTasks() {
      if (!isset($this->max_num_tasks)) {
        return 0;
      }
      return $this->max_num_tasks;
    }
    public function setMaxNumTasks($val) {
      $this->max_num_tasks = $val;
      return $this;
    }
    public function clearMaxNumTasks() {
      unset($this->max_num_tasks);
      return $this;
    }
    public function hasMaxNumTasks() {
      return isset($this->max_num_tasks);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
      $this->clearMaxNumTasks();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      $this->checkProtoArray($this->queue_name);
      $res += 1 * sizeof($this->queue_name);
      foreach ($this->queue_name as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->max_num_tasks)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_num_tasks);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      $this->checkProtoArray($this->queue_name);
      foreach ($this->queue_name as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
      if (isset($this->max_num_tasks)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->max_num_tasks);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setMaxNumTasks($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      foreach ($x->getQueueNameList() as $v) {
        $this->addQueueName($v);
      }
      if ($x->hasMaxNumTasks()) {
        $this->setMaxNumTasks($x->getMaxNumTasks());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (sizeof($this->queue_name) !== sizeof($x->queue_name)) return false;
      foreach (array_map(null, $this->queue_name, $x->queue_name) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->max_num_tasks) !== isset($x->max_num_tasks)) return false;
      if (isset($this->max_num_tasks) && !$this->integerEquals($this->max_num_tasks, $x->max_num_tasks)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      foreach ($this->queue_name as $value) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->max_num_tasks)) {
        $res .= $prefix . "max_num_tasks: " . $this->debugFormatInt32($this->max_num_tasks) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueScannerQueueInfo extends \google\net\ProtocolMessage {
    public function getExecutedLastMinute() {
      if (!isset($this->executed_last_minute)) {
        return "0";
      }
      return $this->executed_last_minute;
    }
    public function setExecutedLastMinute($val) {
      if (is_double($val)) {
        $this->executed_last_minute = sprintf('%0.0F', $val);
      } else {
        $this->executed_last_minute = $val;
      }
      return $this;
    }
    public function clearExecutedLastMinute() {
      unset($this->executed_last_minute);
      return $this;
    }
    public function hasExecutedLastMinute() {
      return isset($this->executed_last_minute);
    }
    public function getExecutedLastHour() {
      if (!isset($this->executed_last_hour)) {
        return "0";
      }
      return $this->executed_last_hour;
    }
    public function setExecutedLastHour($val) {
      if (is_double($val)) {
        $this->executed_last_hour = sprintf('%0.0F', $val);
      } else {
        $this->executed_last_hour = $val;
      }
      return $this;
    }
    public function clearExecutedLastHour() {
      unset($this->executed_last_hour);
      return $this;
    }
    public function hasExecutedLastHour() {
      return isset($this->executed_last_hour);
    }
    public function getSamplingDurationSeconds() {
      if (!isset($this->sampling_duration_seconds)) {
        return 0.0;
      }
      return $this->sampling_duration_seconds;
    }
    public function setSamplingDurationSeconds($val) {
      $this->sampling_duration_seconds = $val;
      return $this;
    }
    public function clearSamplingDurationSeconds() {
      unset($this->sampling_duration_seconds);
      return $this;
    }
    public function hasSamplingDurationSeconds() {
      return isset($this->sampling_duration_seconds);
    }
    public function getRequestsInFlight() {
      if (!isset($this->requests_in_flight)) {
        return 0;
      }
      return $this->requests_in_flight;
    }
    public function setRequestsInFlight($val) {
      $this->requests_in_flight = $val;
      return $this;
    }
    public function clearRequestsInFlight() {
      unset($this->requests_in_flight);
      return $this;
    }
    public function hasRequestsInFlight() {
      return isset($this->requests_in_flight);
    }
    public function getEnforcedRate() {
      if (!isset($this->enforced_rate)) {
        return 0.0;
      }
      return $this->enforced_rate;
    }
    public function setEnforcedRate($val) {
      $this->enforced_rate = $val;
      return $this;
    }
    public function clearEnforcedRate() {
      unset($this->enforced_rate);
      return $this;
    }
    public function hasEnforcedRate() {
      return isset($this->enforced_rate);
    }
    public function clear() {
      $this->clearExecutedLastMinute();
      $this->clearExecutedLastHour();
      $this->clearSamplingDurationSeconds();
      $this->clearRequestsInFlight();
      $this->clearEnforcedRate();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->executed_last_minute)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->executed_last_minute);
      }
      if (isset($this->executed_last_hour)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->executed_last_hour);
      }
      if (isset($this->sampling_duration_seconds)) {
        $res += 9;
      }
      if (isset($this->requests_in_flight)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->requests_in_flight);
      }
      if (isset($this->enforced_rate)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->executed_last_minute)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->executed_last_minute);
      }
      if (isset($this->executed_last_hour)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->executed_last_hour);
      }
      if (isset($this->sampling_duration_seconds)) {
        $out->putVarInt32(25);
        $out->putDouble($this->sampling_duration_seconds);
      }
      if (isset($this->requests_in_flight)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->requests_in_flight);
      }
      if (isset($this->enforced_rate)) {
        $out->putVarInt32(41);
        $out->putDouble($this->enforced_rate);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setExecutedLastMinute($d->getVarInt64());
            break;
          case 16:
            $this->setExecutedLastHour($d->getVarInt64());
            break;
          case 25:
            $this->setSamplingDurationSeconds($d->getDouble());
            break;
          case 32:
            $this->setRequestsInFlight($d->getVarInt32());
            break;
          case 41:
            $this->setEnforcedRate($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->executed_last_minute)) return 'executed_last_minute';
      if (!isset($this->executed_last_hour)) return 'executed_last_hour';
      if (!isset($this->sampling_duration_seconds)) return 'sampling_duration_seconds';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasExecutedLastMinute()) {
        $this->setExecutedLastMinute($x->getExecutedLastMinute());
      }
      if ($x->hasExecutedLastHour()) {
        $this->setExecutedLastHour($x->getExecutedLastHour());
      }
      if ($x->hasSamplingDurationSeconds()) {
        $this->setSamplingDurationSeconds($x->getSamplingDurationSeconds());
      }
      if ($x->hasRequestsInFlight()) {
        $this->setRequestsInFlight($x->getRequestsInFlight());
      }
      if ($x->hasEnforcedRate()) {
        $this->setEnforcedRate($x->getEnforcedRate());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->executed_last_minute) !== isset($x->executed_last_minute)) return false;
      if (isset($this->executed_last_minute) && !$this->integerEquals($this->executed_last_minute, $x->executed_last_minute)) return false;
      if (isset($this->executed_last_hour) !== isset($x->executed_last_hour)) return false;
      if (isset($this->executed_last_hour) && !$this->integerEquals($this->executed_last_hour, $x->executed_last_hour)) return false;
      if (isset($this->sampling_duration_seconds) !== isset($x->sampling_duration_seconds)) return false;
      if (isset($this->sampling_duration_seconds) && $this->sampling_duration_seconds !== $x->sampling_duration_seconds) return false;
      if (isset($this->requests_in_flight) !== isset($x->requests_in_flight)) return false;
      if (isset($this->requests_in_flight) && !$this->integerEquals($this->requests_in_flight, $x->requests_in_flight)) return false;
      if (isset($this->enforced_rate) !== isset($x->enforced_rate)) return false;
      if (isset($this->enforced_rate) && $this->enforced_rate !== $x->enforced_rate) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->executed_last_minute)) {
        $res .= $prefix . "executed_last_minute: " . $this->debugFormatInt64($this->executed_last_minute) . "\n";
      }
      if (isset($this->executed_last_hour)) {
        $res .= $prefix . "executed_last_hour: " . $this->debugFormatInt64($this->executed_last_hour) . "\n";
      }
      if (isset($this->sampling_duration_seconds)) {
        $res .= $prefix . "sampling_duration_seconds: " . $this->debugFormatDouble($this->sampling_duration_seconds) . "\n";
      }
      if (isset($this->requests_in_flight)) {
        $res .= $prefix . "requests_in_flight: " . $this->debugFormatInt32($this->requests_in_flight) . "\n";
      }
      if (isset($this->enforced_rate)) {
        $res .= $prefix . "enforced_rate: " . $this->debugFormatDouble($this->enforced_rate) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueFetchQueueStatsResponse {
  class QueueStats extends \google\net\ProtocolMessage {
    public function getNumTasks() {
      if (!isset($this->num_tasks)) {
        return 0;
      }
      return $this->num_tasks;
    }
    public function setNumTasks($val) {
      $this->num_tasks = $val;
      return $this;
    }
    public function clearNumTasks() {
      unset($this->num_tasks);
      return $this;
    }
    public function hasNumTasks() {
      return isset($this->num_tasks);
    }
    public function getOldestEtaUsec() {
      if (!isset($this->oldest_eta_usec)) {
        return "0";
      }
      return $this->oldest_eta_usec;
    }
    public function setOldestEtaUsec($val) {
      if (is_double($val)) {
        $this->oldest_eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->oldest_eta_usec = $val;
      }
      return $this;
    }
    public function clearOldestEtaUsec() {
      unset($this->oldest_eta_usec);
      return $this;
    }
    public function hasOldestEtaUsec() {
      return isset($this->oldest_eta_usec);
    }
    public function getScannerInfo() {
      if (!isset($this->scanner_info)) {
        return new \google\appengine\TaskQueueScannerQueueInfo();
      }
      return $this->scanner_info;
    }
    public function mutableScannerInfo() {
      if (!isset($this->scanner_info)) {
        $res = new \google\appengine\TaskQueueScannerQueueInfo();
        $this->scanner_info = $res;
        return $res;
      }
      return $this->scanner_info;
    }
    public function clearScannerInfo() {
      if (isset($this->scanner_info)) {
        unset($this->scanner_info);
      }
    }
    public function hasScannerInfo() {
      return isset($this->scanner_info);
    }
    public function clear() {
      $this->clearNumTasks();
      $this->clearOldestEtaUsec();
      $this->clearScannerInfo();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->num_tasks)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->num_tasks);
      }
      if (isset($this->oldest_eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->oldest_eta_usec);
      }
      if (isset($this->scanner_info)) {
        $res += 1;
        $res += $this->lengthString($this->scanner_info->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->num_tasks)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->num_tasks);
      }
      if (isset($this->oldest_eta_usec)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->oldest_eta_usec);
      }
      if (isset($this->scanner_info)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->scanner_info->byteSizePartial());
        $this->scanner_info->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 16:
            $this->setNumTasks($d->getVarInt32());
            break;
          case 24:
            $this->setOldestEtaUsec($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableScannerInfo()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->num_tasks)) return 'num_tasks';
      if (!isset($this->oldest_eta_usec)) return 'oldest_eta_usec';
      if (isset($this->scanner_info) && (!$this->scanner_info->isInitialized())) return 'scanner_info';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasNumTasks()) {
        $this->setNumTasks($x->getNumTasks());
      }
      if ($x->hasOldestEtaUsec()) {
        $this->setOldestEtaUsec($x->getOldestEtaUsec());
      }
      if ($x->hasScannerInfo()) {
        $this->mutableScannerInfo()->mergeFrom($x->getScannerInfo());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->num_tasks) !== isset($x->num_tasks)) return false;
      if (isset($this->num_tasks) && !$this->integerEquals($this->num_tasks, $x->num_tasks)) return false;
      if (isset($this->oldest_eta_usec) !== isset($x->oldest_eta_usec)) return false;
      if (isset($this->oldest_eta_usec) && !$this->integerEquals($this->oldest_eta_usec, $x->oldest_eta_usec)) return false;
      if (isset($this->scanner_info) !== isset($x->scanner_info)) return false;
      if (isset($this->scanner_info) && !$this->scanner_info->equals($x->scanner_info)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->num_tasks)) {
        $res .= $prefix . "num_tasks: " . $this->debugFormatInt32($this->num_tasks) . "\n";
      }
      if (isset($this->oldest_eta_usec)) {
        $res .= $prefix . "oldest_eta_usec: " . $this->debugFormatInt64($this->oldest_eta_usec) . "\n";
      }
      if (isset($this->scanner_info)) {
        $res .= $prefix . "scanner_info <\n" . $this->scanner_info->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueFetchQueueStatsResponse extends \google\net\ProtocolMessage {
    private $queuestats = array();
    public function getQueueStatsSize() {
      return sizeof($this->queuestats);
    }
    public function getQueueStatsList() {
      return $this->queuestats;
    }
    public function mutableQueueStats($idx) {
      if (!isset($this->queuestats[$idx])) {
        $val = new \google\appengine\TaskQueueFetchQueueStatsResponse\QueueStats();
        $this->queuestats[$idx] = $val;
        return $val;
      }
      return $this->queuestats[$idx];
    }
    public function getQueueStats($idx) {
      if (isset($this->queuestats[$idx])) {
        return $this->queuestats[$idx];
      }
      if ($idx >= end(array_keys($this->queuestats))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueFetchQueueStatsResponse\QueueStats();
    }
    public function addQueueStats() {
      $val = new \google\appengine\TaskQueueFetchQueueStatsResponse\QueueStats();
      $this->queuestats[] = $val;
      return $val;
    }
    public function clearQueueStats() {
      $this->queuestats = array();
    }
    public function clear() {
      $this->clearQueueStats();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->queuestats);
      $res += 2 * sizeof($this->queuestats);
      foreach ($this->queuestats as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->queuestats);
      foreach ($this->queuestats as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addQueueStats()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->queuestats as $value) {
        if (!$value->isInitialized()) return 'queuestats';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getQueueStatsList() as $v) {
        $this->addQueueStats()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->queuestats) !== sizeof($x->queuestats)) return false;
      foreach (array_map(null, $this->queuestats, $x->queuestats) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->queuestats as $value) {
        $res .= $prefix . "QueueStats {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueuePauseQueueRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getPause() {
      if (!isset($this->pause)) {
        return false;
      }
      return $this->pause;
    }
    public function setPause($val) {
      $this->pause = $val;
      return $this;
    }
    public function clearPause() {
      unset($this->pause);
      return $this;
    }
    public function hasPause() {
      return isset($this->pause);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
      $this->clearPause();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->pause)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->pause)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->pause);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setPause($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->pause)) return 'pause';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasPause()) {
        $this->setPause($x->getPause());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->pause) !== isset($x->pause)) return false;
      if (isset($this->pause) && $this->pause !== $x->pause) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->pause)) {
        $res .= $prefix . "pause: " . $this->debugFormatBool($this->pause) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueuePauseQueueResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueuePurgeQueueRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueuePurgeQueueResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueDeleteQueueRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      if (!isset($this->queue_name)) return 'queue_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueDeleteQueueResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueDeleteGroupRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function clear() {
      $this->clearAppId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueDeleteGroupResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueQueryTasksRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getStartTaskName() {
      if (!isset($this->start_task_name)) {
        return '';
      }
      return $this->start_task_name;
    }
    public function setStartTaskName($val) {
      $this->start_task_name = $val;
      return $this;
    }
    public function clearStartTaskName() {
      unset($this->start_task_name);
      return $this;
    }
    public function hasStartTaskName() {
      return isset($this->start_task_name);
    }
    public function getStartEtaUsec() {
      if (!isset($this->start_eta_usec)) {
        return "0";
      }
      return $this->start_eta_usec;
    }
    public function setStartEtaUsec($val) {
      if (is_double($val)) {
        $this->start_eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->start_eta_usec = $val;
      }
      return $this;
    }
    public function clearStartEtaUsec() {
      unset($this->start_eta_usec);
      return $this;
    }
    public function hasStartEtaUsec() {
      return isset($this->start_eta_usec);
    }
    public function getMaxRows() {
      if (!isset($this->max_rows)) {
        return 1;
      }
      return $this->max_rows;
    }
    public function setMaxRows($val) {
      $this->max_rows = $val;
      return $this;
    }
    public function clearMaxRows() {
      unset($this->max_rows);
      return $this;
    }
    public function hasMaxRows() {
      return isset($this->max_rows);
    }
    public function getStartTag() {
      if (!isset($this->start_tag)) {
        return '';
      }
      return $this->start_tag;
    }
    public function setStartTag($val) {
      $this->start_tag = $val;
      return $this;
    }
    public function clearStartTag() {
      unset($this->start_tag);
      return $this;
    }
    public function hasStartTag() {
      return isset($this->start_tag);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
      $this->clearStartTaskName();
      $this->clearStartEtaUsec();
      $this->clearMaxRows();
      $this->clearStartTag();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->start_task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->start_task_name));
      }
      if (isset($this->start_eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start_eta_usec);
      }
      if (isset($this->max_rows)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_rows);
      }
      if (isset($this->start_tag)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->start_tag));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->start_task_name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->start_task_name);
      }
      if (isset($this->start_eta_usec)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->start_eta_usec);
      }
      if (isset($this->max_rows)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->max_rows);
      }
      if (isset($this->start_tag)) {
        $out->putVarInt32(50);
        $out->putPrefixedString($this->start_tag);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setStartTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 32:
            $this->setStartEtaUsec($d->getVarInt64());
            break;
          case 40:
            $this->setMaxRows($d->getVarInt32());
            break;
          case 50:
            $length = $d->getVarInt32();
            $this->setStartTag(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasStartTaskName()) {
        $this->setStartTaskName($x->getStartTaskName());
      }
      if ($x->hasStartEtaUsec()) {
        $this->setStartEtaUsec($x->getStartEtaUsec());
      }
      if ($x->hasMaxRows()) {
        $this->setMaxRows($x->getMaxRows());
      }
      if ($x->hasStartTag()) {
        $this->setStartTag($x->getStartTag());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->start_task_name) !== isset($x->start_task_name)) return false;
      if (isset($this->start_task_name) && $this->start_task_name !== $x->start_task_name) return false;
      if (isset($this->start_eta_usec) !== isset($x->start_eta_usec)) return false;
      if (isset($this->start_eta_usec) && !$this->integerEquals($this->start_eta_usec, $x->start_eta_usec)) return false;
      if (isset($this->max_rows) !== isset($x->max_rows)) return false;
      if (isset($this->max_rows) && !$this->integerEquals($this->max_rows, $x->max_rows)) return false;
      if (isset($this->start_tag) !== isset($x->start_tag)) return false;
      if (isset($this->start_tag) && $this->start_tag !== $x->start_tag) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->start_task_name)) {
        $res .= $prefix . "start_task_name: " . $this->debugFormatString($this->start_task_name) . "\n";
      }
      if (isset($this->start_eta_usec)) {
        $res .= $prefix . "start_eta_usec: " . $this->debugFormatInt64($this->start_eta_usec) . "\n";
      }
      if (isset($this->max_rows)) {
        $res .= $prefix . "max_rows: " . $this->debugFormatInt32($this->max_rows) . "\n";
      }
      if (isset($this->start_tag)) {
        $res .= $prefix . "start_tag: " . $this->debugFormatString($this->start_tag) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueQueryTasksResponse\Task {
  class RequestMethod {
    const GET = 1;
    const POST = 2;
    const HEAD = 3;
    const PUT = 4;
    const DELETE = 5;
  }
}
namespace google\appengine\TaskQueueQueryTasksResponse\Task {
  class Header extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(66);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(74);
        $out->putPrefixedString($this->value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 60: return;
          case 66:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 74:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueQueryTasksResponse\Task {
  class CronTimetable extends \google\net\ProtocolMessage {
    public function getSchedule() {
      if (!isset($this->schedule)) {
        return '';
      }
      return $this->schedule;
    }
    public function setSchedule($val) {
      $this->schedule = $val;
      return $this;
    }
    public function clearSchedule() {
      unset($this->schedule);
      return $this;
    }
    public function hasSchedule() {
      return isset($this->schedule);
    }
    public function getTimezone() {
      if (!isset($this->timezone)) {
        return '';
      }
      return $this->timezone;
    }
    public function setTimezone($val) {
      $this->timezone = $val;
      return $this;
    }
    public function clearTimezone() {
      unset($this->timezone);
      return $this;
    }
    public function hasTimezone() {
      return isset($this->timezone);
    }
    public function clear() {
      $this->clearSchedule();
      $this->clearTimezone();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->schedule)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->schedule));
      }
      if (isset($this->timezone)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->timezone));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->schedule)) {
        $out->putVarInt32(114);
        $out->putPrefixedString($this->schedule);
      }
      if (isset($this->timezone)) {
        $out->putVarInt32(122);
        $out->putPrefixedString($this->timezone);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 108: return;
          case 114:
            $length = $d->getVarInt32();
            $this->setSchedule(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 122:
            $length = $d->getVarInt32();
            $this->setTimezone(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->schedule)) return 'schedule';
      if (!isset($this->timezone)) return 'timezone';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasSchedule()) {
        $this->setSchedule($x->getSchedule());
      }
      if ($x->hasTimezone()) {
        $this->setTimezone($x->getTimezone());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->schedule) !== isset($x->schedule)) return false;
      if (isset($this->schedule) && $this->schedule !== $x->schedule) return false;
      if (isset($this->timezone) !== isset($x->timezone)) return false;
      if (isset($this->timezone) && $this->timezone !== $x->timezone) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->schedule)) {
        $res .= $prefix . "schedule: " . $this->debugFormatString($this->schedule) . "\n";
      }
      if (isset($this->timezone)) {
        $res .= $prefix . "timezone: " . $this->debugFormatString($this->timezone) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueQueryTasksResponse\Task {
  class RunLog extends \google\net\ProtocolMessage {
    public function getDispatchedUsec() {
      if (!isset($this->dispatched_usec)) {
        return "0";
      }
      return $this->dispatched_usec;
    }
    public function setDispatchedUsec($val) {
      if (is_double($val)) {
        $this->dispatched_usec = sprintf('%0.0F', $val);
      } else {
        $this->dispatched_usec = $val;
      }
      return $this;
    }
    public function clearDispatchedUsec() {
      unset($this->dispatched_usec);
      return $this;
    }
    public function hasDispatchedUsec() {
      return isset($this->dispatched_usec);
    }
    public function getLagUsec() {
      if (!isset($this->lag_usec)) {
        return "0";
      }
      return $this->lag_usec;
    }
    public function setLagUsec($val) {
      if (is_double($val)) {
        $this->lag_usec = sprintf('%0.0F', $val);
      } else {
        $this->lag_usec = $val;
      }
      return $this;
    }
    public function clearLagUsec() {
      unset($this->lag_usec);
      return $this;
    }
    public function hasLagUsec() {
      return isset($this->lag_usec);
    }
    public function getElapsedUsec() {
      if (!isset($this->elapsed_usec)) {
        return "0";
      }
      return $this->elapsed_usec;
    }
    public function setElapsedUsec($val) {
      if (is_double($val)) {
        $this->elapsed_usec = sprintf('%0.0F', $val);
      } else {
        $this->elapsed_usec = $val;
      }
      return $this;
    }
    public function clearElapsedUsec() {
      unset($this->elapsed_usec);
      return $this;
    }
    public function hasElapsedUsec() {
      return isset($this->elapsed_usec);
    }
    public function getResponseCode() {
      if (!isset($this->response_code)) {
        return "0";
      }
      return $this->response_code;
    }
    public function setResponseCode($val) {
      if (is_double($val)) {
        $this->response_code = sprintf('%0.0F', $val);
      } else {
        $this->response_code = $val;
      }
      return $this;
    }
    public function clearResponseCode() {
      unset($this->response_code);
      return $this;
    }
    public function hasResponseCode() {
      return isset($this->response_code);
    }
    public function getRetryReason() {
      if (!isset($this->retry_reason)) {
        return '';
      }
      return $this->retry_reason;
    }
    public function setRetryReason($val) {
      $this->retry_reason = $val;
      return $this;
    }
    public function clearRetryReason() {
      unset($this->retry_reason);
      return $this;
    }
    public function hasRetryReason() {
      return isset($this->retry_reason);
    }
    public function clear() {
      $this->clearDispatchedUsec();
      $this->clearLagUsec();
      $this->clearElapsedUsec();
      $this->clearResponseCode();
      $this->clearRetryReason();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->dispatched_usec)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->dispatched_usec);
      }
      if (isset($this->lag_usec)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->lag_usec);
      }
      if (isset($this->elapsed_usec)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->elapsed_usec);
      }
      if (isset($this->response_code)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->response_code);
      }
      if (isset($this->retry_reason)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->retry_reason));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->dispatched_usec)) {
        $out->putVarInt32(136);
        $out->putVarInt64($this->dispatched_usec);
      }
      if (isset($this->lag_usec)) {
        $out->putVarInt32(144);
        $out->putVarInt64($this->lag_usec);
      }
      if (isset($this->elapsed_usec)) {
        $out->putVarInt32(152);
        $out->putVarInt64($this->elapsed_usec);
      }
      if (isset($this->response_code)) {
        $out->putVarInt32(160);
        $out->putVarInt64($this->response_code);
      }
      if (isset($this->retry_reason)) {
        $out->putVarInt32(218);
        $out->putPrefixedString($this->retry_reason);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 132: return;
          case 136:
            $this->setDispatchedUsec($d->getVarInt64());
            break;
          case 144:
            $this->setLagUsec($d->getVarInt64());
            break;
          case 152:
            $this->setElapsedUsec($d->getVarInt64());
            break;
          case 160:
            $this->setResponseCode($d->getVarInt64());
            break;
          case 218:
            $length = $d->getVarInt32();
            $this->setRetryReason(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->dispatched_usec)) return 'dispatched_usec';
      if (!isset($this->lag_usec)) return 'lag_usec';
      if (!isset($this->elapsed_usec)) return 'elapsed_usec';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasDispatchedUsec()) {
        $this->setDispatchedUsec($x->getDispatchedUsec());
      }
      if ($x->hasLagUsec()) {
        $this->setLagUsec($x->getLagUsec());
      }
      if ($x->hasElapsedUsec()) {
        $this->setElapsedUsec($x->getElapsedUsec());
      }
      if ($x->hasResponseCode()) {
        $this->setResponseCode($x->getResponseCode());
      }
      if ($x->hasRetryReason()) {
        $this->setRetryReason($x->getRetryReason());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->dispatched_usec) !== isset($x->dispatched_usec)) return false;
      if (isset($this->dispatched_usec) && !$this->integerEquals($this->dispatched_usec, $x->dispatched_usec)) return false;
      if (isset($this->lag_usec) !== isset($x->lag_usec)) return false;
      if (isset($this->lag_usec) && !$this->integerEquals($this->lag_usec, $x->lag_usec)) return false;
      if (isset($this->elapsed_usec) !== isset($x->elapsed_usec)) return false;
      if (isset($this->elapsed_usec) && !$this->integerEquals($this->elapsed_usec, $x->elapsed_usec)) return false;
      if (isset($this->response_code) !== isset($x->response_code)) return false;
      if (isset($this->response_code) && !$this->integerEquals($this->response_code, $x->response_code)) return false;
      if (isset($this->retry_reason) !== isset($x->retry_reason)) return false;
      if (isset($this->retry_reason) && $this->retry_reason !== $x->retry_reason) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->dispatched_usec)) {
        $res .= $prefix . "dispatched_usec: " . $this->debugFormatInt64($this->dispatched_usec) . "\n";
      }
      if (isset($this->lag_usec)) {
        $res .= $prefix . "lag_usec: " . $this->debugFormatInt64($this->lag_usec) . "\n";
      }
      if (isset($this->elapsed_usec)) {
        $res .= $prefix . "elapsed_usec: " . $this->debugFormatInt64($this->elapsed_usec) . "\n";
      }
      if (isset($this->response_code)) {
        $res .= $prefix . "response_code: " . $this->debugFormatInt64($this->response_code) . "\n";
      }
      if (isset($this->retry_reason)) {
        $res .= $prefix . "retry_reason: " . $this->debugFormatString($this->retry_reason) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueQueryTasksResponse {
  class Task extends \google\net\ProtocolMessage {
    private $header = array();
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function getEtaUsec() {
      if (!isset($this->eta_usec)) {
        return "0";
      }
      return $this->eta_usec;
    }
    public function setEtaUsec($val) {
      if (is_double($val)) {
        $this->eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->eta_usec = $val;
      }
      return $this;
    }
    public function clearEtaUsec() {
      unset($this->eta_usec);
      return $this;
    }
    public function hasEtaUsec() {
      return isset($this->eta_usec);
    }
    public function getUrl() {
      if (!isset($this->url)) {
        return '';
      }
      return $this->url;
    }
    public function setUrl($val) {
      $this->url = $val;
      return $this;
    }
    public function clearUrl() {
      unset($this->url);
      return $this;
    }
    public function hasUrl() {
      return isset($this->url);
    }
    public function getMethod() {
      if (!isset($this->method)) {
        return 1;
      }
      return $this->method;
    }
    public function setMethod($val) {
      $this->method = $val;
      return $this;
    }
    public function clearMethod() {
      unset($this->method);
      return $this;
    }
    public function hasMethod() {
      return isset($this->method);
    }
    public function getRetryCount() {
      if (!isset($this->retry_count)) {
        return 0;
      }
      return $this->retry_count;
    }
    public function setRetryCount($val) {
      $this->retry_count = $val;
      return $this;
    }
    public function clearRetryCount() {
      unset($this->retry_count);
      return $this;
    }
    public function hasRetryCount() {
      return isset($this->retry_count);
    }
    public function getHeaderSize() {
      return sizeof($this->header);
    }
    public function getHeaderList() {
      return $this->header;
    }
    public function mutableHeader($idx) {
      if (!isset($this->header[$idx])) {
        $val = new \google\appengine\TaskQueueQueryTasksResponse\Task\Header();
        $this->header[$idx] = $val;
        return $val;
      }
      return $this->header[$idx];
    }
    public function getHeader($idx) {
      if (isset($this->header[$idx])) {
        return $this->header[$idx];
      }
      if ($idx >= end(array_keys($this->header))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueQueryTasksResponse\Task\Header();
    }
    public function addHeader() {
      $val = new \google\appengine\TaskQueueQueryTasksResponse\Task\Header();
      $this->header[] = $val;
      return $val;
    }
    public function clearHeader() {
      $this->header = array();
    }
    public function getBodySize() {
      if (!isset($this->body_size)) {
        return 0;
      }
      return $this->body_size;
    }
    public function setBodySize($val) {
      $this->body_size = $val;
      return $this;
    }
    public function clearBodySize() {
      unset($this->body_size);
      return $this;
    }
    public function hasBodySize() {
      return isset($this->body_size);
    }
    public function getBody() {
      if (!isset($this->body)) {
        return '';
      }
      return $this->body;
    }
    public function setBody($val) {
      $this->body = $val;
      return $this;
    }
    public function clearBody() {
      unset($this->body);
      return $this;
    }
    public function hasBody() {
      return isset($this->body);
    }
    public function getCreationTimeUsec() {
      if (!isset($this->creation_time_usec)) {
        return "0";
      }
      return $this->creation_time_usec;
    }
    public function setCreationTimeUsec($val) {
      if (is_double($val)) {
        $this->creation_time_usec = sprintf('%0.0F', $val);
      } else {
        $this->creation_time_usec = $val;
      }
      return $this;
    }
    public function clearCreationTimeUsec() {
      unset($this->creation_time_usec);
      return $this;
    }
    public function hasCreationTimeUsec() {
      return isset($this->creation_time_usec);
    }
    public function getCronTimetable() {
      if (!isset($this->crontimetable)) {
        return new \google\appengine\TaskQueueQueryTasksResponse\Task\CronTimetable();
      }
      return $this->crontimetable;
    }
    public function mutableCronTimetable() {
      if (!isset($this->crontimetable)) {
        $res = new \google\appengine\TaskQueueQueryTasksResponse\Task\CronTimetable();
        $this->crontimetable = $res;
        return $res;
      }
      return $this->crontimetable;
    }
    public function clearCronTimetable() {
      if (isset($this->crontimetable)) {
        unset($this->crontimetable);
      }
    }
    public function hasCronTimetable() {
      return isset($this->crontimetable);
    }
    public function getRunLog() {
      if (!isset($this->runlog)) {
        return new \google\appengine\TaskQueueQueryTasksResponse\Task\RunLog();
      }
      return $this->runlog;
    }
    public function mutableRunLog() {
      if (!isset($this->runlog)) {
        $res = new \google\appengine\TaskQueueQueryTasksResponse\Task\RunLog();
        $this->runlog = $res;
        return $res;
      }
      return $this->runlog;
    }
    public function clearRunLog() {
      if (isset($this->runlog)) {
        unset($this->runlog);
      }
    }
    public function hasRunLog() {
      return isset($this->runlog);
    }
    public function getDescription() {
      if (!isset($this->description)) {
        return '';
      }
      return $this->description;
    }
    public function setDescription($val) {
      $this->description = $val;
      return $this;
    }
    public function clearDescription() {
      unset($this->description);
      return $this;
    }
    public function hasDescription() {
      return isset($this->description);
    }
    public function getPayload() {
      if (!isset($this->payload)) {
        return new \google\appengine\TaskPayload();
      }
      return $this->payload;
    }
    public function mutablePayload() {
      if (!isset($this->payload)) {
        $res = new \google\appengine\TaskPayload();
        $this->payload = $res;
        return $res;
      }
      return $this->payload;
    }
    public function clearPayload() {
      if (isset($this->payload)) {
        unset($this->payload);
      }
    }
    public function hasPayload() {
      return isset($this->payload);
    }
    public function getRetryParameters() {
      if (!isset($this->retry_parameters)) {
        return new \google\appengine\TaskQueueRetryParameters();
      }
      return $this->retry_parameters;
    }
    public function mutableRetryParameters() {
      if (!isset($this->retry_parameters)) {
        $res = new \google\appengine\TaskQueueRetryParameters();
        $this->retry_parameters = $res;
        return $res;
      }
      return $this->retry_parameters;
    }
    public function clearRetryParameters() {
      if (isset($this->retry_parameters)) {
        unset($this->retry_parameters);
      }
    }
    public function hasRetryParameters() {
      return isset($this->retry_parameters);
    }
    public function getFirstTryUsec() {
      if (!isset($this->first_try_usec)) {
        return "0";
      }
      return $this->first_try_usec;
    }
    public function setFirstTryUsec($val) {
      if (is_double($val)) {
        $this->first_try_usec = sprintf('%0.0F', $val);
      } else {
        $this->first_try_usec = $val;
      }
      return $this;
    }
    public function clearFirstTryUsec() {
      unset($this->first_try_usec);
      return $this;
    }
    public function hasFirstTryUsec() {
      return isset($this->first_try_usec);
    }
    public function getTag() {
      if (!isset($this->tag)) {
        return '';
      }
      return $this->tag;
    }
    public function setTag($val) {
      $this->tag = $val;
      return $this;
    }
    public function clearTag() {
      unset($this->tag);
      return $this;
    }
    public function hasTag() {
      return isset($this->tag);
    }
    public function getExecutionCount() {
      if (!isset($this->execution_count)) {
        return 0;
      }
      return $this->execution_count;
    }
    public function setExecutionCount($val) {
      $this->execution_count = $val;
      return $this;
    }
    public function clearExecutionCount() {
      unset($this->execution_count);
      return $this;
    }
    public function hasExecutionCount() {
      return isset($this->execution_count);
    }
    public function clear() {
      $this->clearTaskName();
      $this->clearEtaUsec();
      $this->clearUrl();
      $this->clearMethod();
      $this->clearRetryCount();
      $this->clearHeader();
      $this->clearBodySize();
      $this->clearBody();
      $this->clearCreationTimeUsec();
      $this->clearCronTimetable();
      $this->clearRunLog();
      $this->clearDescription();
      $this->clearPayload();
      $this->clearRetryParameters();
      $this->clearFirstTryUsec();
      $this->clearTag();
      $this->clearExecutionCount();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->task_name));
      }
      if (isset($this->eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->eta_usec);
      }
      if (isset($this->url)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->url));
      }
      if (isset($this->method)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->method);
      }
      if (isset($this->retry_count)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->retry_count);
      }
      $this->checkProtoArray($this->header);
      $res += 2 * sizeof($this->header);
      foreach ($this->header as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->body_size)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->body_size);
      }
      if (isset($this->body)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->body));
      }
      if (isset($this->creation_time_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->creation_time_usec);
      }
      if (isset($this->crontimetable)) {
        $res += 2;
        $res += $this->crontimetable->byteSizePartial();
      }
      if (isset($this->runlog)) {
        $res += 4;
        $res += $this->runlog->byteSizePartial();
      }
      if (isset($this->description)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->description));
      }
      if (isset($this->payload)) {
        $res += 2;
        $res += $this->lengthString($this->payload->byteSizePartial());
      }
      if (isset($this->retry_parameters)) {
        $res += 2;
        $res += $this->lengthString($this->retry_parameters->byteSizePartial());
      }
      if (isset($this->first_try_usec)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->first_try_usec);
      }
      if (isset($this->tag)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->tag));
      }
      if (isset($this->execution_count)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->execution_count);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->task_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->task_name);
      }
      if (isset($this->eta_usec)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->eta_usec);
      }
      if (isset($this->url)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->url);
      }
      if (isset($this->method)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->method);
      }
      if (isset($this->retry_count)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->retry_count);
      }
      $this->checkProtoArray($this->header);
      foreach ($this->header as $value) {
        $out->putVarInt32(59);
        $value->outputPartial($out);
        $out->putVarInt32(60);
      }
      if (isset($this->body_size)) {
        $out->putVarInt32(80);
        $out->putVarInt32($this->body_size);
      }
      if (isset($this->body)) {
        $out->putVarInt32(90);
        $out->putPrefixedString($this->body);
      }
      if (isset($this->creation_time_usec)) {
        $out->putVarInt32(96);
        $out->putVarInt64($this->creation_time_usec);
      }
      if (isset($this->crontimetable)) {
        $out->putVarInt32(107);
        $this->crontimetable->outputPartial($out);
        $out->putVarInt32(108);
      }
      if (isset($this->runlog)) {
        $out->putVarInt32(131);
        $this->runlog->outputPartial($out);
        $out->putVarInt32(132);
      }
      if (isset($this->description)) {
        $out->putVarInt32(170);
        $out->putPrefixedString($this->description);
      }
      if (isset($this->payload)) {
        $out->putVarInt32(178);
        $out->putVarInt32($this->payload->byteSizePartial());
        $this->payload->outputPartial($out);
      }
      if (isset($this->retry_parameters)) {
        $out->putVarInt32(186);
        $out->putVarInt32($this->retry_parameters->byteSizePartial());
        $this->retry_parameters->outputPartial($out);
      }
      if (isset($this->first_try_usec)) {
        $out->putVarInt32(192);
        $out->putVarInt64($this->first_try_usec);
      }
      if (isset($this->tag)) {
        $out->putVarInt32(202);
        $out->putPrefixedString($this->tag);
      }
      if (isset($this->execution_count)) {
        $out->putVarInt32(208);
        $out->putVarInt32($this->execution_count);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setEtaUsec($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setUrl(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 40:
            $this->setMethod($d->getVarInt32());
            break;
          case 48:
            $this->setRetryCount($d->getVarInt32());
            break;
          case 59:
            $this->addHeader()->tryMerge($d);
            break;
          case 80:
            $this->setBodySize($d->getVarInt32());
            break;
          case 90:
            $length = $d->getVarInt32();
            $this->setBody(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 96:
            $this->setCreationTimeUsec($d->getVarInt64());
            break;
          case 107:
            $this->mutableCronTimetable()->tryMerge($d);
            break;
          case 131:
            $this->mutableRunLog()->tryMerge($d);
            break;
          case 170:
            $length = $d->getVarInt32();
            $this->setDescription(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 178:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePayload()->tryMerge($tmp);
            break;
          case 186:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableRetryParameters()->tryMerge($tmp);
            break;
          case 192:
            $this->setFirstTryUsec($d->getVarInt64());
            break;
          case 202:
            $length = $d->getVarInt32();
            $this->setTag(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 208:
            $this->setExecutionCount($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->task_name)) return 'task_name';
      if (!isset($this->eta_usec)) return 'eta_usec';
      foreach ($this->header as $value) {
        if (!$value->isInitialized()) return 'header';
      }
      if (!isset($this->creation_time_usec)) return 'creation_time_usec';
      if (isset($this->crontimetable) && (!$this->crontimetable->isInitialized())) return 'crontimetable';
      if (isset($this->runlog) && (!$this->runlog->isInitialized())) return 'runlog';
      if (isset($this->payload) && (!$this->payload->isInitialized())) return 'payload';
      if (isset($this->retry_parameters) && (!$this->retry_parameters->isInitialized())) return 'retry_parameters';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
      if ($x->hasEtaUsec()) {
        $this->setEtaUsec($x->getEtaUsec());
      }
      if ($x->hasUrl()) {
        $this->setUrl($x->getUrl());
      }
      if ($x->hasMethod()) {
        $this->setMethod($x->getMethod());
      }
      if ($x->hasRetryCount()) {
        $this->setRetryCount($x->getRetryCount());
      }
      foreach ($x->getHeaderList() as $v) {
        $this->addHeader()->copyFrom($v);
      }
      if ($x->hasBodySize()) {
        $this->setBodySize($x->getBodySize());
      }
      if ($x->hasBody()) {
        $this->setBody($x->getBody());
      }
      if ($x->hasCreationTimeUsec()) {
        $this->setCreationTimeUsec($x->getCreationTimeUsec());
      }
      if ($x->hasCronTimetable()) {
        $this->mutableCronTimetable()->mergeFrom($x->getCronTimetable());
      }
      if ($x->hasRunLog()) {
        $this->mutableRunLog()->mergeFrom($x->getRunLog());
      }
      if ($x->hasDescription()) {
        $this->setDescription($x->getDescription());
      }
      if ($x->hasPayload()) {
        $this->mutablePayload()->mergeFrom($x->getPayload());
      }
      if ($x->hasRetryParameters()) {
        $this->mutableRetryParameters()->mergeFrom($x->getRetryParameters());
      }
      if ($x->hasFirstTryUsec()) {
        $this->setFirstTryUsec($x->getFirstTryUsec());
      }
      if ($x->hasTag()) {
        $this->setTag($x->getTag());
      }
      if ($x->hasExecutionCount()) {
        $this->setExecutionCount($x->getExecutionCount());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      if (isset($this->eta_usec) !== isset($x->eta_usec)) return false;
      if (isset($this->eta_usec) && !$this->integerEquals($this->eta_usec, $x->eta_usec)) return false;
      if (isset($this->url) !== isset($x->url)) return false;
      if (isset($this->url) && $this->url !== $x->url) return false;
      if (isset($this->method) !== isset($x->method)) return false;
      if (isset($this->method) && $this->method !== $x->method) return false;
      if (isset($this->retry_count) !== isset($x->retry_count)) return false;
      if (isset($this->retry_count) && !$this->integerEquals($this->retry_count, $x->retry_count)) return false;
      if (sizeof($this->header) !== sizeof($x->header)) return false;
      foreach (array_map(null, $this->header, $x->header) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->body_size) !== isset($x->body_size)) return false;
      if (isset($this->body_size) && !$this->integerEquals($this->body_size, $x->body_size)) return false;
      if (isset($this->body) !== isset($x->body)) return false;
      if (isset($this->body) && $this->body !== $x->body) return false;
      if (isset($this->creation_time_usec) !== isset($x->creation_time_usec)) return false;
      if (isset($this->creation_time_usec) && !$this->integerEquals($this->creation_time_usec, $x->creation_time_usec)) return false;
      if (isset($this->crontimetable) !== isset($x->crontimetable)) return false;
      if (isset($this->crontimetable) && !$this->crontimetable->equals($x->crontimetable)) return false;
      if (isset($this->runlog) !== isset($x->runlog)) return false;
      if (isset($this->runlog) && !$this->runlog->equals($x->runlog)) return false;
      if (isset($this->description) !== isset($x->description)) return false;
      if (isset($this->description) && $this->description !== $x->description) return false;
      if (isset($this->payload) !== isset($x->payload)) return false;
      if (isset($this->payload) && !$this->payload->equals($x->payload)) return false;
      if (isset($this->retry_parameters) !== isset($x->retry_parameters)) return false;
      if (isset($this->retry_parameters) && !$this->retry_parameters->equals($x->retry_parameters)) return false;
      if (isset($this->first_try_usec) !== isset($x->first_try_usec)) return false;
      if (isset($this->first_try_usec) && !$this->integerEquals($this->first_try_usec, $x->first_try_usec)) return false;
      if (isset($this->tag) !== isset($x->tag)) return false;
      if (isset($this->tag) && $this->tag !== $x->tag) return false;
      if (isset($this->execution_count) !== isset($x->execution_count)) return false;
      if (isset($this->execution_count) && !$this->integerEquals($this->execution_count, $x->execution_count)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      if (isset($this->eta_usec)) {
        $res .= $prefix . "eta_usec: " . $this->debugFormatInt64($this->eta_usec) . "\n";
      }
      if (isset($this->url)) {
        $res .= $prefix . "url: " . $this->debugFormatString($this->url) . "\n";
      }
      if (isset($this->method)) {
        $res .= $prefix . "method: " . ($this->method) . "\n";
      }
      if (isset($this->retry_count)) {
        $res .= $prefix . "retry_count: " . $this->debugFormatInt32($this->retry_count) . "\n";
      }
      foreach ($this->header as $value) {
        $res .= $prefix . "Header {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->body_size)) {
        $res .= $prefix . "body_size: " . $this->debugFormatInt32($this->body_size) . "\n";
      }
      if (isset($this->body)) {
        $res .= $prefix . "body: " . $this->debugFormatString($this->body) . "\n";
      }
      if (isset($this->creation_time_usec)) {
        $res .= $prefix . "creation_time_usec: " . $this->debugFormatInt64($this->creation_time_usec) . "\n";
      }
      if (isset($this->crontimetable)) {
        $res .= $prefix . "CronTimetable {\n" . $this->crontimetable->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->runlog)) {
        $res .= $prefix . "RunLog {\n" . $this->runlog->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->description)) {
        $res .= $prefix . "description: " . $this->debugFormatString($this->description) . "\n";
      }
      if (isset($this->payload)) {
        $res .= $prefix . "payload <\n" . $this->payload->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->retry_parameters)) {
        $res .= $prefix . "retry_parameters <\n" . $this->retry_parameters->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->first_try_usec)) {
        $res .= $prefix . "first_try_usec: " . $this->debugFormatInt64($this->first_try_usec) . "\n";
      }
      if (isset($this->tag)) {
        $res .= $prefix . "tag: " . $this->debugFormatString($this->tag) . "\n";
      }
      if (isset($this->execution_count)) {
        $res .= $prefix . "execution_count: " . $this->debugFormatInt32($this->execution_count) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueQueryTasksResponse extends \google\net\ProtocolMessage {
    private $task = array();
    public function getTaskSize() {
      return sizeof($this->task);
    }
    public function getTaskList() {
      return $this->task;
    }
    public function mutableTask($idx) {
      if (!isset($this->task[$idx])) {
        $val = new \google\appengine\TaskQueueQueryTasksResponse\Task();
        $this->task[$idx] = $val;
        return $val;
      }
      return $this->task[$idx];
    }
    public function getTask($idx) {
      if (isset($this->task[$idx])) {
        return $this->task[$idx];
      }
      if ($idx >= end(array_keys($this->task))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueQueryTasksResponse\Task();
    }
    public function addTask() {
      $val = new \google\appengine\TaskQueueQueryTasksResponse\Task();
      $this->task[] = $val;
      return $val;
    }
    public function clearTask() {
      $this->task = array();
    }
    public function clear() {
      $this->clearTask();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->task);
      $res += 2 * sizeof($this->task);
      foreach ($this->task as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->task);
      foreach ($this->task as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addTask()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->task as $value) {
        if (!$value->isInitialized()) return 'task';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getTaskList() as $v) {
        $this->addTask()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->task) !== sizeof($x->task)) return false;
      foreach (array_map(null, $this->task, $x->task) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->task as $value) {
        $res .= $prefix . "Task {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueFetchTaskRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearQueueName();
      $this->clearTaskName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->task_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->queue_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->task_name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->task_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->task_name)) return 'task_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueFetchTaskResponse extends \google\net\ProtocolMessage {
    public function getTask() {
      if (!isset($this->task)) {
        return new \google\appengine\TaskQueueQueryTasksResponse();
      }
      return $this->task;
    }
    public function mutableTask() {
      if (!isset($this->task)) {
        $res = new \google\appengine\TaskQueueQueryTasksResponse();
        $this->task = $res;
        return $res;
      }
      return $this->task;
    }
    public function clearTask() {
      if (isset($this->task)) {
        unset($this->task);
      }
    }
    public function hasTask() {
      return isset($this->task);
    }
    public function clear() {
      $this->clearTask();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->task)) {
        $res += 1;
        $res += $this->lengthString($this->task->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->task)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->task->byteSizePartial());
        $this->task->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTask()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->task)) || (!$this->task->isInitialized())) return 'task';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTask()) {
        $this->mutableTask()->mergeFrom($x->getTask());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->task) !== isset($x->task)) return false;
      if (isset($this->task) && !$this->task->equals($x->task)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->task)) {
        $res .= $prefix . "task <\n" . $this->task->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueUpdateStorageLimitRequest extends \google\net\ProtocolMessage {
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getLimit() {
      if (!isset($this->limit)) {
        return "0";
      }
      return $this->limit;
    }
    public function setLimit($val) {
      if (is_double($val)) {
        $this->limit = sprintf('%0.0F', $val);
      } else {
        $this->limit = $val;
      }
      return $this;
    }
    public function clearLimit() {
      unset($this->limit);
      return $this;
    }
    public function hasLimit() {
      return isset($this->limit);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearLimit();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->limit)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->limit);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->limit)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->limit);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setLimit($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      if (!isset($this->limit)) return 'limit';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasLimit()) {
        $this->setLimit($x->getLimit());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->limit) !== isset($x->limit)) return false;
      if (isset($this->limit) && !$this->integerEquals($this->limit, $x->limit)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->limit)) {
        $res .= $prefix . "limit: " . $this->debugFormatInt64($this->limit) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueUpdateStorageLimitResponse extends \google\net\ProtocolMessage {
    public function getNewLimit() {
      if (!isset($this->new_limit)) {
        return "0";
      }
      return $this->new_limit;
    }
    public function setNewLimit($val) {
      if (is_double($val)) {
        $this->new_limit = sprintf('%0.0F', $val);
      } else {
        $this->new_limit = $val;
      }
      return $this;
    }
    public function clearNewLimit() {
      unset($this->new_limit);
      return $this;
    }
    public function hasNewLimit() {
      return isset($this->new_limit);
    }
    public function clear() {
      $this->clearNewLimit();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->new_limit)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->new_limit);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->new_limit)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->new_limit);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setNewLimit($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->new_limit)) return 'new_limit';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasNewLimit()) {
        $this->setNewLimit($x->getNewLimit());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->new_limit) !== isset($x->new_limit)) return false;
      if (isset($this->new_limit) && !$this->integerEquals($this->new_limit, $x->new_limit)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->new_limit)) {
        $res .= $prefix . "new_limit: " . $this->debugFormatInt64($this->new_limit) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueQueryAndOwnTasksRequest extends \google\net\ProtocolMessage {
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getLeaseSeconds() {
      if (!isset($this->lease_seconds)) {
        return 0.0;
      }
      return $this->lease_seconds;
    }
    public function setLeaseSeconds($val) {
      $this->lease_seconds = $val;
      return $this;
    }
    public function clearLeaseSeconds() {
      unset($this->lease_seconds);
      return $this;
    }
    public function hasLeaseSeconds() {
      return isset($this->lease_seconds);
    }
    public function getMaxTasks() {
      if (!isset($this->max_tasks)) {
        return "0";
      }
      return $this->max_tasks;
    }
    public function setMaxTasks($val) {
      if (is_double($val)) {
        $this->max_tasks = sprintf('%0.0F', $val);
      } else {
        $this->max_tasks = $val;
      }
      return $this;
    }
    public function clearMaxTasks() {
      unset($this->max_tasks);
      return $this;
    }
    public function hasMaxTasks() {
      return isset($this->max_tasks);
    }
    public function getGroupByTag() {
      if (!isset($this->group_by_tag)) {
        return false;
      }
      return $this->group_by_tag;
    }
    public function setGroupByTag($val) {
      $this->group_by_tag = $val;
      return $this;
    }
    public function clearGroupByTag() {
      unset($this->group_by_tag);
      return $this;
    }
    public function hasGroupByTag() {
      return isset($this->group_by_tag);
    }
    public function getTag() {
      if (!isset($this->tag)) {
        return '';
      }
      return $this->tag;
    }
    public function setTag($val) {
      $this->tag = $val;
      return $this;
    }
    public function clearTag() {
      unset($this->tag);
      return $this;
    }
    public function hasTag() {
      return isset($this->tag);
    }
    public function clear() {
      $this->clearQueueName();
      $this->clearLeaseSeconds();
      $this->clearMaxTasks();
      $this->clearGroupByTag();
      $this->clearTag();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->lease_seconds)) {
        $res += 9;
      }
      if (isset($this->max_tasks)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_tasks);
      }
      if (isset($this->group_by_tag)) {
        $res += 2;
      }
      if (isset($this->tag)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->tag));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->queue_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->lease_seconds)) {
        $out->putVarInt32(17);
        $out->putDouble($this->lease_seconds);
      }
      if (isset($this->max_tasks)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->max_tasks);
      }
      if (isset($this->group_by_tag)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->group_by_tag);
      }
      if (isset($this->tag)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->tag);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 17:
            $this->setLeaseSeconds($d->getDouble());
            break;
          case 24:
            $this->setMaxTasks($d->getVarInt64());
            break;
          case 32:
            $this->setGroupByTag($d->getBoolean());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setTag(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->lease_seconds)) return 'lease_seconds';
      if (!isset($this->max_tasks)) return 'max_tasks';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasLeaseSeconds()) {
        $this->setLeaseSeconds($x->getLeaseSeconds());
      }
      if ($x->hasMaxTasks()) {
        $this->setMaxTasks($x->getMaxTasks());
      }
      if ($x->hasGroupByTag()) {
        $this->setGroupByTag($x->getGroupByTag());
      }
      if ($x->hasTag()) {
        $this->setTag($x->getTag());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->lease_seconds) !== isset($x->lease_seconds)) return false;
      if (isset($this->lease_seconds) && $this->lease_seconds !== $x->lease_seconds) return false;
      if (isset($this->max_tasks) !== isset($x->max_tasks)) return false;
      if (isset($this->max_tasks) && !$this->integerEquals($this->max_tasks, $x->max_tasks)) return false;
      if (isset($this->group_by_tag) !== isset($x->group_by_tag)) return false;
      if (isset($this->group_by_tag) && $this->group_by_tag !== $x->group_by_tag) return false;
      if (isset($this->tag) !== isset($x->tag)) return false;
      if (isset($this->tag) && $this->tag !== $x->tag) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->lease_seconds)) {
        $res .= $prefix . "lease_seconds: " . $this->debugFormatDouble($this->lease_seconds) . "\n";
      }
      if (isset($this->max_tasks)) {
        $res .= $prefix . "max_tasks: " . $this->debugFormatInt64($this->max_tasks) . "\n";
      }
      if (isset($this->group_by_tag)) {
        $res .= $prefix . "group_by_tag: " . $this->debugFormatBool($this->group_by_tag) . "\n";
      }
      if (isset($this->tag)) {
        $res .= $prefix . "tag: " . $this->debugFormatString($this->tag) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\TaskQueueQueryAndOwnTasksResponse {
  class Task extends \google\net\ProtocolMessage {
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function getEtaUsec() {
      if (!isset($this->eta_usec)) {
        return "0";
      }
      return $this->eta_usec;
    }
    public function setEtaUsec($val) {
      if (is_double($val)) {
        $this->eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->eta_usec = $val;
      }
      return $this;
    }
    public function clearEtaUsec() {
      unset($this->eta_usec);
      return $this;
    }
    public function hasEtaUsec() {
      return isset($this->eta_usec);
    }
    public function getRetryCount() {
      if (!isset($this->retry_count)) {
        return 0;
      }
      return $this->retry_count;
    }
    public function setRetryCount($val) {
      $this->retry_count = $val;
      return $this;
    }
    public function clearRetryCount() {
      unset($this->retry_count);
      return $this;
    }
    public function hasRetryCount() {
      return isset($this->retry_count);
    }
    public function getBody() {
      if (!isset($this->body)) {
        return '';
      }
      return $this->body;
    }
    public function setBody($val) {
      $this->body = $val;
      return $this;
    }
    public function clearBody() {
      unset($this->body);
      return $this;
    }
    public function hasBody() {
      return isset($this->body);
    }
    public function getTag() {
      if (!isset($this->tag)) {
        return '';
      }
      return $this->tag;
    }
    public function setTag($val) {
      $this->tag = $val;
      return $this;
    }
    public function clearTag() {
      unset($this->tag);
      return $this;
    }
    public function hasTag() {
      return isset($this->tag);
    }
    public function clear() {
      $this->clearTaskName();
      $this->clearEtaUsec();
      $this->clearRetryCount();
      $this->clearBody();
      $this->clearTag();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->task_name));
      }
      if (isset($this->eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->eta_usec);
      }
      if (isset($this->retry_count)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->retry_count);
      }
      if (isset($this->body)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->body));
      }
      if (isset($this->tag)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->tag));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->task_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->task_name);
      }
      if (isset($this->eta_usec)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->eta_usec);
      }
      if (isset($this->retry_count)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->retry_count);
      }
      if (isset($this->body)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->body);
      }
      if (isset($this->tag)) {
        $out->putVarInt32(50);
        $out->putPrefixedString($this->tag);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setEtaUsec($d->getVarInt64());
            break;
          case 32:
            $this->setRetryCount($d->getVarInt32());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setBody(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 50:
            $length = $d->getVarInt32();
            $this->setTag(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->task_name)) return 'task_name';
      if (!isset($this->eta_usec)) return 'eta_usec';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
      if ($x->hasEtaUsec()) {
        $this->setEtaUsec($x->getEtaUsec());
      }
      if ($x->hasRetryCount()) {
        $this->setRetryCount($x->getRetryCount());
      }
      if ($x->hasBody()) {
        $this->setBody($x->getBody());
      }
      if ($x->hasTag()) {
        $this->setTag($x->getTag());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      if (isset($this->eta_usec) !== isset($x->eta_usec)) return false;
      if (isset($this->eta_usec) && !$this->integerEquals($this->eta_usec, $x->eta_usec)) return false;
      if (isset($this->retry_count) !== isset($x->retry_count)) return false;
      if (isset($this->retry_count) && !$this->integerEquals($this->retry_count, $x->retry_count)) return false;
      if (isset($this->body) !== isset($x->body)) return false;
      if (isset($this->body) && $this->body !== $x->body) return false;
      if (isset($this->tag) !== isset($x->tag)) return false;
      if (isset($this->tag) && $this->tag !== $x->tag) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      if (isset($this->eta_usec)) {
        $res .= $prefix . "eta_usec: " . $this->debugFormatInt64($this->eta_usec) . "\n";
      }
      if (isset($this->retry_count)) {
        $res .= $prefix . "retry_count: " . $this->debugFormatInt32($this->retry_count) . "\n";
      }
      if (isset($this->body)) {
        $res .= $prefix . "body: " . $this->debugFormatString($this->body) . "\n";
      }
      if (isset($this->tag)) {
        $res .= $prefix . "tag: " . $this->debugFormatString($this->tag) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueQueryAndOwnTasksResponse extends \google\net\ProtocolMessage {
    private $task = array();
    public function getTaskSize() {
      return sizeof($this->task);
    }
    public function getTaskList() {
      return $this->task;
    }
    public function mutableTask($idx) {
      if (!isset($this->task[$idx])) {
        $val = new \google\appengine\TaskQueueQueryAndOwnTasksResponse\Task();
        $this->task[$idx] = $val;
        return $val;
      }
      return $this->task[$idx];
    }
    public function getTask($idx) {
      if (isset($this->task[$idx])) {
        return $this->task[$idx];
      }
      if ($idx >= end(array_keys($this->task))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\TaskQueueQueryAndOwnTasksResponse\Task();
    }
    public function addTask() {
      $val = new \google\appengine\TaskQueueQueryAndOwnTasksResponse\Task();
      $this->task[] = $val;
      return $val;
    }
    public function clearTask() {
      $this->task = array();
    }
    public function clear() {
      $this->clearTask();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->task);
      $res += 2 * sizeof($this->task);
      foreach ($this->task as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->task);
      foreach ($this->task as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addTask()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->task as $value) {
        if (!$value->isInitialized()) return 'task';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getTaskList() as $v) {
        $this->addTask()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->task) !== sizeof($x->task)) return false;
      foreach (array_map(null, $this->task, $x->task) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->task as $value) {
        $res .= $prefix . "Task {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueModifyTaskLeaseRequest extends \google\net\ProtocolMessage {
    public function getQueueName() {
      if (!isset($this->queue_name)) {
        return '';
      }
      return $this->queue_name;
    }
    public function setQueueName($val) {
      $this->queue_name = $val;
      return $this;
    }
    public function clearQueueName() {
      unset($this->queue_name);
      return $this;
    }
    public function hasQueueName() {
      return isset($this->queue_name);
    }
    public function getTaskName() {
      if (!isset($this->task_name)) {
        return '';
      }
      return $this->task_name;
    }
    public function setTaskName($val) {
      $this->task_name = $val;
      return $this;
    }
    public function clearTaskName() {
      unset($this->task_name);
      return $this;
    }
    public function hasTaskName() {
      return isset($this->task_name);
    }
    public function getEtaUsec() {
      if (!isset($this->eta_usec)) {
        return "0";
      }
      return $this->eta_usec;
    }
    public function setEtaUsec($val) {
      if (is_double($val)) {
        $this->eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->eta_usec = $val;
      }
      return $this;
    }
    public function clearEtaUsec() {
      unset($this->eta_usec);
      return $this;
    }
    public function hasEtaUsec() {
      return isset($this->eta_usec);
    }
    public function getLeaseSeconds() {
      if (!isset($this->lease_seconds)) {
        return 0.0;
      }
      return $this->lease_seconds;
    }
    public function setLeaseSeconds($val) {
      $this->lease_seconds = $val;
      return $this;
    }
    public function clearLeaseSeconds() {
      unset($this->lease_seconds);
      return $this;
    }
    public function hasLeaseSeconds() {
      return isset($this->lease_seconds);
    }
    public function clear() {
      $this->clearQueueName();
      $this->clearTaskName();
      $this->clearEtaUsec();
      $this->clearLeaseSeconds();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->queue_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue_name));
      }
      if (isset($this->task_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->task_name));
      }
      if (isset($this->eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->eta_usec);
      }
      if (isset($this->lease_seconds)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->queue_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->queue_name);
      }
      if (isset($this->task_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->task_name);
      }
      if (isset($this->eta_usec)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->eta_usec);
      }
      if (isset($this->lease_seconds)) {
        $out->putVarInt32(33);
        $out->putDouble($this->lease_seconds);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setQueueName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setTaskName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setEtaUsec($d->getVarInt64());
            break;
          case 33:
            $this->setLeaseSeconds($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->queue_name)) return 'queue_name';
      if (!isset($this->task_name)) return 'task_name';
      if (!isset($this->eta_usec)) return 'eta_usec';
      if (!isset($this->lease_seconds)) return 'lease_seconds';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasQueueName()) {
        $this->setQueueName($x->getQueueName());
      }
      if ($x->hasTaskName()) {
        $this->setTaskName($x->getTaskName());
      }
      if ($x->hasEtaUsec()) {
        $this->setEtaUsec($x->getEtaUsec());
      }
      if ($x->hasLeaseSeconds()) {
        $this->setLeaseSeconds($x->getLeaseSeconds());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->queue_name) !== isset($x->queue_name)) return false;
      if (isset($this->queue_name) && $this->queue_name !== $x->queue_name) return false;
      if (isset($this->task_name) !== isset($x->task_name)) return false;
      if (isset($this->task_name) && $this->task_name !== $x->task_name) return false;
      if (isset($this->eta_usec) !== isset($x->eta_usec)) return false;
      if (isset($this->eta_usec) && !$this->integerEquals($this->eta_usec, $x->eta_usec)) return false;
      if (isset($this->lease_seconds) !== isset($x->lease_seconds)) return false;
      if (isset($this->lease_seconds) && $this->lease_seconds !== $x->lease_seconds) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->queue_name)) {
        $res .= $prefix . "queue_name: " . $this->debugFormatString($this->queue_name) . "\n";
      }
      if (isset($this->task_name)) {
        $res .= $prefix . "task_name: " . $this->debugFormatString($this->task_name) . "\n";
      }
      if (isset($this->eta_usec)) {
        $res .= $prefix . "eta_usec: " . $this->debugFormatInt64($this->eta_usec) . "\n";
      }
      if (isset($this->lease_seconds)) {
        $res .= $prefix . "lease_seconds: " . $this->debugFormatDouble($this->lease_seconds) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class TaskQueueModifyTaskLeaseResponse extends \google\net\ProtocolMessage {
    public function getUpdatedEtaUsec() {
      if (!isset($this->updated_eta_usec)) {
        return "0";
      }
      return $this->updated_eta_usec;
    }
    public function setUpdatedEtaUsec($val) {
      if (is_double($val)) {
        $this->updated_eta_usec = sprintf('%0.0F', $val);
      } else {
        $this->updated_eta_usec = $val;
      }
      return $this;
    }
    public function clearUpdatedEtaUsec() {
      unset($this->updated_eta_usec);
      return $this;
    }
    public function hasUpdatedEtaUsec() {
      return isset($this->updated_eta_usec);
    }
    public function clear() {
      $this->clearUpdatedEtaUsec();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->updated_eta_usec)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->updated_eta_usec);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->updated_eta_usec)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->updated_eta_usec);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setUpdatedEtaUsec($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->updated_eta_usec)) return 'updated_eta_usec';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasUpdatedEtaUsec()) {
        $this->setUpdatedEtaUsec($x->getUpdatedEtaUsec());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->updated_eta_usec) !== isset($x->updated_eta_usec)) return false;
      if (isset($this->updated_eta_usec) && !$this->integerEquals($this->updated_eta_usec, $x->updated_eta_usec)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->updated_eta_usec)) {
        $res .= $prefix . "updated_eta_usec: " . $this->debugFormatInt64($this->updated_eta_usec) . "\n";
      }
      return $res;
    }
  }
}
