<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/files/file_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/api/api_base_pb.php';
}
namespace google\appengine\files\FileServiceErrors {
  class ErrorCode {
    const OK = 0;
    const API_TEMPORARILY_UNAVAILABLE = 1;
    const REQUEST_TOO_LARGE = 3;
    const RESPONSE_TOO_LARGE = 4;
    const INVALID_FILE_NAME = 5;
    const OPERATION_NOT_SUPPORTED = 6;
    const IO_ERROR = 7;
    const PERMISSION_DENIED = 8;
    const WRONG_CONTENT_TYPE = 9;
    const FILE_NOT_OPENED = 10;
    const WRONG_OPEN_MODE = 11;
    const EXCLUSIVE_LOCK_REQUIRED = 12;
    const FILE_TEMPORARILY_UNAVAILABLE = 13;
    const EXISTENCE_ERROR = 100;
    const FINALIZATION_ERROR = 101;
    const UNSUPPORTED_CONTENT_TYPE = 102;
    const READ_ONLY = 103;
    const EXCLUSIVE_LOCK_FAILED = 104;
    const EXISTENCE_ERROR_METADATA_NOT_FOUND = 105;
    const EXISTENCE_ERROR_METADATA_FOUND = 106;
    const EXISTENCE_ERROR_SHARDING_MISMATCH = 107;
    const FINALIZATION_IN_PROGRESS = 108;
    const EXISTENCE_ERROR_OBJECT_NOT_FOUND = 109;
    const EXISTENCE_ERROR_BUCKET_NOT_FOUND = 110;
    const SEQUENCE_KEY_OUT_OF_ORDER = 300;
    const OUT_OF_BOUNDS = 500;
    const GLOBS_NOT_SUPPORTED = 600;
    const FILE_NAME_NOT_SPECIFIED = 701;
    const FILE_NAME_SPECIFIED = 702;
    const FILE_ALREADY_EXISTS = 703;
    const UNSUPPORTED_FILE_SYSTEM = 704;
    const INVALID_PARAMETER = 705;
    const SHUFFLER_INTERNAL_ERROR = 800;
    const SHUFFLE_REQUEST_TOO_LARGE = 801;
    const DUPLICATE_SHUFFLE_NAME = 802;
    const SHUFFLE_NOT_AVAILABLE = 803;
    const SHUFFLER_TEMPORARILY_UNAVAILABLE = 900;
    const MAX_ERROR_CODE = 9999;
  }
}
namespace google\appengine\files {
  class FileServiceErrors extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class KeyValue extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class KeyValues extends \google\net\ProtocolMessage {
    private $value = array();
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValueSize() {
      return sizeof($this->value);
    }
    public function getValueList() {
      return $this->value;
    }
    public function getValue($idx) {
      return $this->value[$idx];
    }
    public function setValue($idx, $val) {
      $this->value[$idx] = $val;
      return $this;
    }
    public function addValue($val) {
      $this->value[] = $val;
      return $this;
    }
    public function clearValue() {
      $this->value = array();
    }
    public function getPartial() {
      if (!isset($this->partial)) {
        return false;
      }
      return $this->partial;
    }
    public function setPartial($val) {
      $this->partial = $val;
      return $this;
    }
    public function clearPartial() {
      unset($this->partial);
      return $this;
    }
    public function hasPartial() {
      return isset($this->partial);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
      $this->clearPartial();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      $this->checkProtoArray($this->value);
      $res += 1 * sizeof($this->value);
      foreach ($this->value as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->partial)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->key);
      }
      $this->checkProtoArray($this->value);
      foreach ($this->value as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
      if (isset($this->partial)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->partial);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setPartial($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      foreach ($x->getValueList() as $v) {
        $this->addValue($v);
      }
      if ($x->hasPartial()) {
        $this->setPartial($x->getPartial());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (sizeof($this->value) !== sizeof($x->value)) return false;
      foreach (array_map(null, $this->value, $x->value) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->partial) !== isset($x->partial)) return false;
      if (isset($this->partial) && $this->partial !== $x->partial) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      foreach ($this->value as $value) {
        $res .= $prefix . "value: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->partial)) {
        $res .= $prefix . "partial: " . $this->debugFormatBool($this->partial) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files\FileContentType {
  class ContentType {
    const RAW = 0;
    const DEPRECATED_1 = 2;
    const INVALID_TYPE = 127;
  }
}
namespace google\appengine\files {
  class FileContentType extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files\CreateRequest {
  class Parameter extends \google\net\ProtocolMessage {
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearName();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->name);
      }
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->name)) return 'name';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class CreateRequest extends \google\net\ProtocolMessage {
    private $parameters = array();
    public function getFilesystem() {
      if (!isset($this->filesystem)) {
        return '';
      }
      return $this->filesystem;
    }
    public function setFilesystem($val) {
      $this->filesystem = $val;
      return $this;
    }
    public function clearFilesystem() {
      unset($this->filesystem);
      return $this;
    }
    public function hasFilesystem() {
      return isset($this->filesystem);
    }
    public function getContentType() {
      if (!isset($this->content_type)) {
        return 0;
      }
      return $this->content_type;
    }
    public function setContentType($val) {
      $this->content_type = $val;
      return $this;
    }
    public function clearContentType() {
      unset($this->content_type);
      return $this;
    }
    public function hasContentType() {
      return isset($this->content_type);
    }
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getParametersSize() {
      return sizeof($this->parameters);
    }
    public function getParametersList() {
      return $this->parameters;
    }
    public function mutableParameters($idx) {
      if (!isset($this->parameters[$idx])) {
        $val = new \google\appengine\files\CreateRequest\Parameter();
        $this->parameters[$idx] = $val;
        return $val;
      }
      return $this->parameters[$idx];
    }
    public function getParameters($idx) {
      if (isset($this->parameters[$idx])) {
        return $this->parameters[$idx];
      }
      if ($idx >= end(array_keys($this->parameters))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\files\CreateRequest\Parameter();
    }
    public function addParameters() {
      $val = new \google\appengine\files\CreateRequest\Parameter();
      $this->parameters[] = $val;
      return $val;
    }
    public function clearParameters() {
      $this->parameters = array();
    }
    public function getExpirationTimeSeconds() {
      if (!isset($this->expiration_time_seconds)) {
        return "0";
      }
      return $this->expiration_time_seconds;
    }
    public function setExpirationTimeSeconds($val) {
      if (is_double($val)) {
        $this->expiration_time_seconds = sprintf('%0.0F', $val);
      } else {
        $this->expiration_time_seconds = $val;
      }
      return $this;
    }
    public function clearExpirationTimeSeconds() {
      unset($this->expiration_time_seconds);
      return $this;
    }
    public function hasExpirationTimeSeconds() {
      return isset($this->expiration_time_seconds);
    }
    public function clear() {
      $this->clearFilesystem();
      $this->clearContentType();
      $this->clearFilename();
      $this->clearParameters();
      $this->clearExpirationTimeSeconds();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filesystem)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filesystem));
      }
      if (isset($this->content_type)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->content_type);
      }
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      $this->checkProtoArray($this->parameters);
      $res += 1 * sizeof($this->parameters);
      foreach ($this->parameters as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->expiration_time_seconds)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->expiration_time_seconds);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filesystem)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filesystem);
      }
      if (isset($this->content_type)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->content_type);
      }
      if (isset($this->filename)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->filename);
      }
      $this->checkProtoArray($this->parameters);
      foreach ($this->parameters as $value) {
        $out->putVarInt32(34);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->expiration_time_seconds)) {
        $out->putVarInt32(40);
        $out->putVarInt64($this->expiration_time_seconds);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilesystem(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setContentType($d->getVarInt32());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addParameters()->tryMerge($tmp);
            break;
          case 40:
            $this->setExpirationTimeSeconds($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filesystem)) return 'filesystem';
      if (!isset($this->content_type)) return 'content_type';
      foreach ($this->parameters as $value) {
        if (!$value->isInitialized()) return 'parameters';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilesystem()) {
        $this->setFilesystem($x->getFilesystem());
      }
      if ($x->hasContentType()) {
        $this->setContentType($x->getContentType());
      }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      foreach ($x->getParametersList() as $v) {
        $this->addParameters()->copyFrom($v);
      }
      if ($x->hasExpirationTimeSeconds()) {
        $this->setExpirationTimeSeconds($x->getExpirationTimeSeconds());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filesystem) !== isset($x->filesystem)) return false;
      if (isset($this->filesystem) && $this->filesystem !== $x->filesystem) return false;
      if (isset($this->content_type) !== isset($x->content_type)) return false;
      if (isset($this->content_type) && $this->content_type !== $x->content_type) return false;
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (sizeof($this->parameters) !== sizeof($x->parameters)) return false;
      foreach (array_map(null, $this->parameters, $x->parameters) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->expiration_time_seconds) !== isset($x->expiration_time_seconds)) return false;
      if (isset($this->expiration_time_seconds) && !$this->integerEquals($this->expiration_time_seconds, $x->expiration_time_seconds)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filesystem)) {
        $res .= $prefix . "filesystem: " . $this->debugFormatString($this->filesystem) . "\n";
      }
      if (isset($this->content_type)) {
        $res .= $prefix . "content_type: " . ($this->content_type) . "\n";
      }
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      foreach ($this->parameters as $value) {
        $res .= $prefix . "parameters <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->expiration_time_seconds)) {
        $res .= $prefix . "expiration_time_seconds: " . $this->debugFormatInt64($this->expiration_time_seconds) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class CreateResponse extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function clear() {
      $this->clearFilename();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files\OpenRequest {
  class OpenMode {
    const APPEND = 1;
    const READ = 2;
  }
}
namespace google\appengine\files {
  class OpenRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getContentType() {
      if (!isset($this->content_type)) {
        return 0;
      }
      return $this->content_type;
    }
    public function setContentType($val) {
      $this->content_type = $val;
      return $this;
    }
    public function clearContentType() {
      unset($this->content_type);
      return $this;
    }
    public function hasContentType() {
      return isset($this->content_type);
    }
    public function getOpenMode() {
      if (!isset($this->open_mode)) {
        return 1;
      }
      return $this->open_mode;
    }
    public function setOpenMode($val) {
      $this->open_mode = $val;
      return $this;
    }
    public function clearOpenMode() {
      unset($this->open_mode);
      return $this;
    }
    public function hasOpenMode() {
      return isset($this->open_mode);
    }
    public function getExclusiveLock() {
      if (!isset($this->exclusive_lock)) {
        return false;
      }
      return $this->exclusive_lock;
    }
    public function setExclusiveLock($val) {
      $this->exclusive_lock = $val;
      return $this;
    }
    public function clearExclusiveLock() {
      unset($this->exclusive_lock);
      return $this;
    }
    public function hasExclusiveLock() {
      return isset($this->exclusive_lock);
    }
    public function getBufferedOutput() {
      if (!isset($this->buffered_output)) {
        return false;
      }
      return $this->buffered_output;
    }
    public function setBufferedOutput($val) {
      $this->buffered_output = $val;
      return $this;
    }
    public function clearBufferedOutput() {
      unset($this->buffered_output);
      return $this;
    }
    public function hasBufferedOutput() {
      return isset($this->buffered_output);
    }
    public function getOpenLeaseTimeSeconds() {
      if (!isset($this->open_lease_time_seconds)) {
        return 30;
      }
      return $this->open_lease_time_seconds;
    }
    public function setOpenLeaseTimeSeconds($val) {
      $this->open_lease_time_seconds = $val;
      return $this;
    }
    public function clearOpenLeaseTimeSeconds() {
      unset($this->open_lease_time_seconds);
      return $this;
    }
    public function hasOpenLeaseTimeSeconds() {
      return isset($this->open_lease_time_seconds);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearContentType();
      $this->clearOpenMode();
      $this->clearExclusiveLock();
      $this->clearBufferedOutput();
      $this->clearOpenLeaseTimeSeconds();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->content_type)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->content_type);
      }
      if (isset($this->open_mode)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->open_mode);
      }
      if (isset($this->exclusive_lock)) {
        $res += 2;
      }
      if (isset($this->buffered_output)) {
        $res += 2;
      }
      if (isset($this->open_lease_time_seconds)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->open_lease_time_seconds);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->content_type)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->content_type);
      }
      if (isset($this->open_mode)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->open_mode);
      }
      if (isset($this->exclusive_lock)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->exclusive_lock);
      }
      if (isset($this->buffered_output)) {
        $out->putVarInt32(40);
        $out->putBoolean($this->buffered_output);
      }
      if (isset($this->open_lease_time_seconds)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->open_lease_time_seconds);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setContentType($d->getVarInt32());
            break;
          case 24:
            $this->setOpenMode($d->getVarInt32());
            break;
          case 32:
            $this->setExclusiveLock($d->getBoolean());
            break;
          case 40:
            $this->setBufferedOutput($d->getBoolean());
            break;
          case 48:
            $this->setOpenLeaseTimeSeconds($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      if (!isset($this->content_type)) return 'content_type';
      if (!isset($this->open_mode)) return 'open_mode';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasContentType()) {
        $this->setContentType($x->getContentType());
      }
      if ($x->hasOpenMode()) {
        $this->setOpenMode($x->getOpenMode());
      }
      if ($x->hasExclusiveLock()) {
        $this->setExclusiveLock($x->getExclusiveLock());
      }
      if ($x->hasBufferedOutput()) {
        $this->setBufferedOutput($x->getBufferedOutput());
      }
      if ($x->hasOpenLeaseTimeSeconds()) {
        $this->setOpenLeaseTimeSeconds($x->getOpenLeaseTimeSeconds());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->content_type) !== isset($x->content_type)) return false;
      if (isset($this->content_type) && $this->content_type !== $x->content_type) return false;
      if (isset($this->open_mode) !== isset($x->open_mode)) return false;
      if (isset($this->open_mode) && $this->open_mode !== $x->open_mode) return false;
      if (isset($this->exclusive_lock) !== isset($x->exclusive_lock)) return false;
      if (isset($this->exclusive_lock) && $this->exclusive_lock !== $x->exclusive_lock) return false;
      if (isset($this->buffered_output) !== isset($x->buffered_output)) return false;
      if (isset($this->buffered_output) && $this->buffered_output !== $x->buffered_output) return false;
      if (isset($this->open_lease_time_seconds) !== isset($x->open_lease_time_seconds)) return false;
      if (isset($this->open_lease_time_seconds) && !$this->integerEquals($this->open_lease_time_seconds, $x->open_lease_time_seconds)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->content_type)) {
        $res .= $prefix . "content_type: " . ($this->content_type) . "\n";
      }
      if (isset($this->open_mode)) {
        $res .= $prefix . "open_mode: " . ($this->open_mode) . "\n";
      }
      if (isset($this->exclusive_lock)) {
        $res .= $prefix . "exclusive_lock: " . $this->debugFormatBool($this->exclusive_lock) . "\n";
      }
      if (isset($this->buffered_output)) {
        $res .= $prefix . "buffered_output: " . $this->debugFormatBool($this->buffered_output) . "\n";
      }
      if (isset($this->open_lease_time_seconds)) {
        $res .= $prefix . "open_lease_time_seconds: " . $this->debugFormatInt32($this->open_lease_time_seconds) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class OpenResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class CloseRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getFinalize() {
      if (!isset($this->finalize)) {
        return false;
      }
      return $this->finalize;
    }
    public function setFinalize($val) {
      $this->finalize = $val;
      return $this;
    }
    public function clearFinalize() {
      unset($this->finalize);
      return $this;
    }
    public function hasFinalize() {
      return isset($this->finalize);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearFinalize();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->finalize)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->finalize)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->finalize);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setFinalize($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasFinalize()) {
        $this->setFinalize($x->getFinalize());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->finalize) !== isset($x->finalize)) return false;
      if (isset($this->finalize) && $this->finalize !== $x->finalize) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->finalize)) {
        $res .= $prefix . "finalize: " . $this->debugFormatBool($this->finalize) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class CloseResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class FileStat extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getContentType() {
      if (!isset($this->content_type)) {
        return 0;
      }
      return $this->content_type;
    }
    public function setContentType($val) {
      $this->content_type = $val;
      return $this;
    }
    public function clearContentType() {
      unset($this->content_type);
      return $this;
    }
    public function hasContentType() {
      return isset($this->content_type);
    }
    public function getFinalized() {
      if (!isset($this->finalized)) {
        return false;
      }
      return $this->finalized;
    }
    public function setFinalized($val) {
      $this->finalized = $val;
      return $this;
    }
    public function clearFinalized() {
      unset($this->finalized);
      return $this;
    }
    public function hasFinalized() {
      return isset($this->finalized);
    }
    public function getLength() {
      if (!isset($this->length)) {
        return "0";
      }
      return $this->length;
    }
    public function setLength($val) {
      if (is_double($val)) {
        $this->length = sprintf('%0.0F', $val);
      } else {
        $this->length = $val;
      }
      return $this;
    }
    public function clearLength() {
      unset($this->length);
      return $this;
    }
    public function hasLength() {
      return isset($this->length);
    }
    public function getCtime() {
      if (!isset($this->ctime)) {
        return "0";
      }
      return $this->ctime;
    }
    public function setCtime($val) {
      if (is_double($val)) {
        $this->ctime = sprintf('%0.0F', $val);
      } else {
        $this->ctime = $val;
      }
      return $this;
    }
    public function clearCtime() {
      unset($this->ctime);
      return $this;
    }
    public function hasCtime() {
      return isset($this->ctime);
    }
    public function getMtime() {
      if (!isset($this->mtime)) {
        return "0";
      }
      return $this->mtime;
    }
    public function setMtime($val) {
      if (is_double($val)) {
        $this->mtime = sprintf('%0.0F', $val);
      } else {
        $this->mtime = $val;
      }
      return $this;
    }
    public function clearMtime() {
      unset($this->mtime);
      return $this;
    }
    public function hasMtime() {
      return isset($this->mtime);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearContentType();
      $this->clearFinalized();
      $this->clearLength();
      $this->clearCtime();
      $this->clearMtime();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->content_type)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->content_type);
      }
      if (isset($this->finalized)) {
        $res += 2;
      }
      if (isset($this->length)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->length);
      }
      if (isset($this->ctime)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->ctime);
      }
      if (isset($this->mtime)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mtime);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->content_type)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->content_type);
      }
      if (isset($this->finalized)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->finalized);
      }
      if (isset($this->length)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->length);
      }
      if (isset($this->ctime)) {
        $out->putVarInt32(40);
        $out->putVarInt64($this->ctime);
      }
      if (isset($this->mtime)) {
        $out->putVarInt32(48);
        $out->putVarInt64($this->mtime);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setContentType($d->getVarInt32());
            break;
          case 24:
            $this->setFinalized($d->getBoolean());
            break;
          case 32:
            $this->setLength($d->getVarInt64());
            break;
          case 40:
            $this->setCtime($d->getVarInt64());
            break;
          case 48:
            $this->setMtime($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      if (!isset($this->content_type)) return 'content_type';
      if (!isset($this->finalized)) return 'finalized';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasContentType()) {
        $this->setContentType($x->getContentType());
      }
      if ($x->hasFinalized()) {
        $this->setFinalized($x->getFinalized());
      }
      if ($x->hasLength()) {
        $this->setLength($x->getLength());
      }
      if ($x->hasCtime()) {
        $this->setCtime($x->getCtime());
      }
      if ($x->hasMtime()) {
        $this->setMtime($x->getMtime());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->content_type) !== isset($x->content_type)) return false;
      if (isset($this->content_type) && $this->content_type !== $x->content_type) return false;
      if (isset($this->finalized) !== isset($x->finalized)) return false;
      if (isset($this->finalized) && $this->finalized !== $x->finalized) return false;
      if (isset($this->length) !== isset($x->length)) return false;
      if (isset($this->length) && !$this->integerEquals($this->length, $x->length)) return false;
      if (isset($this->ctime) !== isset($x->ctime)) return false;
      if (isset($this->ctime) && !$this->integerEquals($this->ctime, $x->ctime)) return false;
      if (isset($this->mtime) !== isset($x->mtime)) return false;
      if (isset($this->mtime) && !$this->integerEquals($this->mtime, $x->mtime)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->content_type)) {
        $res .= $prefix . "content_type: " . ($this->content_type) . "\n";
      }
      if (isset($this->finalized)) {
        $res .= $prefix . "finalized: " . $this->debugFormatBool($this->finalized) . "\n";
      }
      if (isset($this->length)) {
        $res .= $prefix . "length: " . $this->debugFormatInt64($this->length) . "\n";
      }
      if (isset($this->ctime)) {
        $res .= $prefix . "ctime: " . $this->debugFormatInt64($this->ctime) . "\n";
      }
      if (isset($this->mtime)) {
        $res .= $prefix . "mtime: " . $this->debugFormatInt64($this->mtime) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class StatRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getFileGlob() {
      if (!isset($this->file_glob)) {
        return '';
      }
      return $this->file_glob;
    }
    public function setFileGlob($val) {
      $this->file_glob = $val;
      return $this;
    }
    public function clearFileGlob() {
      unset($this->file_glob);
      return $this;
    }
    public function hasFileGlob() {
      return isset($this->file_glob);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearFileGlob();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->file_glob)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->file_glob));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->file_glob)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->file_glob);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setFileGlob(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasFileGlob()) {
        $this->setFileGlob($x->getFileGlob());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->file_glob) !== isset($x->file_glob)) return false;
      if (isset($this->file_glob) && $this->file_glob !== $x->file_glob) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->file_glob)) {
        $res .= $prefix . "file_glob: " . $this->debugFormatString($this->file_glob) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class StatResponse extends \google\net\ProtocolMessage {
    private $stat = array();
    public function getStatSize() {
      return sizeof($this->stat);
    }
    public function getStatList() {
      return $this->stat;
    }
    public function mutableStat($idx) {
      if (!isset($this->stat[$idx])) {
        $val = new \google\appengine\files\FileStat();
        $this->stat[$idx] = $val;
        return $val;
      }
      return $this->stat[$idx];
    }
    public function getStat($idx) {
      if (isset($this->stat[$idx])) {
        return $this->stat[$idx];
      }
      if ($idx >= end(array_keys($this->stat))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\files\FileStat();
    }
    public function addStat() {
      $val = new \google\appengine\files\FileStat();
      $this->stat[] = $val;
      return $val;
    }
    public function clearStat() {
      $this->stat = array();
    }
    public function getMoreFilesFound() {
      if (!isset($this->more_files_found)) {
        return false;
      }
      return $this->more_files_found;
    }
    public function setMoreFilesFound($val) {
      $this->more_files_found = $val;
      return $this;
    }
    public function clearMoreFilesFound() {
      unset($this->more_files_found);
      return $this;
    }
    public function hasMoreFilesFound() {
      return isset($this->more_files_found);
    }
    public function clear() {
      $this->clearStat();
      $this->clearMoreFilesFound();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->stat);
      $res += 1 * sizeof($this->stat);
      foreach ($this->stat as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->more_files_found)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->stat);
      foreach ($this->stat as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->more_files_found)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->more_files_found);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addStat()->tryMerge($tmp);
            break;
          case 16:
            $this->setMoreFilesFound($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->stat as $value) {
        if (!$value->isInitialized()) return 'stat';
      }
      if (!isset($this->more_files_found)) return 'more_files_found';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getStatList() as $v) {
        $this->addStat()->copyFrom($v);
      }
      if ($x->hasMoreFilesFound()) {
        $this->setMoreFilesFound($x->getMoreFilesFound());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->stat) !== sizeof($x->stat)) return false;
      foreach (array_map(null, $this->stat, $x->stat) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->more_files_found) !== isset($x->more_files_found)) return false;
      if (isset($this->more_files_found) && $this->more_files_found !== $x->more_files_found) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->stat as $value) {
        $res .= $prefix . "stat <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->more_files_found)) {
        $res .= $prefix . "more_files_found: " . $this->debugFormatBool($this->more_files_found) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class AppendRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getData() {
      if (!isset($this->data)) {
        return '';
      }
      return $this->data;
    }
    public function setData($val) {
      $this->data = $val;
      return $this;
    }
    public function clearData() {
      unset($this->data);
      return $this;
    }
    public function hasData() {
      return isset($this->data);
    }
    public function getSequenceKey() {
      if (!isset($this->sequence_key)) {
        return '';
      }
      return $this->sequence_key;
    }
    public function setSequenceKey($val) {
      $this->sequence_key = $val;
      return $this;
    }
    public function clearSequenceKey() {
      unset($this->sequence_key);
      return $this;
    }
    public function hasSequenceKey() {
      return isset($this->sequence_key);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearData();
      $this->clearSequenceKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->data)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->data));
      }
      if (isset($this->sequence_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->sequence_key));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->data)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->data);
      }
      if (isset($this->sequence_key)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->sequence_key);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setData(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setSequenceKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      if (!isset($this->data)) return 'data';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasData()) {
        $this->setData($x->getData());
      }
      if ($x->hasSequenceKey()) {
        $this->setSequenceKey($x->getSequenceKey());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->data) !== isset($x->data)) return false;
      if (isset($this->data) && $this->data !== $x->data) return false;
      if (isset($this->sequence_key) !== isset($x->sequence_key)) return false;
      if (isset($this->sequence_key) && $this->sequence_key !== $x->sequence_key) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->data)) {
        $res .= $prefix . "data: " . $this->debugFormatString($this->data) . "\n";
      }
      if (isset($this->sequence_key)) {
        $res .= $prefix . "sequence_key: " . $this->debugFormatString($this->sequence_key) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class AppendResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class DeleteRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function clear() {
      $this->clearFilename();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class DeleteResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ReadRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getPos() {
      if (!isset($this->pos)) {
        return "0";
      }
      return $this->pos;
    }
    public function setPos($val) {
      if (is_double($val)) {
        $this->pos = sprintf('%0.0F', $val);
      } else {
        $this->pos = $val;
      }
      return $this;
    }
    public function clearPos() {
      unset($this->pos);
      return $this;
    }
    public function hasPos() {
      return isset($this->pos);
    }
    public function getMaxBytes() {
      if (!isset($this->max_bytes)) {
        return "0";
      }
      return $this->max_bytes;
    }
    public function setMaxBytes($val) {
      if (is_double($val)) {
        $this->max_bytes = sprintf('%0.0F', $val);
      } else {
        $this->max_bytes = $val;
      }
      return $this;
    }
    public function clearMaxBytes() {
      unset($this->max_bytes);
      return $this;
    }
    public function hasMaxBytes() {
      return isset($this->max_bytes);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearPos();
      $this->clearMaxBytes();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->pos)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->pos);
      }
      if (isset($this->max_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_bytes);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->pos)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->pos);
      }
      if (isset($this->max_bytes)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->max_bytes);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setPos($d->getVarInt64());
            break;
          case 24:
            $this->setMaxBytes($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      if (!isset($this->pos)) return 'pos';
      if (!isset($this->max_bytes)) return 'max_bytes';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasPos()) {
        $this->setPos($x->getPos());
      }
      if ($x->hasMaxBytes()) {
        $this->setMaxBytes($x->getMaxBytes());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->pos) !== isset($x->pos)) return false;
      if (isset($this->pos) && !$this->integerEquals($this->pos, $x->pos)) return false;
      if (isset($this->max_bytes) !== isset($x->max_bytes)) return false;
      if (isset($this->max_bytes) && !$this->integerEquals($this->max_bytes, $x->max_bytes)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->pos)) {
        $res .= $prefix . "pos: " . $this->debugFormatInt64($this->pos) . "\n";
      }
      if (isset($this->max_bytes)) {
        $res .= $prefix . "max_bytes: " . $this->debugFormatInt64($this->max_bytes) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ReadResponse extends \google\net\ProtocolMessage {
    public function getData() {
      if (!isset($this->data)) {
        return '';
      }
      return $this->data;
    }
    public function setData($val) {
      $this->data = $val;
      return $this;
    }
    public function clearData() {
      unset($this->data);
      return $this;
    }
    public function hasData() {
      return isset($this->data);
    }
    public function clear() {
      $this->clearData();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->data)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->data));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->data)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->data);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setData(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->data)) return 'data';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasData()) {
        $this->setData($x->getData());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->data) !== isset($x->data)) return false;
      if (isset($this->data) && $this->data !== $x->data) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->data)) {
        $res .= $prefix . "data: " . $this->debugFormatString($this->data) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ReadKeyValueRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function getStartKey() {
      if (!isset($this->start_key)) {
        return '';
      }
      return $this->start_key;
    }
    public function setStartKey($val) {
      $this->start_key = $val;
      return $this;
    }
    public function clearStartKey() {
      unset($this->start_key);
      return $this;
    }
    public function hasStartKey() {
      return isset($this->start_key);
    }
    public function getMaxBytes() {
      if (!isset($this->max_bytes)) {
        return "0";
      }
      return $this->max_bytes;
    }
    public function setMaxBytes($val) {
      if (is_double($val)) {
        $this->max_bytes = sprintf('%0.0F', $val);
      } else {
        $this->max_bytes = $val;
      }
      return $this;
    }
    public function clearMaxBytes() {
      unset($this->max_bytes);
      return $this;
    }
    public function hasMaxBytes() {
      return isset($this->max_bytes);
    }
    public function getValuePos() {
      if (!isset($this->value_pos)) {
        return "0";
      }
      return $this->value_pos;
    }
    public function setValuePos($val) {
      if (is_double($val)) {
        $this->value_pos = sprintf('%0.0F', $val);
      } else {
        $this->value_pos = $val;
      }
      return $this;
    }
    public function clearValuePos() {
      unset($this->value_pos);
      return $this;
    }
    public function hasValuePos() {
      return isset($this->value_pos);
    }
    public function clear() {
      $this->clearFilename();
      $this->clearStartKey();
      $this->clearMaxBytes();
      $this->clearValuePos();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      if (isset($this->start_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->start_key));
      }
      if (isset($this->max_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_bytes);
      }
      if (isset($this->value_pos)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->value_pos);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
      if (isset($this->start_key)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->start_key);
      }
      if (isset($this->max_bytes)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->max_bytes);
      }
      if (isset($this->value_pos)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->value_pos);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setStartKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setMaxBytes($d->getVarInt64());
            break;
          case 32:
            $this->setValuePos($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      if (!isset($this->start_key)) return 'start_key';
      if (!isset($this->max_bytes)) return 'max_bytes';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
      if ($x->hasStartKey()) {
        $this->setStartKey($x->getStartKey());
      }
      if ($x->hasMaxBytes()) {
        $this->setMaxBytes($x->getMaxBytes());
      }
      if ($x->hasValuePos()) {
        $this->setValuePos($x->getValuePos());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      if (isset($this->start_key) !== isset($x->start_key)) return false;
      if (isset($this->start_key) && $this->start_key !== $x->start_key) return false;
      if (isset($this->max_bytes) !== isset($x->max_bytes)) return false;
      if (isset($this->max_bytes) && !$this->integerEquals($this->max_bytes, $x->max_bytes)) return false;
      if (isset($this->value_pos) !== isset($x->value_pos)) return false;
      if (isset($this->value_pos) && !$this->integerEquals($this->value_pos, $x->value_pos)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      if (isset($this->start_key)) {
        $res .= $prefix . "start_key: " . $this->debugFormatString($this->start_key) . "\n";
      }
      if (isset($this->max_bytes)) {
        $res .= $prefix . "max_bytes: " . $this->debugFormatInt64($this->max_bytes) . "\n";
      }
      if (isset($this->value_pos)) {
        $res .= $prefix . "value_pos: " . $this->debugFormatInt64($this->value_pos) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files\ReadKeyValueResponse {
  class KeyValue extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return '';
      }
      return $this->value;
    }
    public function setValue($val) {
      $this->value = $val;
      return $this;
    }
    public function clearValue() {
      unset($this->value);
      return $this;
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearKey();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->key)) return 'key';
      if (!isset($this->value)) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasValue()) {
        $this->setValue($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && $this->value !== $x->value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value: " . $this->debugFormatString($this->value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ReadKeyValueResponse extends \google\net\ProtocolMessage {
    private $data = array();
    public function getDataSize() {
      return sizeof($this->data);
    }
    public function getDataList() {
      return $this->data;
    }
    public function mutableData($idx) {
      if (!isset($this->data[$idx])) {
        $val = new \google\appengine\files\ReadKeyValueResponse\KeyValue();
        $this->data[$idx] = $val;
        return $val;
      }
      return $this->data[$idx];
    }
    public function getData($idx) {
      if (isset($this->data[$idx])) {
        return $this->data[$idx];
      }
      if ($idx >= end(array_keys($this->data))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\files\ReadKeyValueResponse\KeyValue();
    }
    public function addData() {
      $val = new \google\appengine\files\ReadKeyValueResponse\KeyValue();
      $this->data[] = $val;
      return $val;
    }
    public function clearData() {
      $this->data = array();
    }
    public function getNextKey() {
      if (!isset($this->next_key)) {
        return '';
      }
      return $this->next_key;
    }
    public function setNextKey($val) {
      $this->next_key = $val;
      return $this;
    }
    public function clearNextKey() {
      unset($this->next_key);
      return $this;
    }
    public function hasNextKey() {
      return isset($this->next_key);
    }
    public function getTruncatedValue() {
      if (!isset($this->truncated_value)) {
        return false;
      }
      return $this->truncated_value;
    }
    public function setTruncatedValue($val) {
      $this->truncated_value = $val;
      return $this;
    }
    public function clearTruncatedValue() {
      unset($this->truncated_value);
      return $this;
    }
    public function hasTruncatedValue() {
      return isset($this->truncated_value);
    }
    public function clear() {
      $this->clearData();
      $this->clearNextKey();
      $this->clearTruncatedValue();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->data);
      $res += 1 * sizeof($this->data);
      foreach ($this->data as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->next_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->next_key));
      }
      if (isset($this->truncated_value)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->data);
      foreach ($this->data as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->next_key)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->next_key);
      }
      if (isset($this->truncated_value)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->truncated_value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addData()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setNextKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setTruncatedValue($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->data as $value) {
        if (!$value->isInitialized()) return 'data';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getDataList() as $v) {
        $this->addData()->copyFrom($v);
      }
      if ($x->hasNextKey()) {
        $this->setNextKey($x->getNextKey());
      }
      if ($x->hasTruncatedValue()) {
        $this->setTruncatedValue($x->getTruncatedValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->data) !== sizeof($x->data)) return false;
      foreach (array_map(null, $this->data, $x->data) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->next_key) !== isset($x->next_key)) return false;
      if (isset($this->next_key) && $this->next_key !== $x->next_key) return false;
      if (isset($this->truncated_value) !== isset($x->truncated_value)) return false;
      if (isset($this->truncated_value) && $this->truncated_value !== $x->truncated_value) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->data as $value) {
        $res .= $prefix . "data <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->next_key)) {
        $res .= $prefix . "next_key: " . $this->debugFormatString($this->next_key) . "\n";
      }
      if (isset($this->truncated_value)) {
        $res .= $prefix . "truncated_value: " . $this->debugFormatBool($this->truncated_value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files\ShuffleEnums {
  class InputFormat {
    const RECORDS_KEY_VALUE_PROTO_INPUT = 1;
  }
}
namespace google\appengine\files\ShuffleEnums {
  class OutputFormat {
    const RECORDS_KEY_MULTI_VALUE_PROTO_OUTPUT = 1;
  }
}
namespace google\appengine\files\ShuffleEnums {
  class Status {
    const UNKNOWN = 1;
    const RUNNING = 2;
    const SUCCESS = 3;
    const FAILURE = 4;
    const INVALID_INPUT = 5;
    const OUTPUT_ALREADY_EXISTS = 6;
    const INCORRECT_SHUFFLE_SIZE_BYTES = 7;
  }
}
namespace google\appengine\files {
  class ShuffleEnums extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ShuffleInputSpecification extends \google\net\ProtocolMessage {
    public function getFormat() {
      if (!isset($this->format)) {
        return 1;
      }
      return $this->format;
    }
    public function setFormat($val) {
      $this->format = $val;
      return $this;
    }
    public function clearFormat() {
      unset($this->format);
      return $this;
    }
    public function hasFormat() {
      return isset($this->format);
    }
    public function getPath() {
      if (!isset($this->path)) {
        return '';
      }
      return $this->path;
    }
    public function setPath($val) {
      $this->path = $val;
      return $this;
    }
    public function clearPath() {
      unset($this->path);
      return $this;
    }
    public function hasPath() {
      return isset($this->path);
    }
    public function clear() {
      $this->clearFormat();
      $this->clearPath();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->format)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->format);
      }
      if (isset($this->path)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->path));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->format)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->format);
      }
      if (isset($this->path)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->path);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setFormat($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setPath(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->path)) return 'path';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFormat()) {
        $this->setFormat($x->getFormat());
      }
      if ($x->hasPath()) {
        $this->setPath($x->getPath());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->format) !== isset($x->format)) return false;
      if (isset($this->format) && $this->format !== $x->format) return false;
      if (isset($this->path) !== isset($x->path)) return false;
      if (isset($this->path) && $this->path !== $x->path) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->format)) {
        $res .= $prefix . "format: " . ($this->format) . "\n";
      }
      if (isset($this->path)) {
        $res .= $prefix . "path: " . $this->debugFormatString($this->path) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ShuffleOutputSpecification extends \google\net\ProtocolMessage {
    private $path = array();
    public function getFormat() {
      if (!isset($this->format)) {
        return 1;
      }
      return $this->format;
    }
    public function setFormat($val) {
      $this->format = $val;
      return $this;
    }
    public function clearFormat() {
      unset($this->format);
      return $this;
    }
    public function hasFormat() {
      return isset($this->format);
    }
    public function getPathSize() {
      return sizeof($this->path);
    }
    public function getPathList() {
      return $this->path;
    }
    public function getPath($idx) {
      return $this->path[$idx];
    }
    public function setPath($idx, $val) {
      $this->path[$idx] = $val;
      return $this;
    }
    public function addPath($val) {
      $this->path[] = $val;
      return $this;
    }
    public function clearPath() {
      $this->path = array();
    }
    public function clear() {
      $this->clearFormat();
      $this->clearPath();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->format)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->format);
      }
      $this->checkProtoArray($this->path);
      $res += 1 * sizeof($this->path);
      foreach ($this->path as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->format)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->format);
      }
      $this->checkProtoArray($this->path);
      foreach ($this->path as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setFormat($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addPath(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFormat()) {
        $this->setFormat($x->getFormat());
      }
      foreach ($x->getPathList() as $v) {
        $this->addPath($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->format) !== isset($x->format)) return false;
      if (isset($this->format) && $this->format !== $x->format) return false;
      if (sizeof($this->path) !== sizeof($x->path)) return false;
      foreach (array_map(null, $this->path, $x->path) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->format)) {
        $res .= $prefix . "format: " . ($this->format) . "\n";
      }
      foreach ($this->path as $value) {
        $res .= $prefix . "path: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files\ShuffleRequest {
  class Callback extends \google\net\ProtocolMessage {
    public function getUrl() {
      if (!isset($this->url)) {
        return '';
      }
      return $this->url;
    }
    public function setUrl($val) {
      $this->url = $val;
      return $this;
    }
    public function clearUrl() {
      unset($this->url);
      return $this;
    }
    public function hasUrl() {
      return isset($this->url);
    }
    public function getAppVersionId() {
      if (!isset($this->app_version_id)) {
        return '';
      }
      return $this->app_version_id;
    }
    public function setAppVersionId($val) {
      $this->app_version_id = $val;
      return $this;
    }
    public function clearAppVersionId() {
      unset($this->app_version_id);
      return $this;
    }
    public function hasAppVersionId() {
      return isset($this->app_version_id);
    }
    public function getMethod() {
      if (!isset($this->method)) {
        return "POST";
      }
      return $this->method;
    }
    public function setMethod($val) {
      $this->method = $val;
      return $this;
    }
    public function clearMethod() {
      unset($this->method);
      return $this;
    }
    public function hasMethod() {
      return isset($this->method);
    }
    public function getQueue() {
      if (!isset($this->queue)) {
        return "default";
      }
      return $this->queue;
    }
    public function setQueue($val) {
      $this->queue = $val;
      return $this;
    }
    public function clearQueue() {
      unset($this->queue);
      return $this;
    }
    public function hasQueue() {
      return isset($this->queue);
    }
    public function clear() {
      $this->clearUrl();
      $this->clearAppVersionId();
      $this->clearMethod();
      $this->clearQueue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->url)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->url));
      }
      if (isset($this->app_version_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_version_id));
      }
      if (isset($this->method)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->method));
      }
      if (isset($this->queue)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->queue));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->url)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->url);
      }
      if (isset($this->app_version_id)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->app_version_id);
      }
      if (isset($this->method)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->method);
      }
      if (isset($this->queue)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->queue);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setUrl(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setAppVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setMethod(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setQueue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->url)) return 'url';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasUrl()) {
        $this->setUrl($x->getUrl());
      }
      if ($x->hasAppVersionId()) {
        $this->setAppVersionId($x->getAppVersionId());
      }
      if ($x->hasMethod()) {
        $this->setMethod($x->getMethod());
      }
      if ($x->hasQueue()) {
        $this->setQueue($x->getQueue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->url) !== isset($x->url)) return false;
      if (isset($this->url) && $this->url !== $x->url) return false;
      if (isset($this->app_version_id) !== isset($x->app_version_id)) return false;
      if (isset($this->app_version_id) && $this->app_version_id !== $x->app_version_id) return false;
      if (isset($this->method) !== isset($x->method)) return false;
      if (isset($this->method) && $this->method !== $x->method) return false;
      if (isset($this->queue) !== isset($x->queue)) return false;
      if (isset($this->queue) && $this->queue !== $x->queue) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->url)) {
        $res .= $prefix . "url: " . $this->debugFormatString($this->url) . "\n";
      }
      if (isset($this->app_version_id)) {
        $res .= $prefix . "app_version_id: " . $this->debugFormatString($this->app_version_id) . "\n";
      }
      if (isset($this->method)) {
        $res .= $prefix . "method: " . $this->debugFormatString($this->method) . "\n";
      }
      if (isset($this->queue)) {
        $res .= $prefix . "queue: " . $this->debugFormatString($this->queue) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ShuffleRequest extends \google\net\ProtocolMessage {
    private $input = array();
    public function getShuffleName() {
      if (!isset($this->shuffle_name)) {
        return '';
      }
      return $this->shuffle_name;
    }
    public function setShuffleName($val) {
      $this->shuffle_name = $val;
      return $this;
    }
    public function clearShuffleName() {
      unset($this->shuffle_name);
      return $this;
    }
    public function hasShuffleName() {
      return isset($this->shuffle_name);
    }
    public function getInputSize() {
      return sizeof($this->input);
    }
    public function getInputList() {
      return $this->input;
    }
    public function mutableInput($idx) {
      if (!isset($this->input[$idx])) {
        $val = new \google\appengine\files\ShuffleInputSpecification();
        $this->input[$idx] = $val;
        return $val;
      }
      return $this->input[$idx];
    }
    public function getInput($idx) {
      if (isset($this->input[$idx])) {
        return $this->input[$idx];
      }
      if ($idx >= end(array_keys($this->input))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\files\ShuffleInputSpecification();
    }
    public function addInput() {
      $val = new \google\appengine\files\ShuffleInputSpecification();
      $this->input[] = $val;
      return $val;
    }
    public function clearInput() {
      $this->input = array();
    }
    public function getOutput() {
      if (!isset($this->output)) {
        return new \google\appengine\files\ShuffleOutputSpecification();
      }
      return $this->output;
    }
    public function mutableOutput() {
      if (!isset($this->output)) {
        $res = new \google\appengine\files\ShuffleOutputSpecification();
        $this->output = $res;
        return $res;
      }
      return $this->output;
    }
    public function clearOutput() {
      if (isset($this->output)) {
        unset($this->output);
      }
    }
    public function hasOutput() {
      return isset($this->output);
    }
    public function getShuffleSizeBytes() {
      if (!isset($this->shuffle_size_bytes)) {
        return "0";
      }
      return $this->shuffle_size_bytes;
    }
    public function setShuffleSizeBytes($val) {
      if (is_double($val)) {
        $this->shuffle_size_bytes = sprintf('%0.0F', $val);
      } else {
        $this->shuffle_size_bytes = $val;
      }
      return $this;
    }
    public function clearShuffleSizeBytes() {
      unset($this->shuffle_size_bytes);
      return $this;
    }
    public function hasShuffleSizeBytes() {
      return isset($this->shuffle_size_bytes);
    }
    public function getCallback() {
      if (!isset($this->callback)) {
        return new \google\appengine\files\ShuffleRequest\Callback();
      }
      return $this->callback;
    }
    public function mutableCallback() {
      if (!isset($this->callback)) {
        $res = new \google\appengine\files\ShuffleRequest\Callback();
        $this->callback = $res;
        return $res;
      }
      return $this->callback;
    }
    public function clearCallback() {
      if (isset($this->callback)) {
        unset($this->callback);
      }
    }
    public function hasCallback() {
      return isset($this->callback);
    }
    public function clear() {
      $this->clearShuffleName();
      $this->clearInput();
      $this->clearOutput();
      $this->clearShuffleSizeBytes();
      $this->clearCallback();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->shuffle_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->shuffle_name));
      }
      $this->checkProtoArray($this->input);
      $res += 1 * sizeof($this->input);
      foreach ($this->input as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->output)) {
        $res += 1;
        $res += $this->lengthString($this->output->byteSizePartial());
      }
      if (isset($this->shuffle_size_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->shuffle_size_bytes);
      }
      if (isset($this->callback)) {
        $res += 1;
        $res += $this->lengthString($this->callback->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->shuffle_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->shuffle_name);
      }
      $this->checkProtoArray($this->input);
      foreach ($this->input as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->output)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->output->byteSizePartial());
        $this->output->outputPartial($out);
      }
      if (isset($this->shuffle_size_bytes)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->shuffle_size_bytes);
      }
      if (isset($this->callback)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->callback->byteSizePartial());
        $this->callback->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setShuffleName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addInput()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOutput()->tryMerge($tmp);
            break;
          case 32:
            $this->setShuffleSizeBytes($d->getVarInt64());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCallback()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->shuffle_name)) return 'shuffle_name';
      foreach ($this->input as $value) {
        if (!$value->isInitialized()) return 'input';
      }
      if ((!isset($this->output)) || (!$this->output->isInitialized())) return 'output';
      if (!isset($this->shuffle_size_bytes)) return 'shuffle_size_bytes';
      if ((!isset($this->callback)) || (!$this->callback->isInitialized())) return 'callback';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasShuffleName()) {
        $this->setShuffleName($x->getShuffleName());
      }
      foreach ($x->getInputList() as $v) {
        $this->addInput()->copyFrom($v);
      }
      if ($x->hasOutput()) {
        $this->mutableOutput()->mergeFrom($x->getOutput());
      }
      if ($x->hasShuffleSizeBytes()) {
        $this->setShuffleSizeBytes($x->getShuffleSizeBytes());
      }
      if ($x->hasCallback()) {
        $this->mutableCallback()->mergeFrom($x->getCallback());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->shuffle_name) !== isset($x->shuffle_name)) return false;
      if (isset($this->shuffle_name) && $this->shuffle_name !== $x->shuffle_name) return false;
      if (sizeof($this->input) !== sizeof($x->input)) return false;
      foreach (array_map(null, $this->input, $x->input) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->output) !== isset($x->output)) return false;
      if (isset($this->output) && !$this->output->equals($x->output)) return false;
      if (isset($this->shuffle_size_bytes) !== isset($x->shuffle_size_bytes)) return false;
      if (isset($this->shuffle_size_bytes) && !$this->integerEquals($this->shuffle_size_bytes, $x->shuffle_size_bytes)) return false;
      if (isset($this->callback) !== isset($x->callback)) return false;
      if (isset($this->callback) && !$this->callback->equals($x->callback)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->shuffle_name)) {
        $res .= $prefix . "shuffle_name: " . $this->debugFormatString($this->shuffle_name) . "\n";
      }
      foreach ($this->input as $value) {
        $res .= $prefix . "input <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->output)) {
        $res .= $prefix . "output <\n" . $this->output->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->shuffle_size_bytes)) {
        $res .= $prefix . "shuffle_size_bytes: " . $this->debugFormatInt64($this->shuffle_size_bytes) . "\n";
      }
      if (isset($this->callback)) {
        $res .= $prefix . "callback <\n" . $this->callback->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ShuffleResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class GetShuffleStatusRequest extends \google\net\ProtocolMessage {
    public function getShuffleName() {
      if (!isset($this->shuffle_name)) {
        return '';
      }
      return $this->shuffle_name;
    }
    public function setShuffleName($val) {
      $this->shuffle_name = $val;
      return $this;
    }
    public function clearShuffleName() {
      unset($this->shuffle_name);
      return $this;
    }
    public function hasShuffleName() {
      return isset($this->shuffle_name);
    }
    public function clear() {
      $this->clearShuffleName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->shuffle_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->shuffle_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->shuffle_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->shuffle_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setShuffleName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->shuffle_name)) return 'shuffle_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasShuffleName()) {
        $this->setShuffleName($x->getShuffleName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->shuffle_name) !== isset($x->shuffle_name)) return false;
      if (isset($this->shuffle_name) && $this->shuffle_name !== $x->shuffle_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->shuffle_name)) {
        $res .= $prefix . "shuffle_name: " . $this->debugFormatString($this->shuffle_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class GetShuffleStatusResponse extends \google\net\ProtocolMessage {
    public function getStatus() {
      if (!isset($this->status)) {
        return 1;
      }
      return $this->status;
    }
    public function setStatus($val) {
      $this->status = $val;
      return $this;
    }
    public function clearStatus() {
      unset($this->status);
      return $this;
    }
    public function hasStatus() {
      return isset($this->status);
    }
    public function getDescription() {
      if (!isset($this->description)) {
        return '';
      }
      return $this->description;
    }
    public function setDescription($val) {
      $this->description = $val;
      return $this;
    }
    public function clearDescription() {
      unset($this->description);
      return $this;
    }
    public function hasDescription() {
      return isset($this->description);
    }
    public function clear() {
      $this->clearStatus();
      $this->clearDescription();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->status)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->status);
      }
      if (isset($this->description)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->description));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->status)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->status);
      }
      if (isset($this->description)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->description);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setStatus($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setDescription(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->status)) return 'status';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasStatus()) {
        $this->setStatus($x->getStatus());
      }
      if ($x->hasDescription()) {
        $this->setDescription($x->getDescription());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->status) !== isset($x->status)) return false;
      if (isset($this->status) && $this->status !== $x->status) return false;
      if (isset($this->description) !== isset($x->description)) return false;
      if (isset($this->description) && $this->description !== $x->description) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->status)) {
        $res .= $prefix . "status: " . ($this->status) . "\n";
      }
      if (isset($this->description)) {
        $res .= $prefix . "description: " . $this->debugFormatString($this->description) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class GetCapabilitiesRequest extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class GetCapabilitiesResponse extends \google\net\ProtocolMessage {
    private $filesystem = array();
    public function getFilesystemSize() {
      return sizeof($this->filesystem);
    }
    public function getFilesystemList() {
      return $this->filesystem;
    }
    public function getFilesystem($idx) {
      return $this->filesystem[$idx];
    }
    public function setFilesystem($idx, $val) {
      $this->filesystem[$idx] = $val;
      return $this;
    }
    public function addFilesystem($val) {
      $this->filesystem[] = $val;
      return $this;
    }
    public function clearFilesystem() {
      $this->filesystem = array();
    }
    public function getShuffleAvailable() {
      if (!isset($this->shuffle_available)) {
        return false;
      }
      return $this->shuffle_available;
    }
    public function setShuffleAvailable($val) {
      $this->shuffle_available = $val;
      return $this;
    }
    public function clearShuffleAvailable() {
      unset($this->shuffle_available);
      return $this;
    }
    public function hasShuffleAvailable() {
      return isset($this->shuffle_available);
    }
    public function clear() {
      $this->clearFilesystem();
      $this->clearShuffleAvailable();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->filesystem);
      $res += 1 * sizeof($this->filesystem);
      foreach ($this->filesystem as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->shuffle_available)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->filesystem);
      foreach ($this->filesystem as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
      if (isset($this->shuffle_available)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->shuffle_available);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addFilesystem(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setShuffleAvailable($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->shuffle_available)) return 'shuffle_available';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getFilesystemList() as $v) {
        $this->addFilesystem($v);
      }
      if ($x->hasShuffleAvailable()) {
        $this->setShuffleAvailable($x->getShuffleAvailable());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->filesystem) !== sizeof($x->filesystem)) return false;
      foreach (array_map(null, $this->filesystem, $x->filesystem) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->shuffle_available) !== isset($x->shuffle_available)) return false;
      if (isset($this->shuffle_available) && $this->shuffle_available !== $x->shuffle_available) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->filesystem as $value) {
        $res .= $prefix . "filesystem: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->shuffle_available)) {
        $res .= $prefix . "shuffle_available: " . $this->debugFormatBool($this->shuffle_available) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class FinalizeRequest extends \google\net\ProtocolMessage {
    public function getFilename() {
      if (!isset($this->filename)) {
        return '';
      }
      return $this->filename;
    }
    public function setFilename($val) {
      $this->filename = $val;
      return $this;
    }
    public function clearFilename() {
      unset($this->filename);
      return $this;
    }
    public function hasFilename() {
      return isset($this->filename);
    }
    public function clear() {
      $this->clearFilename();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->filename)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->filename));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->filename)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->filename);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFilename(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->filename)) return 'filename';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFilename()) {
        $this->setFilename($x->getFilename());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->filename) !== isset($x->filename)) return false;
      if (isset($this->filename) && $this->filename !== $x->filename) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->filename)) {
        $res .= $prefix . "filename: " . $this->debugFormatString($this->filename) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class FinalizeResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class GetDefaultGsBucketNameRequest extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\files {
  class GetDefaultGsBucketNameResponse extends \google\net\ProtocolMessage {
    public function getDefaultGsBucketName() {
      if (!isset($this->default_gs_bucket_name)) {
        return '';
      }
      return $this->default_gs_bucket_name;
    }
    public function setDefaultGsBucketName($val) {
      $this->default_gs_bucket_name = $val;
      return $this;
    }
    public function clearDefaultGsBucketName() {
      unset($this->default_gs_bucket_name);
      return $this;
    }
    public function hasDefaultGsBucketName() {
      return isset($this->default_gs_bucket_name);
    }
    public function clear() {
      $this->clearDefaultGsBucketName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->default_gs_bucket_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->default_gs_bucket_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->default_gs_bucket_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->default_gs_bucket_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setDefaultGsBucketName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasDefaultGsBucketName()) {
        $this->setDefaultGsBucketName($x->getDefaultGsBucketName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->default_gs_bucket_name) !== isset($x->default_gs_bucket_name)) return false;
      if (isset($this->default_gs_bucket_name) && $this->default_gs_bucket_name !== $x->default_gs_bucket_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->default_gs_bucket_name)) {
        $res .= $prefix . "default_gs_bucket_name: " . $this->debugFormatString($this->default_gs_bucket_name) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ListDirRequest extends \google\net\ProtocolMessage {
    public function getPath() {
      if (!isset($this->path)) {
        return '';
      }
      return $this->path;
    }
    public function setPath($val) {
      $this->path = $val;
      return $this;
    }
    public function clearPath() {
      unset($this->path);
      return $this;
    }
    public function hasPath() {
      return isset($this->path);
    }
    public function getMarker() {
      if (!isset($this->marker)) {
        return '';
      }
      return $this->marker;
    }
    public function setMarker($val) {
      $this->marker = $val;
      return $this;
    }
    public function clearMarker() {
      unset($this->marker);
      return $this;
    }
    public function hasMarker() {
      return isset($this->marker);
    }
    public function getMaxKeys() {
      if (!isset($this->max_keys)) {
        return "0";
      }
      return $this->max_keys;
    }
    public function setMaxKeys($val) {
      if (is_double($val)) {
        $this->max_keys = sprintf('%0.0F', $val);
      } else {
        $this->max_keys = $val;
      }
      return $this;
    }
    public function clearMaxKeys() {
      unset($this->max_keys);
      return $this;
    }
    public function hasMaxKeys() {
      return isset($this->max_keys);
    }
    public function getPrefix() {
      if (!isset($this->prefix)) {
        return '';
      }
      return $this->prefix;
    }
    public function setPrefix($val) {
      $this->prefix = $val;
      return $this;
    }
    public function clearPrefix() {
      unset($this->prefix);
      return $this;
    }
    public function hasPrefix() {
      return isset($this->prefix);
    }
    public function clear() {
      $this->clearPath();
      $this->clearMarker();
      $this->clearMaxKeys();
      $this->clearPrefix();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->path)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->path));
      }
      if (isset($this->marker)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->marker));
      }
      if (isset($this->max_keys)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max_keys);
      }
      if (isset($this->prefix)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->prefix));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->path)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->path);
      }
      if (isset($this->marker)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->marker);
      }
      if (isset($this->max_keys)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->max_keys);
      }
      if (isset($this->prefix)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->prefix);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setPath(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setMarker(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setMaxKeys($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setPrefix(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->path)) return 'path';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasPath()) {
        $this->setPath($x->getPath());
      }
      if ($x->hasMarker()) {
        $this->setMarker($x->getMarker());
      }
      if ($x->hasMaxKeys()) {
        $this->setMaxKeys($x->getMaxKeys());
      }
      if ($x->hasPrefix()) {
        $this->setPrefix($x->getPrefix());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->path) !== isset($x->path)) return false;
      if (isset($this->path) && $this->path !== $x->path) return false;
      if (isset($this->marker) !== isset($x->marker)) return false;
      if (isset($this->marker) && $this->marker !== $x->marker) return false;
      if (isset($this->max_keys) !== isset($x->max_keys)) return false;
      if (isset($this->max_keys) && !$this->integerEquals($this->max_keys, $x->max_keys)) return false;
      if (isset($this->prefix) !== isset($x->prefix)) return false;
      if (isset($this->prefix) && $this->prefix !== $x->prefix) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->path)) {
        $res .= $prefix . "path: " . $this->debugFormatString($this->path) . "\n";
      }
      if (isset($this->marker)) {
        $res .= $prefix . "marker: " . $this->debugFormatString($this->marker) . "\n";
      }
      if (isset($this->max_keys)) {
        $res .= $prefix . "max_keys: " . $this->debugFormatInt64($this->max_keys) . "\n";
      }
      if (isset($this->prefix)) {
        $res .= $prefix . "prefix: " . $this->debugFormatString($this->prefix) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\files {
  class ListDirResponse extends \google\net\ProtocolMessage {
    private $filenames = array();
    public function getFilenamesSize() {
      return sizeof($this->filenames);
    }
    public function getFilenamesList() {
      return $this->filenames;
    }
    public function getFilenames($idx) {
      return $this->filenames[$idx];
    }
    public function setFilenames($idx, $val) {
      $this->filenames[$idx] = $val;
      return $this;
    }
    public function addFilenames($val) {
      $this->filenames[] = $val;
      return $this;
    }
    public function clearFilenames() {
      $this->filenames = array();
    }
    public function clear() {
      $this->clearFilenames();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->filenames);
      $res += 1 * sizeof($this->filenames);
      foreach ($this->filenames as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->filenames);
      foreach ($this->filenames as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addFilenames(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getFilenamesList() as $v) {
        $this->addFilenames($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->filenames) !== sizeof($x->filenames)) return false;
      foreach (array_map(null, $this->filenames, $x->filenames) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->filenames as $value) {
        $res .= $prefix . "filenames: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
