/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.DepthFirstSearch;
import org.apache.cayenne.ashwood.graph.DigraphIteration;

public class DepthFirstStampSearch<E>
extends DepthFirstSearch<E> {
    public static final int UNDEFINED_STAMP = -1;
    public static final int GROW_DEPTH_STAMP = 0;
    public static final int GROW_BREADTH_STAMP = 1;
    public static final int SHRINK_STAMP = 2;
    public static final int LEAF_STAMP = 3;
    private int stamp = -1;

    public DepthFirstStampSearch(DigraphIteration<E, ?> factory, E firstVertex) {
        super(factory, firstVertex);
    }

    public int getStamp() {
        return this.stamp;
    }

    @Override
    public E next() {
        ArcIterator i = (ArcIterator)this.stack.peek();
        Object origin = i.getOrigin();
        Object dst = i.getDestination();
        if (dst == null) {
            if (i.hasNext()) {
                i.next();
                dst = i.getDestination();
            } else {
                this.stack.pop();
                this.stamp = 3;
                return origin;
            }
        }
        if (this.seen.add(dst)) {
            this.stack.push(this.factory.outgoingIterator(dst));
            this.stamp = 0;
            if (i.hasNext()) {
                i.next();
            }
        } else if (i.hasNext()) {
            i.next();
            this.stamp = 1;
        } else {
            this.stack.pop();
            this.stamp = 2;
        }
        return origin;
    }
}

