/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateAttributeUndoableEdit;
import org.apache.cayenne.modeler.undo.CreateEmbAttributeUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.XMLSerializable;

public class CreateAttributeAction
extends CayenneAction {
    public CreateAttributeAction(Application application) {
        super(CreateAttributeAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create Attribute";
    }

    static void fireEmbeddableAttributeEvent(Object src, ProjectController mediator, Embeddable embeddable, EmbeddableAttribute attr) {
        mediator.fireEmbeddableAttributeEvent(new EmbeddableAttributeEvent(src, attr, embeddable, 2));
        EmbeddableAttributeDisplayEvent e = new EmbeddableAttributeDisplayEvent(src, embeddable, attr, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireEmbeddableAttributeDisplayEvent(e);
    }

    static void fireObjAttributeEvent(Object src, ProjectController mediator, DataMap map, ObjEntity objEntity, ObjAttribute attr) {
        mediator.fireObjAttributeEvent(new AttributeEvent(src, (Attribute)attr, (Entity)objEntity, 2));
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        AttributeDisplayEvent ade = new AttributeDisplayEvent(src, attr, (Entity)objEntity, map, domain);
        mediator.fireObjAttributeDisplayEvent(ade);
    }

    static void fireDbAttributeEvent(Object src, ProjectController mediator, DataMap map, DbEntity dbEntity, DbAttribute attr) {
        mediator.fireDbAttributeEvent(new AttributeEvent(src, (Attribute)attr, (Entity)dbEntity, 2));
        AttributeDisplayEvent ade = new AttributeDisplayEvent(src, attr, (Entity)dbEntity, map, (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireDbAttributeDisplayEvent(ade);
    }

    @Override
    public String getIconName() {
        return "icon-attribute.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        XMLSerializable attr;
        ProjectController mediator = this.getProjectController();
        if (this.getProjectController().getCurrentEmbeddable() != null) {
            Embeddable embeddable = mediator.getCurrentEmbeddable();
            attr = new EmbeddableAttribute();
            ((EmbeddableAttribute)attr).setName(NameBuilder.builder((ConfigurationNode)((Object)attr), embeddable).name());
            this.createEmbAttribute(embeddable, (EmbeddableAttribute)attr);
            this.application.getUndoManager().addEdit(new CreateEmbAttributeUndoableEdit(embeddable, new EmbeddableAttribute[]{attr}));
        }
        if (this.getProjectController().getCurrentObjEntity() != null) {
            ObjEntity objEntity = mediator.getCurrentObjEntity();
            attr = new ObjAttribute();
            ((Attribute)attr).setName(NameBuilder.builder((ConfigurationNode)((Object)attr), objEntity).name());
            this.createObjAttribute(mediator.getCurrentDataMap(), objEntity, (ObjAttribute)attr);
            this.application.getUndoManager().addEdit(new CreateAttributeUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), objEntity, (ObjAttribute)attr));
        } else if (this.getProjectController().getCurrentDbEntity() != null) {
            DbEntity dbEntity = this.getProjectController().getCurrentDbEntity();
            attr = new DbAttribute();
            ((Attribute)attr).setName(NameBuilder.builder((ConfigurationNode)((Object)attr), dbEntity).name());
            ((DbAttribute)attr).setType(Integer.MAX_VALUE);
            ((Attribute)attr).setEntity(dbEntity);
            this.createDbAttribute(mediator.getCurrentDataMap(), dbEntity, (DbAttribute)attr);
            this.application.getUndoManager().addEdit(new CreateAttributeUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), dbEntity, (DbAttribute)attr));
        }
    }

    public void createEmbAttribute(Embeddable embeddable, EmbeddableAttribute attr) {
        ProjectController mediator = this.getProjectController();
        embeddable.addAttribute(attr);
        CreateAttributeAction.fireEmbeddableAttributeEvent(this, mediator, embeddable, attr);
    }

    public void createObjAttribute(DataMap map, ObjEntity objEntity, ObjAttribute attr) {
        ProjectController mediator = this.getProjectController();
        objEntity.addAttribute(attr);
        CreateAttributeAction.fireObjAttributeEvent(this, mediator, map, objEntity, attr);
    }

    public void createDbAttribute(DataMap map, DbEntity dbEntity, DbAttribute attr) {
        dbEntity.addAttribute(attr);
        ProjectController mediator = this.getProjectController();
        CreateAttributeAction.fireDbAttributeEvent(this, mediator, map, dbEntity, attr);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Attribute) {
            return ((Attribute)((Object)object)).getParent() != null && ((Attribute)((Object)object)).getParent() instanceof Entity;
        }
        return false;
    }
}

