/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.validation.ValidationException;

public abstract class ValidatorTextAdapter
extends TextAdapter {
    static final long VALIDATION_DELAY = 1500L;
    boolean liveCheckEnabled;

    public ValidatorTextAdapter(JTextField textField) {
        this(textField, true);
    }

    public ValidatorTextAdapter(JTextField textField, boolean liveCheckEnabled) {
        super(textField, true, false, true);
        this.setLiveCheckEnabled(liveCheckEnabled);
        this.install(textField);
    }

    public ValidatorTextAdapter(JTextArea textArea) {
        this(textArea, true);
    }

    public ValidatorTextAdapter(JTextArea textArea, boolean liveCheckEnabled) {
        super(textArea, true, false);
        this.setLiveCheckEnabled(liveCheckEnabled);
        this.install(textArea);
    }

    protected void install(JTextComponent textComponent) {
        TimerScheduler ts = new TimerScheduler();
        textComponent.getDocument().addDocumentListener(ts);
        textComponent.addFocusListener(ts);
    }

    protected abstract void validate(String var1) throws ValidationException;

    public boolean isLiveCheckEnabled() {
        return this.liveCheckEnabled;
    }

    public void setLiveCheckEnabled(boolean b) {
        this.liveCheckEnabled = b;
    }

    protected void validate() {
        try {
            this.validate(this.textComponent.getText());
            this.clear();
        }
        catch (ValidationException vex) {
            this.textComponent.setBackground(this.errorColor);
            this.textComponent.setToolTipText(this.wrapTooltip(vex.getUnlabeledMessage()));
        }
    }

    protected String wrapTooltip(String tooltip) {
        tooltip = ValidatorTextAdapter.encodeHTMLAttribute(tooltip);
        tooltip = tooltip.replaceAll(System.getProperty("line.separator"), "<br>");
        return "<html>" + tooltip + "</html>";
    }

    public static String encodeHTMLAttribute(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                encoded.append("&lt;");
                continue;
            }
            if (c == '\"') {
                encoded.append("&quot;");
                continue;
            }
            if (c == '>') {
                encoded.append("&gt;");
                continue;
            }
            if (c == '&') {
                encoded.append("&amp;");
                continue;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    class TimerScheduler
    implements DocumentListener,
    FocusListener {
        Timer validationTimer;

        TimerScheduler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.schedule();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.schedule();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.schedule();
        }

        void schedule() {
            if (ValidatorTextAdapter.this.isLiveCheckEnabled()) {
                if (this.validationTimer != null) {
                    this.validationTimer.cancel();
                }
                ValidatorTextAdapter.this.clear();
                this.validationTimer = new Timer("cayenne-validation-timer");
                this.validationTimer.schedule((TimerTask)new ValidationTimerTask(), 1500L);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.validationTimer != null) {
                this.validationTimer.cancel();
            }
        }
    }

    class ValidationTimerTask
    extends TimerTask {
        ValidationTimerTask() {
        }

        @Override
        public void run() {
            ValidatorTextAdapter.this.validate();
        }
    }
}

