/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class IteratorChain<E>
implements Iterator<E> {
    protected final List<Iterator<E>> iteratorChain = new ArrayList<Iterator<E>>();
    protected int currentIteratorIndex = 0;
    protected Iterator<E> currentIterator = null;
    protected Iterator<E> lastUsedIterator = null;
    protected boolean isLocked = false;

    public void addIterator(Iterator<E> iterator) {
        this.checkLocked();
        this.iteratorChain.add(Objects.requireNonNull(iterator));
    }

    public int size() {
        return this.iteratorChain.size();
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private void lockChain() {
        if (!this.isLocked) {
            this.isLocked = true;
        }
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iteratorChain.isEmpty() ? Collections.emptyIterator() : this.iteratorChain.get(0);
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.size() - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = this.iteratorChain.get(this.currentIteratorIndex);
        }
    }

    @Override
    public boolean hasNext() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.lockChain();
        if (this.currentIterator == null) {
            this.updateCurrentIterator();
        }
        this.lastUsedIterator.remove();
    }
}

