/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.Digraph;

public class IndegreeTopologicalSort<E>
implements Iterator<E> {
    private Digraph<E, ?> digraph;
    private List<E> vertices = new LinkedList();
    private Map<E, InDegree> inDegrees = new HashMap<E, InDegree>();
    private ListIterator<E> current;

    public IndegreeTopologicalSort(Digraph<E, ?> digraph) {
        this.digraph = digraph;
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            this.vertices.add(vertex);
            this.inDegrees.put(vertex, new InDegree(digraph.incomingSize(vertex)));
        }
        this.current = this.vertices.listIterator();
    }

    @Override
    public boolean hasNext() {
        return !this.vertices.isEmpty();
    }

    @Override
    public E next() {
        boolean progress = true;
        while (this.hasNext()) {
            if (!this.current.hasNext()) {
                if (!progress) break;
                progress = false;
                this.current = this.vertices.listIterator();
            }
            E vertex = this.current.next();
            InDegree indegree = this.inDegrees.get(vertex);
            if (indegree.value != 0) continue;
            this.removeVertex(vertex);
            this.current.remove();
            return vertex;
        }
        return null;
    }

    private void removeVertex(E vertex) {
        ArcIterator i = this.digraph.outgoingIterator(vertex);
        while (i.hasNext()) {
            i.next();
            E dst = i.getDestination();
            InDegree indegree = this.inDegrees.get(dst);
            --indegree.value;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method remove() not supported.");
    }

    private static class InDegree {
        int value;

        InDegree(int value) {
            this.value = value;
        }
    }
}

