/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.reflect.PropertyDescriptor;

public abstract class RelationshipFault<E> {
    protected Persistent relationshipOwner;
    protected String relationshipName;

    protected RelationshipFault() {
    }

    public RelationshipFault(Persistent relationshipOwner, String relationshipName) {
        if (relationshipOwner == null) {
            throw new NullPointerException("'relationshipOwner' can't be null.");
        }
        if (relationshipName == null) {
            throw new NullPointerException("'relationshipName' can't be null.");
        }
        this.relationshipOwner = relationshipOwner;
        this.relationshipName = relationshipName;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public Persistent getRelationshipOwner() {
        return this.relationshipOwner;
    }

    protected boolean isTransientParent() {
        int state = this.relationshipOwner.getPersistenceState();
        return state == 2 || state == 1;
    }

    protected boolean isUncommittedParent() {
        int state = this.relationshipOwner.getPersistenceState();
        return state == 4 || state == 6;
    }

    protected abstract void mergeLocalChanges(List<E> var1);

    protected List<E> resolveFromDB() {
        if (this.isTransientParent()) {
            return new ArrayList();
        }
        boolean refresh = this.relationshipOwner.getObjectContext().getChannel() instanceof DataDomain;
        ArrayList resolved = this.relationshipOwner.getObjectContext().performQuery(new RelationshipQuery(this.relationshipOwner.getObjectId(), this.relationshipName, refresh));
        if (resolved instanceof RelationshipFault) {
            resolved = new ArrayList(resolved);
        }
        this.mergeLocalChanges(resolved);
        if (resolved.isEmpty()) {
            return resolved;
        }
        this.updateReverse(resolved);
        return resolved;
    }

    protected void updateReverse(List<E> resolved) {
        EntityResolver resolver = this.relationshipOwner.getObjectContext().getEntityResolver();
        ObjEntity sourceEntity = resolver.getObjEntity(this.relationshipOwner.getObjectId().getEntityName());
        ObjRelationship relationship = sourceEntity.getRelationship(this.relationshipName);
        ObjRelationship reverse = relationship.getReverseRelationship();
        if (reverse != null && !reverse.isToMany()) {
            PropertyDescriptor property = resolver.getClassDescriptor(reverse.getSourceEntity().getName()).getProperty(reverse.getName());
            for (E o : resolved) {
                property.writePropertyDirectly(o, null, this.relationshipOwner);
            }
        }
    }
}

