/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.dbsync.merge.context.MergeDirection;
import org.apache.cayenne.dbsync.merge.token.AbstractMergerToken;
import org.apache.cayenne.dbsync.reverse.dbload.ModelMergeDelegate;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

public abstract class AbstractToModelToken
extends AbstractMergerToken {
    protected AbstractToModelToken(String tokenName, int sortingWeight) {
        super(tokenName, sortingWeight);
    }

    protected static void remove(ModelMergeDelegate mergerContext, DbRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            AbstractToModelToken.remove(mergerContext, rel.getReverseRelationship(), false);
        }
        DbEntity dbEntity = rel.getSourceEntity();
        for (ObjEntity objEntity : dbEntity.mappedObjEntities()) {
            AbstractToModelToken.remove(mergerContext, objEntity.getRelationshipForDbRelationship(rel), true);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
        mergerContext.dbRelationshipRemoved(rel);
    }

    protected static void remove(ModelMergeDelegate mergerContext, ObjRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            AbstractToModelToken.remove(mergerContext, rel.getReverseRelationship(), false);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
        mergerContext.objRelationshipRemoved(rel);
    }

    @Override
    public final MergeDirection getDirection() {
        return MergeDirection.TO_MODEL;
    }

    static abstract class EntityAndColumn
    extends Entity {
        private final DbAttribute column;

        protected EntityAndColumn(String tokenName, int sortingWeight, DbEntity entity, DbAttribute column) {
            super(tokenName, sortingWeight, entity);
            this.column = column;
        }

        public DbAttribute getColumn() {
            return this.column;
        }

        @Override
        public String getTokenValue() {
            return this.getEntity().getName() + "." + this.getColumn().getName();
        }
    }

    static abstract class Entity
    extends AbstractToModelToken {
        private final DbEntity entity;

        protected Entity(String tokenName, int sortingWeight, DbEntity entity) {
            super(tokenName, sortingWeight);
            this.entity = entity;
        }

        public DbEntity getEntity() {
            return this.entity;
        }

        public Collection<ObjEntity> getMappedObjEntities() {
            Collection entities = this.entity.mappedObjEntities();
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                if (((ObjEntity)iterator.next()).getSuperEntity() == null) continue;
                iterator.remove();
            }
            return entities;
        }

        @Override
        public String getTokenValue() {
            return this.getEntity().getName();
        }
    }
}

