/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionCountTest {
    private static final Option VERBOSITY = new Option("v", "verbosity: use multiple times for more");
    private static final Options OPTIONS = new Options().addOption(VERBOSITY);

    OptionCountTest() {
    }

    @Test
    void testFiveSwitchesMixed() throws ParseException {
        CommandLine cmdLine = new DefaultParser().parse(OPTIONS, new String[]{"-v", "-vvv", "-v"});
        Assertions.assertEquals((int)5, (int)cmdLine.getOptionCount(VERBOSITY));
    }

    @Test
    void testNoSwitch() throws ParseException {
        CommandLine cmdLine = new DefaultParser().parse(OPTIONS, new String[0]);
        Assertions.assertEquals((int)0, (int)cmdLine.getOptionCount(VERBOSITY));
    }

    @Test
    void testOneSwitch() throws ParseException {
        CommandLine cmdLine = new DefaultParser().parse(OPTIONS, new String[]{"-v"});
        Assertions.assertEquals((int)1, (int)cmdLine.getOptionCount(VERBOSITY));
        Assertions.assertEquals((int)1, (int)cmdLine.getOptionCount("v"));
        Assertions.assertEquals((int)1, (int)cmdLine.getOptionCount('v'));
    }

    @Test
    void testThreeSwitches() throws ParseException {
        CommandLine cmdLine = new DefaultParser().parse(OPTIONS, new String[]{"-v", "-v", "-v"});
        Assertions.assertEquals((int)3, (int)cmdLine.getOptionCount(VERBOSITY));
    }

    @Test
    void testThreeSwitchesCompact() throws ParseException {
        CommandLine cmdLine = new DefaultParser().parse(OPTIONS, new String[]{"-vvv"});
        Assertions.assertEquals((int)3, (int)cmdLine.getOptionCount(VERBOSITY));
    }
}

