/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import org.apache.commons.collections4.bloomfilter.AbstractBitMapExtractorTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitMapExtractorFromIndexExtractorTest
extends AbstractBitMapExtractorTest {
    @Override
    protected BitMapExtractor createEmptyExtractor() {
        IndexExtractor indexExtractor = consumer -> true;
        return BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)200);
    }

    @Override
    protected BitMapExtractor createExtractor() {
        IndexExtractor indexExtractor = consumer -> consumer.test(0) && consumer.test(1) && consumer.test(63) && consumer.test(64) && consumer.test(127) && consumer.test(128);
        return BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)200);
    }

    @Test
    public final void testFromIndexExtractor() {
        ArrayList lst = new ArrayList();
        this.createExtractor().processBitMaps(lst::add);
        long[] buckets = lst.stream().mapToLong(Long::longValue).toArray();
        Assertions.assertTrue((boolean)BitMaps.contains((long[])buckets, (int)0));
        Assertions.assertTrue((boolean)BitMaps.contains((long[])buckets, (int)1));
        Assertions.assertTrue((boolean)BitMaps.contains((long[])buckets, (int)63));
        Assertions.assertTrue((boolean)BitMaps.contains((long[])buckets, (int)64));
        Assertions.assertTrue((boolean)BitMaps.contains((long[])buckets, (int)127));
        Assertions.assertTrue((boolean)BitMaps.contains((long[])buckets, (int)128));
    }
}

