/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.iterators.IteratorIterable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IteratorIterableTest
extends BulkTest {
    private Iterator<Integer> createIterator() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        return list.iterator();
    }

    @Test
    public void testIterator() {
        Iterator<Integer> iter = this.createIterator();
        IteratorIterable iterable = new IteratorIterable(iter);
        this.verifyIteration((Iterable<Number>)iterable);
        for (Number actual : iterable) {
            Assertions.fail((String)"should not be able to iterate twice");
        }
    }

    @Test
    public void testMultipleUserIterator() {
        Iterator<Integer> iter = this.createIterator();
        IteratorIterable iterable = new IteratorIterable(iter, true);
        this.verifyIteration((Iterable<Number>)iterable);
        this.verifyIteration((Iterable<Number>)iterable);
    }

    private void verifyIteration(Iterable<Number> iterable) {
        int expected = 0;
        for (Number actual : iterable) {
            Assertions.assertEquals((int)expected, (int)actual.intValue());
            ++expected;
        }
        Assertions.assertTrue((expected > 0 ? 1 : 0) != 0);
    }
}

