/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SingletonIterator2Test<E>
extends AbstractIteratorTest<E> {
    private static final Object testValue = "foo";

    @Override
    public SingletonIterator<E> makeEmptyIterator() {
        SingletonIterator iter = new SingletonIterator(testValue);
        iter.next();
        iter.remove();
        iter.reset();
        return iter;
    }

    @Override
    public SingletonIterator<E> makeObject() {
        return new SingletonIterator(testValue, false);
    }

    @Override
    public boolean supportsEmptyIterator() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testIterator() {
        SingletonIterator<E> iter = this.makeObject();
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"Iterator has a first item");
        Object iterValue = iter.next();
        Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.next());
    }

    @Test
    public void testReset() {
        SingletonIterator<E> it = this.makeObject();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)testValue, (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it.reset();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)testValue, (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it.reset();
        it.reset();
        Assertions.assertTrue((boolean)it.hasNext());
    }
}

