/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.PredicatedList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedListTest<E>
extends AbstractListTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = String.class::isInstance;

    protected List<E> decorateList(List<E> list, Predicate<E> predicate) {
        return PredicatedList.predicatedList(list, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    @Override
    public List<E> makeObject() {
        return this.decorateList(new ArrayList(), this.truePredicate);
    }

    public List<E> makeTestList() {
        return this.decorateList(new ArrayList(), this.testPredicate);
    }

    @Test
    public void testIllegalAdd() {
        List list = this.makeTestList();
        Integer i = 3;
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.add(i), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)list.contains(i), (String)"Collection shouldn't contain illegal element");
    }

    @Test
    public void testIllegalAddAll() {
        List list = this.makeTestList();
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add("one");
        elements.add("two");
        elements.add(3);
        elements.add("four");
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.addAll(0, elements), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)list.contains("one"), (String)"List shouldn't contain illegal element");
        Assertions.assertFalse((boolean)list.contains("two"), (String)"List shouldn't contain illegal element");
        Assertions.assertFalse((boolean)list.contains(3), (String)"List shouldn't contain illegal element");
        Assertions.assertFalse((boolean)list.contains("four"), (String)"List shouldn't contain illegal element");
    }

    @Test
    public void testIllegalSet() {
        List list = this.makeTestList();
        Assertions.assertThrows(IllegalArgumentException.class, () -> list.set(0, 3), (String)"Integer should fail string predicate.");
    }

    @Test
    public void testLegalAddAll() {
        List<String> list = this.makeTestList();
        list.add("zero");
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("one");
        elements.add("two");
        elements.add("three");
        list.addAll(1, elements);
        Assertions.assertTrue((boolean)list.contains("zero"), (String)"List should contain legal element");
        Assertions.assertTrue((boolean)list.contains("one"), (String)"List should contain legal element");
        Assertions.assertTrue((boolean)list.contains("two"), (String)"List should contain legal element");
        Assertions.assertTrue((boolean)list.contains("three"), (String)"List should contain legal element");
    }

    @Test
    public void testSubList() {
        List<String> list = this.makeTestList();
        list.add("zero");
        List<E> subList = list.subList(0, 0);
        Assertions.assertNotNull(subList);
        Assertions.assertEquals((int)0, (int)subList.size());
        subList = list.subList(0, 1);
        Assertions.assertEquals((int)1, (int)subList.size());
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("one");
        elements.add("two");
        elements.add("three");
        list.addAll(1, elements);
        subList = list.subList(0, list.size());
        Assertions.assertEquals((int)list.size(), (int)subList.size());
    }
}

