/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PassiveExpiringMapTest<K, V>
extends AbstractMapTest<PassiveExpiringMap<K, V>, K, V> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    private Map<Integer, String> makeDecoratedTestMap() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(1, "one");
        m.put(2, "two");
        m.put(3, "three");
        m.put(4, "four");
        m.put(5, "five");
        m.put(6, "six");
        return new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new TestExpirationPolicy(), m);
    }

    @Override
    public PassiveExpiringMap<K, V> makeObject() {
        return new PassiveExpiringMap();
    }

    private Map<Integer, String> makeTestMap() {
        PassiveExpiringMap m = new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new TestExpirationPolicy());
        m.put(1, "one");
        m.put(2, "two");
        m.put(3, "three");
        m.put(4, "four");
        m.put(5, "five");
        m.put(6, "six");
        return m;
    }

    @Test
    public void testConstructors() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Map map = null;
            new PassiveExpiringMap(map);
        });
        Assertions.assertThrows(NullPointerException.class, () -> {
            PassiveExpiringMap.ExpirationPolicy policy = null;
            new PassiveExpiringMap(policy);
        });
        Assertions.assertThrows(NullPointerException.class, () -> {
            TimeUnit unit = null;
            new PassiveExpiringMap(10L, unit);
        });
    }

    @Test
    public void testContainsKey() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertFalse((boolean)m.containsKey(1));
        Assertions.assertFalse((boolean)m.containsKey(3));
        Assertions.assertFalse((boolean)m.containsKey(5));
        Assertions.assertTrue((boolean)m.containsKey(2));
        Assertions.assertTrue((boolean)m.containsKey(4));
        Assertions.assertTrue((boolean)m.containsKey(6));
    }

    @Test
    public void testContainsValue() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertFalse((boolean)m.containsValue("one"));
        Assertions.assertFalse((boolean)m.containsValue("three"));
        Assertions.assertFalse((boolean)m.containsValue("five"));
        Assertions.assertTrue((boolean)m.containsValue("two"));
        Assertions.assertTrue((boolean)m.containsValue("four"));
        Assertions.assertTrue((boolean)m.containsValue("six"));
    }

    @Test
    public void testDecoratedMap() {
        Map<Integer, String> m = this.makeDecoratedTestMap();
        Assertions.assertEquals((int)6, (int)m.size());
        Assertions.assertEquals((Object)"one", (Object)m.get(1));
        Assertions.assertEquals((Object)"two", (Object)m.get(2));
        m.remove(2);
        Assertions.assertEquals((int)5, (int)m.size());
        Assertions.assertEquals((Object)"one", (Object)m.get(1));
        Assertions.assertNull((Object)m.get(2));
        Assertions.assertNull((Object)m.get(2));
        m.put(2, "two");
        Assertions.assertEquals((int)6, (int)m.size());
        Assertions.assertEquals((Object)"one", (Object)m.get(1));
        Assertions.assertEquals((Object)"two", (Object)m.get(2));
        m.put(1, "one-one");
        Assertions.assertEquals((int)5, (int)m.size());
        Assertions.assertNull((Object)m.get(1));
        Assertions.assertEquals((Object)"two", (Object)m.get(2));
    }

    @Test
    public void testEntrySet() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertEquals((int)3, (int)m.entrySet().size());
    }

    @Test
    public void testExpiration() throws InterruptedException {
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap(500L), 500L);
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap(1000L), 1000L);
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new PassiveExpiringMap.ConstantTimeToLiveExpirationPolicy(500L)), 500L);
        this.validateExpiration((Map<String, String>)new PassiveExpiringMap((PassiveExpiringMap.ExpirationPolicy)new PassiveExpiringMap.ConstantTimeToLiveExpirationPolicy(1L, TimeUnit.SECONDS)), 1000L);
    }

    @Test
    public void testGet() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertNull((Object)m.get(1));
        Assertions.assertEquals((Object)"two", (Object)m.get(2));
        Assertions.assertNull((Object)m.get(3));
        Assertions.assertEquals((Object)"four", (Object)m.get(4));
        Assertions.assertNull((Object)m.get(5));
        Assertions.assertEquals((Object)"six", (Object)m.get(6));
    }

    @Test
    public void testIsEmpty() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertFalse((boolean)m.isEmpty());
        m = this.makeTestMap();
        m.remove(2);
        m.remove(4);
        m.remove(6);
        Assertions.assertTrue((boolean)m.isEmpty());
    }

    @Test
    public void testKeySet() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertEquals((int)3, (int)m.size());
    }

    @Test
    public void testPut() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertNull((Object)m.put(1, "ONE"));
        Assertions.assertEquals((Object)"two", (Object)m.put(2, "TWO"));
        Assertions.assertNull((Object)m.put(3, "THREE"));
        Assertions.assertEquals((Object)"four", (Object)m.put(4, "FOUR"));
        Assertions.assertNull((Object)m.put(5, "FIVE"));
        Assertions.assertEquals((Object)"six", (Object)m.put(6, "SIX"));
    }

    @Test
    public void testSize() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertEquals((int)3, (int)m.size());
    }

    @Test
    public void testValues() {
        Map<Integer, String> m = this.makeTestMap();
        Assertions.assertEquals((int)3, (int)m.size());
    }

    @Test
    public void testZeroTimeToLive() {
        PassiveExpiringMap m = new PassiveExpiringMap(0L);
        m.put((Object)"a", (Object)"b");
        Assertions.assertNull((Object)m.get((Object)"a"));
    }

    private void validateExpiration(Map<String, String> map, long timeout) throws InterruptedException {
        map.put("a", "b");
        Assertions.assertNotNull((Object)map.get("a"));
        Thread.sleep(2L * timeout);
        Assertions.assertNull((Object)map.get("a"));
    }

    private static final class TestExpirationPolicy
    implements PassiveExpiringMap.ExpirationPolicy<Integer, String> {
        private static final long serialVersionUID = 1L;

        private TestExpirationPolicy() {
        }

        public long expirationTime(Integer key, String value) {
            if (key == null) {
                return 0L;
            }
            if (key % 2 == 0) {
                return -1L;
            }
            return 0L;
        }
    }
}

