/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MethodMap {
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;
    Map methodByNameMap = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public void add(Method method) {
        String methodName = method.getName();
        ArrayList<Method> l = this.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List get(String key) {
        return (List)this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] args) throws AmbiguousException {
        List methodList = this.get(methodName);
        if (methodList == null) {
            return null;
        }
        int l = args.length;
        Class[] classes = new Class[l];
        int i = 0;
        while (i < l) {
            Object arg = args[i];
            classes[i] = arg == null ? null : arg.getClass();
            ++i;
        }
        return MethodMap.getMostSpecific(methodList, classes);
    }

    private static Method getMostSpecific(List methods, Class[] classes) throws AmbiguousException {
        LinkedList applicables = MethodMap.getApplicables(methods, classes);
        if (applicables.isEmpty()) {
            return null;
        }
        if (applicables.size() == 1) {
            return (Method)applicables.getFirst();
        }
        LinkedList<Method> maximals = new LinkedList<Method>();
        Iterator applicable = applicables.iterator();
        while (applicable.hasNext()) {
            Method app = (Method)applicable.next();
            Class[] appArgs = app.getParameterTypes();
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (!lessSpecific && maximal.hasNext()) {
                Method max = (Method)maximal.next();
                switch (MethodMap.moreSpecific(appArgs, max.getParameterTypes())) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(app);
        }
        if (maximals.size() > 1) {
            throw new AmbiguousException();
        }
        return (Method)maximals.getFirst();
    }

    private static int moreSpecific(Class[] c1, Class[] c2) {
        boolean c1MoreSpecific = false;
        boolean c2MoreSpecific = false;
        int i = 0;
        while (i < c1.length) {
            if (c1[i] != c2[i]) {
                c1MoreSpecific = c1MoreSpecific || MethodMap.isStrictMethodInvocationConvertible(c2[i], c1[i]);
                c2MoreSpecific = c2MoreSpecific || MethodMap.isStrictMethodInvocationConvertible(c1[i], c2[i]);
            }
            ++i;
        }
        if (c1MoreSpecific) {
            if (c2MoreSpecific) {
                return 2;
            }
            return 0;
        }
        if (c2MoreSpecific) {
            return 1;
        }
        return 2;
    }

    private static LinkedList getApplicables(List methods, Class[] classes) {
        LinkedList<Method> list = new LinkedList<Method>();
        Iterator imethod = methods.iterator();
        while (imethod.hasNext()) {
            Method method = (Method)imethod.next();
            if (!MethodMap.isApplicable(method, classes)) continue;
            list.add(method);
        }
        return list;
    }

    private static boolean isApplicable(Method method, Class[] classes) {
        Class<?>[] methodArgs = method.getParameterTypes();
        if (methodArgs.length != classes.length) {
            return false;
        }
        int i = 0;
        while (i < classes.length) {
            if (!MethodMap.isMethodInvocationConvertible(methodArgs[i], classes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isMethodInvocationConvertible(Class formal, Class actual) {
        block120: {
            block129: {
                block127: {
                    block128: {
                        block125: {
                            block126: {
                                block123: {
                                    block124: {
                                        block121: {
                                            block122: {
                                                if (actual == null && !formal.isPrimitive()) {
                                                    return true;
                                                }
                                                if (actual != null && formal.isAssignableFrom(actual)) {
                                                    return true;
                                                }
                                                if (!formal.isPrimitive()) break block120;
                                                if (formal == Boolean.TYPE) {
                                                    Class<?> clazz = class$0;
                                                    if (clazz == null) {
                                                        try {
                                                            clazz = class$0 = Class.forName("java.lang.Boolean");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (actual == clazz) {
                                                        return true;
                                                    }
                                                }
                                                if (formal == Character.TYPE) {
                                                    Class<?> clazz = class$1;
                                                    if (clazz == null) {
                                                        try {
                                                            clazz = class$1 = Class.forName("java.lang.Character");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (actual == clazz) {
                                                        return true;
                                                    }
                                                }
                                                if (formal == Byte.TYPE) {
                                                    Class<?> clazz = class$2;
                                                    if (clazz == null) {
                                                        try {
                                                            clazz = class$2 = Class.forName("java.lang.Byte");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (actual == clazz) {
                                                        return true;
                                                    }
                                                }
                                                if (formal != Short.TYPE) break block121;
                                                Class<?> clazz = class$3;
                                                if (clazz == null) {
                                                    try {
                                                        clazz = class$3 = Class.forName("java.lang.Short");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (actual == clazz) break block122;
                                                Class<?> clazz2 = class$2;
                                                if (clazz2 == null) {
                                                    try {
                                                        clazz2 = class$2 = Class.forName("java.lang.Byte");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (actual != clazz2) break block121;
                                            }
                                            return true;
                                        }
                                        if (formal != Integer.TYPE) break block123;
                                        Class<?> clazz = class$4;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$4 = Class.forName("java.lang.Integer");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (actual == clazz) break block124;
                                        Class<?> clazz3 = class$3;
                                        if (clazz3 == null) {
                                            try {
                                                clazz3 = class$3 = Class.forName("java.lang.Short");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (actual == clazz3) break block124;
                                        Class<?> clazz4 = class$2;
                                        if (clazz4 == null) {
                                            try {
                                                clazz4 = class$2 = Class.forName("java.lang.Byte");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (actual != clazz4) break block123;
                                    }
                                    return true;
                                }
                                if (formal != Long.TYPE) break block125;
                                Class<?> clazz = class$5;
                                if (clazz == null) {
                                    try {
                                        clazz = class$5 = Class.forName("java.lang.Long");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (actual == clazz) break block126;
                                Class<?> clazz5 = class$4;
                                if (clazz5 == null) {
                                    try {
                                        clazz5 = class$4 = Class.forName("java.lang.Integer");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (actual == clazz5) break block126;
                                Class<?> clazz6 = class$3;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = class$3 = Class.forName("java.lang.Short");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (actual == clazz6) break block126;
                                Class<?> clazz7 = class$2;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = class$2 = Class.forName("java.lang.Byte");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (actual != clazz7) break block125;
                            }
                            return true;
                        }
                        if (formal != Float.TYPE) break block127;
                        Class<?> clazz = class$6;
                        if (clazz == null) {
                            try {
                                clazz = class$6 = Class.forName("java.lang.Float");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (actual == clazz) break block128;
                        Class<?> clazz8 = class$5;
                        if (clazz8 == null) {
                            try {
                                clazz8 = class$5 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (actual == clazz8) break block128;
                        Class<?> clazz9 = class$4;
                        if (clazz9 == null) {
                            try {
                                clazz9 = class$4 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (actual == clazz9) break block128;
                        Class<?> clazz10 = class$3;
                        if (clazz10 == null) {
                            try {
                                clazz10 = class$3 = Class.forName("java.lang.Short");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (actual == clazz10) break block128;
                        Class<?> clazz11 = class$2;
                        if (clazz11 == null) {
                            try {
                                clazz11 = class$2 = Class.forName("java.lang.Byte");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (actual != clazz11) break block127;
                    }
                    return true;
                }
                if (formal != Double.TYPE) break block120;
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (actual == clazz) break block129;
                Class<?> clazz12 = class$6;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$6 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (actual == clazz12) break block129;
                Class<?> clazz13 = class$5;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$5 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (actual == clazz13) break block129;
                Class<?> clazz14 = class$4;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$4 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (actual == clazz14) break block129;
                Class<?> clazz15 = class$3;
                if (clazz15 == null) {
                    try {
                        clazz15 = class$3 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (actual == clazz15) break block129;
                Class<?> clazz16 = class$2;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$2 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (actual != clazz16) break block120;
            }
            return true;
        }
        return false;
    }

    private static boolean isStrictMethodInvocationConvertible(Class formal, Class actual) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Short.TYPE && actual == Byte.TYPE) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Float.TYPE || actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    public static class AmbiguousException
    extends Exception {
    }
}

