/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.SinkFactory;

public class RandomAccessSink
implements Sink {
    private SinkFactory sinkFactory;
    private String encoding;
    private OutputStream coreOutputStream;
    private Sink coreSink;
    private List<Sink> sinks = new ArrayList<Sink>();
    private List<ByteArrayOutputStream> outputStreams = new ArrayList<ByteArrayOutputStream>();
    private Sink currentSink;

    public RandomAccessSink(SinkFactory sinkFactory, OutputStream stream) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = stream;
        this.coreSink = this.currentSink = sinkFactory.createSink(stream);
    }

    public RandomAccessSink(SinkFactory sinkFactory, OutputStream stream, String encoding) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = stream;
        this.encoding = encoding;
        this.coreSink = this.currentSink = sinkFactory.createSink(stream, encoding);
    }

    public RandomAccessSink(SinkFactory sinkFactory, File outputDirectory, String outputName) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = new FileOutputStream(new File(outputDirectory, outputName));
        this.coreSink = this.currentSink = sinkFactory.createSink(this.coreOutputStream);
    }

    public RandomAccessSink(SinkFactory sinkFactory, File outputDirectory, String outputName, String encoding) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = new FileOutputStream(new File(outputDirectory, outputName));
        this.encoding = encoding;
        this.coreSink = this.currentSink = sinkFactory.createSink(this.coreOutputStream, encoding);
    }

    public Sink addSinkHook() {
        Sink subSink = null;
        try {
            ByteArrayOutputStream subOut = new ByteArrayOutputStream();
            ByteArrayOutputStream newOut = new ByteArrayOutputStream();
            this.outputStreams.add(subOut);
            this.outputStreams.add(newOut);
            if (this.encoding != null) {
                subSink = this.sinkFactory.createSink(subOut, this.encoding);
                this.currentSink = this.sinkFactory.createSink(newOut, this.encoding);
            } else {
                subSink = this.sinkFactory.createSink(subOut);
                this.currentSink = this.sinkFactory.createSink(newOut);
            }
            this.sinks.add(subSink);
            this.sinks.add(this.currentSink);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return subSink;
    }

    public void anchor(String name) {
        this.currentSink.anchor(name);
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.currentSink.anchor(name, attributes);
    }

    public void anchor_() {
        this.currentSink.anchor_();
    }

    public void author() {
        this.currentSink.author();
    }

    public void author(SinkEventAttributes attributes) {
        this.currentSink.author(attributes);
    }

    public void author_() {
        this.currentSink.author_();
    }

    public void body() {
        this.currentSink.body();
    }

    public void body(SinkEventAttributes attributes) {
        this.currentSink.body(attributes);
    }

    public void body_() {
        this.currentSink.body_();
    }

    public void bold() {
        this.currentSink.bold();
    }

    public void bold_() {
        this.currentSink.bold_();
    }

    public void close() {
        for (Sink sink : this.sinks) {
            sink.close();
        }
        this.coreSink.close();
    }

    public void comment(String comment) {
        this.currentSink.comment(comment);
    }

    public void date() {
        this.currentSink.date();
    }

    public void date(SinkEventAttributes attributes) {
        this.currentSink.date(attributes);
    }

    public void date_() {
        this.currentSink.date_();
    }

    public void definedTerm() {
        this.currentSink.definedTerm();
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.currentSink.definedTerm(attributes);
    }

    public void definedTerm_() {
        this.currentSink.definedTerm_();
    }

    public void definition() {
        this.currentSink.definition();
    }

    public void definition(SinkEventAttributes attributes) {
        this.currentSink.definition(attributes);
    }

    public void definitionList() {
        this.currentSink.definitionList();
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.currentSink.definitionList(attributes);
    }

    public void definitionListItem() {
        this.currentSink.definitionListItem();
    }

    public void definitionListItem(SinkEventAttributes attributes) {
        this.currentSink.definitionListItem(attributes);
    }

    public void definitionListItem_() {
        this.currentSink.definitionListItem_();
    }

    public void definitionList_() {
        this.currentSink.definitionList_();
    }

    public void definition_() {
        this.currentSink.definition_();
    }

    public void figure() {
        this.currentSink.figure();
    }

    public void figure(SinkEventAttributes attributes) {
        this.currentSink.figure(attributes);
    }

    public void figureCaption() {
        this.currentSink.figureCaption();
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.currentSink.figureCaption(attributes);
    }

    public void figureCaption_() {
        this.currentSink.figureCaption_();
    }

    public void figureGraphics(String name) {
        this.currentSink.figureGraphics(name);
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        this.currentSink.figureGraphics(src, attributes);
    }

    public void figure_() {
        this.currentSink.figure_();
    }

    public void flush() {
        for (int i = 0; i < this.sinks.size(); ++i) {
            Sink sink = this.sinks.get(i);
            sink.flush();
            ByteArrayOutputStream stream = this.outputStreams.get(i);
            try {
                this.coreOutputStream.write(stream.toByteArray());
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.coreSink.flush();
    }

    public void head() {
        this.currentSink.head();
    }

    public void head(SinkEventAttributes attributes) {
        this.currentSink.head(attributes);
    }

    public void head_() {
        this.currentSink.head_();
    }

    public void horizontalRule() {
        this.currentSink.horizontalRule();
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.currentSink.horizontalRule(attributes);
    }

    public void italic() {
        this.currentSink.italic();
    }

    public void italic_() {
        this.currentSink.italic_();
    }

    public void lineBreak() {
        this.currentSink.lineBreak();
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.currentSink.lineBreak(attributes);
    }

    public void link(String name) {
        this.currentSink.link(name);
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.currentSink.link(name, attributes);
    }

    public void link_() {
        this.currentSink.link_();
    }

    public void list() {
        this.currentSink.list();
    }

    public void list(SinkEventAttributes attributes) {
        this.currentSink.list(attributes);
    }

    public void listItem() {
        this.currentSink.listItem();
    }

    public void listItem(SinkEventAttributes attributes) {
        this.currentSink.listItem(attributes);
    }

    public void listItem_() {
        this.currentSink.listItem_();
    }

    public void list_() {
        this.currentSink.list_();
    }

    public void monospaced() {
        this.currentSink.monospaced();
    }

    public void monospaced_() {
        this.currentSink.monospaced_();
    }

    public void nonBreakingSpace() {
        this.currentSink.nonBreakingSpace();
    }

    public void numberedList(int numbering) {
        this.currentSink.numberedList(numbering);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.currentSink.numberedList(numbering, attributes);
    }

    public void numberedListItem() {
        this.currentSink.numberedListItem();
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.currentSink.numberedListItem(attributes);
    }

    public void numberedListItem_() {
        this.currentSink.numberedListItem_();
    }

    public void numberedList_() {
        this.currentSink.numberedList_();
    }

    public void pageBreak() {
        this.currentSink.pageBreak();
    }

    public void paragraph() {
        this.currentSink.paragraph();
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.currentSink.paragraph(attributes);
    }

    public void paragraph_() {
        this.currentSink.paragraph_();
    }

    public void rawText(String text) {
        this.currentSink.rawText(text);
    }

    public void section(int level, SinkEventAttributes attributes) {
        this.currentSink.section(level, attributes);
    }

    public void section1() {
        this.currentSink.section1();
    }

    public void section1_() {
        this.currentSink.section1_();
    }

    public void section2() {
        this.currentSink.section2();
    }

    public void section2_() {
        this.currentSink.section2_();
    }

    public void section3() {
        this.currentSink.section3();
    }

    public void section3_() {
        this.currentSink.section3_();
    }

    public void section4() {
        this.currentSink.section4();
    }

    public void section4_() {
        this.currentSink.section4_();
    }

    public void section5() {
        this.currentSink.section5();
    }

    public void section5_() {
        this.currentSink.section5_();
    }

    public void sectionTitle() {
        this.currentSink.sectionTitle();
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.currentSink.sectionTitle(level, attributes);
    }

    public void sectionTitle1() {
        this.currentSink.sectionTitle1();
    }

    public void sectionTitle1_() {
        this.currentSink.sectionTitle1_();
    }

    public void sectionTitle2() {
        this.currentSink.sectionTitle2();
    }

    public void sectionTitle2_() {
        this.currentSink.sectionTitle2_();
    }

    public void sectionTitle3() {
        this.currentSink.sectionTitle3();
    }

    public void sectionTitle3_() {
        this.currentSink.sectionTitle3_();
    }

    public void sectionTitle4() {
        this.currentSink.sectionTitle4();
    }

    public void sectionTitle4_() {
        this.currentSink.sectionTitle4_();
    }

    public void sectionTitle5() {
        this.currentSink.sectionTitle5();
    }

    public void sectionTitle5_() {
        this.currentSink.sectionTitle5_();
    }

    public void sectionTitle_() {
        this.currentSink.sectionTitle_();
    }

    public void sectionTitle_(int level) {
        this.currentSink.sectionTitle_(level);
    }

    public void section_(int level) {
        this.currentSink.section_(level);
    }

    public void table() {
        this.currentSink.table();
    }

    public void table(SinkEventAttributes attributes) {
        this.currentSink.table(attributes);
    }

    public void tableCaption() {
        this.currentSink.tableCaption();
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.currentSink.tableCaption(attributes);
    }

    public void tableCaption_() {
        this.currentSink.tableCaption_();
    }

    public void tableCell() {
        this.currentSink.tableCell();
    }

    public void tableCell(String width) {
        this.currentSink.tableCell(width);
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.currentSink.tableCell(attributes);
    }

    public void tableCell_() {
        this.currentSink.tableCell_();
    }

    public void tableHeaderCell() {
        this.currentSink.tableHeaderCell();
    }

    public void tableHeaderCell(String width) {
        this.currentSink.tableHeaderCell(width);
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.currentSink.tableHeaderCell(attributes);
    }

    public void tableHeaderCell_() {
        this.currentSink.tableHeaderCell_();
    }

    public void tableRow() {
        this.currentSink.tableRow();
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.currentSink.tableRow(attributes);
    }

    public void tableRow_() {
        this.currentSink.tableRow_();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.currentSink.tableRows(justification, grid);
    }

    public void tableRows_() {
        this.currentSink.tableRows_();
    }

    public void table_() {
        this.currentSink.table_();
    }

    public void text(String text) {
        this.currentSink.text(text);
    }

    public void text(String text, SinkEventAttributes attributes) {
        this.currentSink.text(text, attributes);
    }

    public void title() {
        this.currentSink.title();
    }

    public void title(SinkEventAttributes attributes) {
        this.currentSink.title(attributes);
    }

    public void title_() {
        this.currentSink.title_();
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.currentSink.unknown(name, requiredParams, attributes);
    }

    public void verbatim(boolean boxed) {
        this.currentSink.verbatim(boxed);
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.currentSink.verbatim(attributes);
    }

    public void verbatim_() {
        this.currentSink.verbatim_();
    }

    public void enableLogging(Log log) {
        this.currentSink.enableLogging(log);
    }
}

