/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;

public class CheckboxInputControl
extends InputControl {
    public static final String NAME = "checkbox";
    private final Class<? extends HtmlSelectBooleanCheckbox> inputComponentClass;

    public CheckboxInputControl(String name, Class<? extends HtmlSelectBooleanCheckbox> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public CheckboxInputControl() {
        this(NAME, HtmlSelectBooleanCheckbox.class);
    }

    @Override
    public void renderValue(Object value, InputControl.ValueInfo vi, ResponseWriter writer) throws IOException {
        Boolean boolValue = value instanceof Boolean ? (Boolean)value : (ObjectUtils.isEmpty((Object)value) ? null : Boolean.valueOf(ObjectUtils.getBoolean((Object)value)));
        writer.startElement("div", null);
        if (boolValue == null) {
            writer.writeAttribute("class", (Object)"eTypeBoolNull", null);
        } else if (boolValue.booleanValue()) {
            writer.writeAttribute("class", (Object)"eTypeBoolTrue", null);
        } else {
            writer.writeAttribute("class", (Object)"eTypeBoolFalse", null);
        }
        writer.append((CharSequence)HTML_EXPR_NBSP);
        writer.endElement("div");
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        HtmlSelectBooleanCheckbox input = InputControlManager.createComponent(context, this.inputComponentClass);
        this.copyAttributes(parent, ii, (UIInput)input);
        compList.add((UIComponent)input);
        this.updateInputState(compList, ii, context, PhaseId.RENDER_RESPONSE);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof HtmlSelectBooleanCheckbox)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "compList.get(0)");
        }
        HtmlSelectBooleanCheckbox input = (HtmlSelectBooleanCheckbox)comp;
        boolean disabled = ii.isDisabled();
        input.setDisabled(disabled);
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.setInputStyleClass((UIInput)input, ii);
            this.setInputValue((UIInput)input, ii);
        }
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        return ObjectUtils.getBoolean((Object)value);
    }
}

