/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ArrayMap;
import org.apache.empire.commons.ArraySet;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBCaseExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBCaseWhenExpr
extends DBCaseExpr {
    private final Map<DBCompareExpr, Object> whenMap;
    private final Object elseValue;

    public DBCaseWhenExpr(DBDatabase db, Map<DBCompareExpr, ? extends Object> whenMap, Object elseValue) {
        super(db);
        if (whenMap == null || whenMap.isEmpty() && ObjectUtils.isEmpty(elseValue)) {
            throw new InvalidArgumentException("whenMap | elseValue", null);
        }
        this.whenMap = whenMap;
        this.elseValue = elseValue;
        this.init(whenMap, elseValue);
    }

    public DBCaseWhenExpr(DBCompareExpr cmpExpr, Object trueExpr, Object elseValue) {
        super((DBDatabase)cmpExpr.getDatabase());
        if (this.isNull(trueExpr) && this.isNull(elseValue)) {
            throw new InvalidArgumentException("trueExpr | elseValue", null);
        }
        this.whenMap = new ArrayMap<DBCompareExpr, Object>(1);
        this.whenMap.put(cmpExpr, trueExpr);
        this.elseValue = elseValue;
        this.init(this.whenMap, elseValue);
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder(40);
        name.append("CASE");
        if (!this.whenMap.isEmpty()) {
            DBCompareExpr firstCmpExpr = this.whenMap.keySet().iterator().next();
            ArraySet<DBColumn> cols = new ArraySet<DBColumn>(1);
            firstCmpExpr.addReferencedColumns(cols);
            for (DBColumn col : cols) {
                name.append("_");
                name.append(col.getName());
            }
        }
        return name.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBCaseWhenExpr) {
            DBCaseWhenExpr otherCase = (DBCaseWhenExpr)other;
            if (this.whenMap.size() != otherCase.whenMap.size()) {
                return false;
            }
            if (this.whenMap.isEmpty()) {
                return ObjectUtils.compareEqual(this.elseValue, otherCase.elseValue);
            }
            Iterator<DBCompareExpr> thisIterator = this.whenMap.keySet().iterator();
            Iterator<DBCompareExpr> otherIterator = otherCase.whenMap.keySet().iterator();
            while (thisIterator.hasNext()) {
                DBCompareExpr otherCmpExpr;
                DBCompareExpr thisCmpExpr = thisIterator.next();
                if (thisCmpExpr.equals(otherCmpExpr = otherIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        for (Map.Entry<DBCompareExpr, Object> entry : this.whenMap.entrySet()) {
            if (entry.getKey() != null) {
                entry.getKey().addReferencedColumns(list);
            }
            if (!(entry.getValue() instanceof DBExpr)) continue;
            ((DBExpr)entry.getValue()).addReferencedColumns(list);
        }
        if (this.elseValue instanceof DBExpr) {
            ((DBExpr)this.elseValue).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        context &= 0xFFFFFFFFFFFFFFF7L;
        if (!this.whenMap.isEmpty()) {
            sql.append("CASE");
            for (Map.Entry<DBCompareExpr, Object> entry : this.whenMap.entrySet()) {
                sql.append(" WHEN ");
                DBCompareExpr compExpr = entry.getKey();
                compExpr.addSQL(sql, context);
                sql.append(" THEN ");
                sql.appendValue(this.getDataType(), entry.getValue(), context);
            }
            sql.append(" ELSE ");
        }
        sql.appendValue(this.getDataType(), this.elseValue, context);
        if (!this.whenMap.isEmpty()) {
            sql.append(" END");
        }
    }
}

