/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;

public class ContentSinkSubscriber
implements Flow.Subscriber<Content.Chunk> {
    private final AtomicInteger lastAndComplete = new AtomicInteger(2);
    private final AtomicBoolean callbackComplete = new AtomicBoolean();
    private final Content.Sink sink;
    private final Callback callback;
    private Flow.Subscription subscription;

    public ContentSinkSubscriber(Content.Sink sink, Callback callback) {
        this.sink = sink;
        this.callback = callback;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(final Content.Chunk chunk) {
        chunk.retain();
        this.sink.write(chunk.isLast(), chunk.getByteBuffer(), new Callback(){
            final /* synthetic */ ContentSinkSubscriber this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void succeeded() {
                chunk.release();
                if (chunk.isLast()) {
                    this.this$0.complete();
                } else {
                    this.this$0.subscription.request(1L);
                }
            }

            @Override
            public void failed(Throwable failure) {
                chunk.release();
                this.this$0.subscription.cancel();
                this.this$0.error(failure);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.getInvocationType(this.this$0.callback);
            }
        });
    }

    @Override
    public void onError(Throwable failure) {
        this.error(failure);
    }

    private void error(Throwable failure) {
        if (this.callbackComplete.compareAndSet(false, true)) {
            this.callback.failed(failure);
        }
    }

    @Override
    public void onComplete() {
        this.complete();
    }

    private void complete() {
        if (this.lastAndComplete.decrementAndGet() == 0 && this.callbackComplete.compareAndSet(false, true)) {
            this.callback.succeeded();
        }
    }
}

