/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.collections;

import java.util.Map;
import org.multiverse.api.Stm;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.collections.TxnIterator;
import org.multiverse.api.collections.TxnSet;
import org.multiverse.api.exceptions.TodoException;
import org.multiverse.collections.AbstractTxnCollection;
import org.multiverse.collections.AbstractTxnIterator;
import org.multiverse.collections.NaiveTxnHashMap;

public final class NaiveTxnHashSet<E>
extends AbstractTxnCollection<E>
implements TxnSet<E> {
    private final NaiveTxnHashMap<E, Object> map;

    public NaiveTxnHashSet(Stm stm) {
        super(stm);
        this.map = new NaiveTxnHashMap(stm);
    }

    @Override
    public boolean add(Txn tx, E e) {
        return this.map.put(tx, e, this) == null;
    }

    @Override
    public boolean contains(Object item) {
        return this.contains(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public boolean contains(Txn tx, Object o) {
        return this.map.get(tx, o) != null;
    }

    @Override
    public boolean remove(Object item) {
        return this.remove(TxnThreadLocal.getThreadLocalTxn(), item);
    }

    @Override
    public boolean remove(Txn tx, Object item) {
        return this.map.remove(tx, item) != null;
    }

    @Override
    public int size(Txn tx) {
        return this.map.size(tx);
    }

    @Override
    public void clear(Txn tx) {
        this.map.clear(tx);
    }

    @Override
    public TxnIterator<E> iterator(Txn tx) {
        return this.map.keySet(tx).iterator(tx);
    }

    @Override
    public String toString(Txn tx) {
        throw new TodoException();
    }

    static class It<E>
    extends AbstractTxnIterator<E> {
        private final TxnIterator<Map.Entry<E, Object>> iterator;

        It(TxnIterator<Map.Entry<E, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext(Txn tx) {
            return this.iterator.hasNext(tx);
        }

        @Override
        public E next(Txn tx) {
            return this.iterator.next(tx).getKey();
        }

        @Override
        public void remove(Txn tx) {
            this.iterator.remove(tx);
        }
    }
}

