/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.lang;

import java.util.HashSet;

public final class IgniteStringFormatter {
    private static final char DELIM_START = '{';
    private static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static String format(String messagePattern, Object ... params) {
        if (messagePattern == null) {
            return null;
        }
        if (params == null) {
            return messagePattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int l = 0; l < params.length; ++l) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern, i, messagePattern.length());
                return sbuf.toString();
            }
            if (IgniteStringFormatter.isEscapedDelimiter(messagePattern, j)) {
                if (!IgniteStringFormatter.isDoubleEscaped(messagePattern, j)) {
                    --l;
                    sbuf.append(messagePattern, i, j - 1).append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern, i, j - 1);
                IgniteStringFormatter.deeplyAppendParameter(sbuf, params[l], new HashSet<Object[]>());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern, i, j);
            IgniteStringFormatter.deeplyAppendParameter(sbuf, params[l], new HashSet<Object[]>());
            i = j + 2;
        }
        sbuf.append(messagePattern, i, messagePattern.length());
        return sbuf.toString();
    }

    private static boolean isEscapedDelimiter(String messagePattern, int delimiterStartIndex) {
        if (delimiterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimiterStartIndex - 1);
        return potentialEscape == '\\';
    }

    private static boolean isDoubleEscaped(String messagePattern, int delimiterStartIndex) {
        return delimiterStartIndex >= 2 && messagePattern.charAt(delimiterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, HashSet<Object[]> seenSet) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            IgniteStringFormatter.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            IgniteStringFormatter.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            IgniteStringFormatter.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            IgniteStringFormatter.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            IgniteStringFormatter.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            IgniteStringFormatter.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            IgniteStringFormatter.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            IgniteStringFormatter.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            IgniteStringFormatter.doubleArrayAppend(sbuf, (double[])o);
        } else {
            IgniteStringFormatter.objectArrayAppend(sbuf, (Object[])o, seenSet);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String s = o.toString();
            sbuf.append(s);
        }
        catch (Throwable t) {
            sbuf.append("Failed toString() invocation on an object of type [cls=").append(o.getClass().getName()).append(", errMsg=").append(t.getClass().getName()).append(", errMsg=").append(t.getMessage()).append(']');
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, HashSet<Object[]> seenSet) {
        sbuf.append('[');
        if (!seenSet.contains(a)) {
            seenSet.add(a);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                IgniteStringFormatter.deeplyAppendParameter(sbuf, a[i], seenSet);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            seenSet.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

