/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.InitParametersBuilder;
import org.jetbrains.annotations.Nullable;

public class InitParameters {
    private final Collection<String> metaStorageNodeNames;
    private final Collection<String> cmgNodeNames;
    private final String clusterName;
    private final String clusterConfiguration;

    InitParameters(@Nullable Collection<String> metaStorageNodeNames, @Nullable Collection<String> cmgNodeNames, String clusterName, @Nullable String clusterConfiguration) {
        Objects.requireNonNull(clusterName);
        this.metaStorageNodeNames = metaStorageNodeNames != null ? List.copyOf(metaStorageNodeNames) : Collections.emptyList();
        this.cmgNodeNames = cmgNodeNames != null ? List.copyOf(cmgNodeNames) : Collections.emptyList();
        this.clusterName = clusterName;
        this.clusterConfiguration = clusterConfiguration;
    }

    public static InitParametersBuilder builder() {
        return new InitParametersBuilder();
    }

    public Collection<String> metaStorageNodeNames() {
        return this.metaStorageNodeNames;
    }

    public Collection<String> cmgNodeNames() {
        return this.cmgNodeNames;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String clusterConfiguration() {
        return this.clusterConfiguration;
    }
}

