/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.mappers;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.ignite3.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class CustomTupleImpl
implements Tuple {
    private final Map<String, Integer> nameToIdMap;
    private final Object[] values;

    public CustomTupleImpl(Map<String, Integer> nameToIdMap) {
        this.nameToIdMap = nameToIdMap;
        this.values = new Object[this.nameToIdMap.size()];
    }

    public int columnCount() {
        return this.values.length;
    }

    public String columnName(int i) {
        if (i >= this.columnCount()) {
            throw new IllegalArgumentException("Out of bounds, tuple only has " + this.columnCount() + " columns.");
        }
        for (Map.Entry<String, Integer> e : this.nameToIdMap.entrySet()) {
            if (e.getValue() != i) continue;
            return e.getKey();
        }
        throw new IllegalStateException("This should never have happened");
    }

    public int columnIndex(String s) {
        return this.nameToIdMap.getOrDefault(s, -1);
    }

    @Nullable
    public <T> T valueOrDefault(String s, @Nullable T t) {
        int idx = this.columnIndex(s);
        return (T)(idx == -1 ? t : this.values[idx]);
    }

    public Tuple set(String s, @Nullable Object o) {
        int idx = this.columnIndex(s);
        if (idx == -1) {
            throw new IllegalArgumentException("Column does not exist: " + s);
        }
        return this.set(idx, o);
    }

    public Tuple set(int idx, @Nullable Object o) {
        this.values[idx] = o;
        return this;
    }

    @Nullable
    public <T> T value(String s) throws IllegalArgumentException {
        return this.value(this.columnIndex(s));
    }

    @Nullable
    public <T> T value(int i) {
        return (T)this.values[i];
    }

    public boolean booleanValue(String s) {
        throw new NotImplementedException();
    }

    public boolean booleanValue(int i) {
        throw new NotImplementedException();
    }

    public byte byteValue(String s) {
        throw new NotImplementedException();
    }

    public byte byteValue(int i) {
        throw new NotImplementedException();
    }

    public short shortValue(String s) {
        throw new NotImplementedException();
    }

    public short shortValue(int i) {
        throw new NotImplementedException();
    }

    public int intValue(String s) {
        return (Integer)this.value(s);
    }

    public int intValue(int i) {
        return (Integer)this.value(i);
    }

    public long longValue(String s) {
        throw new NotImplementedException();
    }

    public long longValue(int i) {
        throw new NotImplementedException();
    }

    public float floatValue(String s) {
        throw new NotImplementedException();
    }

    public float floatValue(int i) {
        throw new NotImplementedException();
    }

    public double doubleValue(String s) {
        throw new NotImplementedException();
    }

    public double doubleValue(int i) {
        throw new NotImplementedException();
    }

    public BigDecimal decimalValue(String s) {
        throw new NotImplementedException();
    }

    public BigDecimal decimalValue(int i) {
        throw new NotImplementedException();
    }

    public String stringValue(String s) {
        throw new NotImplementedException();
    }

    public String stringValue(int i) {
        throw new NotImplementedException();
    }

    public byte[] bytesValue(String s) {
        throw new NotImplementedException();
    }

    public byte[] bytesValue(int i) {
        throw new NotImplementedException();
    }

    public UUID uuidValue(String s) {
        throw new NotImplementedException();
    }

    public UUID uuidValue(int i) {
        throw new NotImplementedException();
    }

    public LocalDate dateValue(String s) {
        throw new NotImplementedException();
    }

    public LocalDate dateValue(int i) {
        throw new NotImplementedException();
    }

    public LocalTime timeValue(String s) {
        throw new NotImplementedException();
    }

    public LocalTime timeValue(int i) {
        throw new NotImplementedException();
    }

    public LocalDateTime datetimeValue(String s) {
        throw new NotImplementedException();
    }

    public LocalDateTime datetimeValue(int i) {
        throw new NotImplementedException();
    }

    public Instant timestampValue(String s) {
        throw new NotImplementedException();
    }

    public Instant timestampValue(int i) {
        throw new NotImplementedException();
    }

    public int hashCode() {
        return Tuple.hashCode((Tuple)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Tuple ? Tuple.equals((Tuple)this, (Tuple)((Tuple)obj)) : false;
    }
}

