/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config;

import java.beans.PropertyDescriptor;
import java.io.File;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.loader.CustomBeanFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Ignite2ConfigurationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ignite2ConfigurationUtils.class);

    private Ignite2ConfigurationUtils() {
    }

    public static IgniteConfiguration loadIgnite2Configuration(File inputFile, boolean skipUnloadableBeans) {
        return Ignite2ConfigurationUtils.loadIgnite2Configuration((Resource)new FileSystemResource(inputFile), Ignite2ConfigurationUtils.createBeanFactory(skipUnloadableBeans), null);
    }

    public static IgniteConfiguration loadIgnite2Configuration(File inputFile, boolean skipUnloadableBeans, @Nullable ClassLoader clientClassLoader) {
        return Ignite2ConfigurationUtils.loadIgnite2Configuration((Resource)new FileSystemResource(inputFile), Ignite2ConfigurationUtils.createBeanFactory(skipUnloadableBeans), clientClassLoader);
    }

    public static IgniteConfiguration loadIgnite2Configuration(Resource rsrc, DefaultListableBeanFactory factory, @Nullable ClassLoader classLoader) throws BeansException, IllegalStateException {
        GenericApplicationContext springCtx = new GenericApplicationContext(factory);
        springCtx.setClassLoader(classLoader);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx);
        reader.setValidationMode(3);
        int n = reader.loadBeanDefinitions(rsrc);
        LOGGER.info("Loaded Spring definition into memory: {}", (Object)n);
        springCtx.refresh();
        return (IgniteConfiguration)factory.getBean(IgniteConfiguration.class);
    }

    public static DefaultListableBeanFactory createBeanFactory(boolean skipUnloadableBeans) {
        if (skipUnloadableBeans) {
            HashSetValuedHashMap propertyTracker = new HashSetValuedHashMap();
            return new CustomBeanFactory((MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>>)propertyTracker);
        }
        return new DefaultListableBeanFactory();
    }
}

