/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class CatalogSchemaDescriptorSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class SchemaDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSchemaDescriptor> {
        SchemaDescriptorSerializerV2() {
        }

        @Override
        public CatalogSchemaDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp(updateTimestampLong);
            List<CatalogTableDescriptor> tables = input.readCompactEntryList(CatalogTableDescriptor.class);
            List<CatalogIndexDescriptor> indexes = input.readEntryList(CatalogIndexDescriptor.class);
            List<CatalogSystemViewDescriptor> systemViews = input.readCompactEntryList(CatalogSystemViewDescriptor.class);
            return new CatalogSchemaDescriptor(id, name, tables.toArray(new CatalogTableDescriptor[0]), indexes.toArray(new CatalogIndexDescriptor[0]), systemViews.toArray(new CatalogSystemViewDescriptor[0]), updateTimestamp);
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeCompactEntryList(Arrays.asList(descriptor.tables()));
            output.writeEntryList(Arrays.asList(descriptor.indexes()));
            output.writeCompactEntryList(Arrays.asList(descriptor.systemViews()));
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class SchemaDescriptorSerializerV1
    implements CatalogObjectSerializer<CatalogSchemaDescriptor> {
        private final CatalogEntrySerializerProvider serializers;
        private final CatalogSerializationUtils.IndexDescriptorSerializerHelper indexSerializeHelper;

        public SchemaDescriptorSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
            this.indexSerializeHelper = new CatalogSerializationUtils.IndexDescriptorSerializerHelper(serializers);
        }

        @Override
        public CatalogSchemaDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer tableDescriptorSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE.id());
            CatalogObjectSerializer viewDescriptorSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SYSTEM_VIEW.id());
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            input.readVarInt();
            CatalogTableDescriptor[] tables = CatalogSerializationUtils.readArray(tableDescriptorSerializer, input, CatalogTableDescriptor.class);
            CatalogIndexDescriptor[] indexes = CatalogSerializationUtils.readArray(this.indexSerializeHelper, input, CatalogIndexDescriptor.class);
            CatalogSystemViewDescriptor[] systemViews = CatalogSerializationUtils.readArray(viewDescriptorSerializer, input, CatalogSystemViewDescriptor.class);
            return new CatalogSchemaDescriptor(id, name, tables, indexes, systemViews, CatalogManager.INITIAL_TIMESTAMP);
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            CatalogObjectSerializer tableDescriptorSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE.id());
            CatalogObjectSerializer viewDescriptorSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SYSTEM_VIEW.id());
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            CatalogSerializationUtils.writeArray(descriptor.tables(), tableDescriptorSerializer, output);
            CatalogSerializationUtils.writeArray(descriptor.indexes(), this.indexSerializeHelper, output);
            CatalogSerializationUtils.writeArray(descriptor.systemViews(), viewDescriptorSerializer, output);
        }
    }
}

