/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.recovery.states;

import java.util.List;
import org.apache.ignite3.internal.cli.commands.recovery.partitions.states.PartitionStatesMixin;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.jetbrains.annotations.Nullable;

public class PartitionStatesCallInput
implements CallInput {
    private final String clusterUrl;
    private final boolean local;
    private final List<String> nodeNames;
    private final List<String> zoneNames;
    private final List<Integer> partitionIds;

    public String clusterUrl() {
        return this.clusterUrl;
    }

    public boolean local() {
        return this.local;
    }

    public List<String> nodeNames() {
        return this.nodeNames;
    }

    public List<String> zoneNames() {
        return this.zoneNames;
    }

    public List<Integer> partitionIds() {
        return this.partitionIds;
    }

    private PartitionStatesCallInput(String clusterUrl, boolean local, @Nullable List<String> nodeNames, @Nullable List<String> zoneNames, @Nullable List<Integer> partitionIds) {
        this.clusterUrl = clusterUrl;
        this.local = local;
        this.nodeNames = nodeNames == null ? List.of() : List.copyOf(nodeNames);
        this.zoneNames = zoneNames == null ? List.of() : List.copyOf(zoneNames);
        this.partitionIds = partitionIds == null ? List.of() : List.copyOf(partitionIds);
    }

    public static PartitionStatesCallInput of(PartitionStatesMixin statesArgs, String clusterUrl) {
        return PartitionStatesCallInput.builder().local(statesArgs.local()).nodeNames(statesArgs.nodeNames()).zoneNames(statesArgs.zoneNames()).partitionIds(statesArgs.partitionIds()).clusterUrl(clusterUrl).build();
    }

    private static PartitionStatesCallInputBuilder builder() {
        return new PartitionStatesCallInputBuilder();
    }

    private static class PartitionStatesCallInputBuilder {
        private String clusterUrl;
        private boolean local;
        @Nullable
        private List<String> nodeNames;
        @Nullable
        private List<String> zoneNames;
        @Nullable
        private List<Integer> partitionIds;

        private PartitionStatesCallInputBuilder() {
        }

        PartitionStatesCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        PartitionStatesCallInputBuilder local(boolean local) {
            this.local = local;
            return this;
        }

        PartitionStatesCallInputBuilder nodeNames(@Nullable List<String> nodeNames) {
            this.nodeNames = nodeNames;
            return this;
        }

        PartitionStatesCallInputBuilder zoneNames(@Nullable List<String> zoneNames) {
            this.zoneNames = zoneNames;
            return this;
        }

        PartitionStatesCallInputBuilder partitionIds(@Nullable List<Integer> partitionIds) {
            this.partitionIds = partitionIds;
            return this;
        }

        PartitionStatesCallInput build() {
            return new PartitionStatesCallInput(this.clusterUrl, this.local, this.nodeNames, this.zoneNames, this.partitionIds);
        }
    }
}

