/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.node.unit;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.node.unit.NodeListUnitCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.UnitListOptionsMixin;
import org.apache.ignite3.internal.cli.commands.node.NodeUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.decorators.UnitListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Shows a list of deployed units"})
public class NodeUnitListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private UnitListOptionsMixin listOptions;
    @CommandLine.Mixin
    private NodeUrlMixin nodeUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @Inject
    private NodeListUnitCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.nodeUrl.getNodeUrl()).map(this.listOptions::toListUnitCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list units")).print(new UnitListDecorator(this.plain)));
    }
}

