/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.client.IgniteClientFeatureNotSupportedByServerException;
import org.apache.ignite3.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite3.internal.client.proto.ProtocolVersion;
import org.apache.ignite3.network.ClusterNode;

public class ProtocolContext {
    private final ProtocolVersion ver;
    private final Set<ProtocolBitmaskFeature> features;
    private final long serverIdleTimeout;
    private final ClusterNode clusterNode;
    private final List<UUID> clusterIds;
    private final String clusterName;

    ProtocolContext(ProtocolVersion ver, EnumSet<ProtocolBitmaskFeature> features, long serverIdleTimeout, ClusterNode clusterNode, List<UUID> clusterIds, String clusterName) {
        this.ver = ver;
        this.features = Collections.unmodifiableSet(features != null ? features : EnumSet.noneOf(ProtocolBitmaskFeature.class));
        this.serverIdleTimeout = serverIdleTimeout;
        this.clusterNode = clusterNode;
        this.clusterIds = clusterIds;
        this.clusterName = clusterName;
    }

    public boolean isFeatureSupported(ProtocolBitmaskFeature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean allFeaturesSupported(ProtocolBitmaskFeature ... features) {
        for (ProtocolBitmaskFeature feature : features) {
            if (this.features.contains((Object)feature)) continue;
            return false;
        }
        return true;
    }

    public void checkFeatureSupported(ProtocolBitmaskFeature feature) throws IgniteClientFeatureNotSupportedByServerException {
        if (!this.isFeatureSupported(feature)) {
            throw new IgniteClientFeatureNotSupportedByServerException(feature.name());
        }
    }

    public Set<ProtocolBitmaskFeature> features() {
        return this.features;
    }

    public ProtocolVersion version() {
        return this.ver;
    }

    public long serverIdleTimeout() {
        return this.serverIdleTimeout;
    }

    public ClusterNode clusterNode() {
        return this.clusterNode;
    }

    public List<UUID> clusterIds() {
        return this.clusterIds;
    }

    public UUID clusterId() {
        return this.clusterIds.get(this.clusterIds.size() - 1);
    }

    public String clusterName() {
        return this.clusterName;
    }
}

