/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.queue;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.compute.events.ComputeEventsFactory;
import org.apache.ignite3.internal.compute.queue.BoundedPriorityBlockingQueue;
import org.apache.ignite3.internal.compute.queue.ComputeThreadPoolExecutor;
import org.apache.ignite3.internal.compute.queue.QueueExecution;
import org.apache.ignite3.internal.compute.queue.QueueExecutionImpl;
import org.apache.ignite3.internal.compute.state.ComputeStateMachine;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.jetbrains.annotations.Nullable;

public class PriorityQueueExecutor {
    private final ComputeThreadPoolExecutor executor;
    private final ComputeStateMachine stateMachine;
    private final EventLog eventLog;

    public PriorityQueueExecutor(ComputeConfiguration configuration, ThreadFactory threadFactory, ComputeStateMachine stateMachine, EventLog eventLog) {
        this.stateMachine = stateMachine;
        this.eventLog = eventLog;
        BoundedPriorityBlockingQueue<Runnable> workQueue = new BoundedPriorityBlockingQueue<Runnable>(() -> (Integer)configuration.queueMaxSize().value());
        this.executor = new ComputeThreadPoolExecutor((Integer)configuration.threadPoolSize().value(), (Integer)configuration.threadPoolSize().value(), 0L, TimeUnit.SECONDS, workQueue, threadFactory);
    }

    public <R> QueueExecution<R> submit(Callable<CompletableFuture<R>> job, int priority, int maxRetries) {
        return this.submit(job, priority, maxRetries, null);
    }

    public <R> QueueExecution<R> submit(Callable<CompletableFuture<R>> job, int priority, int maxRetries, @Nullable ComputeEventMetadataBuilder metadataBuilder) {
        Objects.requireNonNull(job);
        UUID jobId = this.stateMachine.initJob();
        if (metadataBuilder != null && metadataBuilder.jobId() == null) {
            metadataBuilder.jobId(jobId);
        }
        ComputeEventMetadata eventMetadata = metadataBuilder != null ? metadataBuilder.build() : null;
        ComputeEventsFactory.logJobQueuedEvent(this.eventLog, eventMetadata);
        QueueExecutionImpl<R> execution = new QueueExecutionImpl<R>(jobId, job, priority, this.executor, this.stateMachine, this.eventLog, eventMetadata);
        execution.run(maxRetries);
        return execution;
    }

    public <R> QueueExecution<R> submit(Callable<CompletableFuture<R>> job) {
        return this.submit(job, 0, 0);
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

