/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.deployunit.metastore.ClusterEventCallback;
import org.apache.ignite3.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.util.CompletableFutures;

public class ClusterStatusWatchListener
implements WatchListener {
    private final ClusterEventCallback clusterEventCallback;

    public ClusterStatusWatchListener(ClusterEventCallback clusterEventCallback) {
        this.clusterEventCallback = clusterEventCallback;
    }

    @Override
    public CompletableFuture<Void> onUpdate(WatchEvent event) {
        for (EntryEvent e : event.entryEvents()) {
            byte[] value = e.newEntry().value();
            if (value == null) continue;
            UnitClusterStatus unitStatus = UnitClusterStatus.deserialize(value);
            this.clusterEventCallback.onUpdate(unitStatus);
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

