/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageServiceImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.TestOnly;

class MetaStorageLearnerManager {
    private static final IgniteLogger LOG = Loggers.forClass(MetaStorageLearnerManager.class);
    private final IgniteSpinBusyLock busyLock;
    private final LogicalTopologyService logicalTopologyService;
    private final FailureProcessor failureProcessor;
    private final CompletableFuture<MetaStorageServiceImpl> metaStorageSvcFut;
    private volatile boolean learnersAdditionEnabled = true;

    MetaStorageLearnerManager(IgniteSpinBusyLock busyLock, LogicalTopologyService logicalTopologyService, FailureProcessor failureProcessor, CompletableFuture<MetaStorageServiceImpl> metaStorageSvcFut) {
        this.busyLock = busyLock;
        this.logicalTopologyService = logicalTopologyService;
        this.failureProcessor = failureProcessor;
        this.metaStorageSvcFut = metaStorageSvcFut;
    }

    CompletableFuture<Void> updateLearners(long term) {
        return this.metaStorageSvcFut.thenCompose(service -> this.resetLearners(service.raftGroupService(), term));
    }

    CompletableFuture<Void> addLearner(RaftGroupService raftService, InternalClusterNode learner) {
        if (!this.learnersAdditionEnabled) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.updateConfigUnderLock(() -> MetaStorageLearnerManager.isPeer(raftService, learner) ? CompletableFutures.nullCompletedFuture() : raftService.addLearners(List.of(new Peer(learner.name()))));
    }

    private static boolean isPeer(RaftGroupService raftService, InternalClusterNode node) {
        return raftService.peers().stream().anyMatch(peer -> peer.consistentId().equals(node.name()));
    }

    CompletableFuture<Void> removeLearner(RaftGroupService raftService, InternalClusterNode learner) {
        return this.updateConfigUnderLock(() -> this.logicalTopologyService.validatedNodesOnLeader().thenCompose(validatedNodes -> this.updateConfigUnderLock(() -> {
            if (MetaStorageLearnerManager.isPeer(raftService, learner)) {
                return CompletableFutures.nullCompletedFuture();
            }
            if (validatedNodes.stream().anyMatch(n -> n.name().equals(learner.name()))) {
                return CompletableFutures.nullCompletedFuture();
            }
            return raftService.removeLearners(List.of(new Peer(learner.name())));
        })));
    }

    CompletableFuture<Void> resetLearners(RaftGroupService raftService, long term) {
        return this.updateConfigUnderLock(() -> this.logicalTopologyService.validatedNodesOnLeader().thenCompose(validatedNodes -> this.updateConfigUnderLock(() -> {
            Set<String> peers = raftService.peers().stream().map(Peer::consistentId).collect(Collectors.toSet());
            Set<String> learners = validatedNodes.stream().map(InternalClusterNode::name).filter(name -> !peers.contains(name)).collect(Collectors.toSet());
            PeersAndLearners newPeerConfiguration = PeersAndLearners.fromConsistentIds(peers, learners);
            return raftService.changePeersAndLearnersAsync(newPeerConfiguration, term);
        })));
    }

    private CompletableFuture<Void> updateConfigUnderLock(Supplier<CompletableFuture<Void>> action) {
        if (!this.busyLock.enterBusy()) {
            LOG.info("Skipping Meta Storage configuration update because the node is stopping", new Object[0]);
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            CompletionStage completionStage = action.get().whenComplete((v, e) -> {
                if (e != null && !ExceptionUtils.hasCause(e, NodeStoppingException.class)) {
                    this.failureProcessor.process(new FailureContext((Throwable)e, "Unable to change peers on topology update"));
                }
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @TestOnly
    void disableLearnersAddition() {
        this.learnersAdditionEnabled = false;
    }
}

