/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.ignite3.raft.jraft.util.CRC64;

public class MetastorageChecksum {
    private long lastChecksum;
    private final Checksum checksum = new CRC64();

    public MetastorageChecksum(long lastChecksum) {
        this.lastChecksum = lastChecksum;
    }

    public long wholePut(byte[] key, byte[] value) {
        return this.checksumWholeOperation(Op.PUT, () -> this.updateForPut(key, value));
    }

    private void updateForPut(byte[] key, byte[] value) {
        this.updateWithBytes(key);
        this.updateWithBytes(value);
    }

    private long checksumWholeOperation(Op operation, Updater updater) {
        this.prepareRound(operation);
        updater.update();
        return this.roundValue();
    }

    private void prepareRound(Op operation) {
        this.checksum.reset();
        this.updateWithLong(this.lastChecksum);
        this.checksum.update(operation.code);
    }

    private void updateWithBytes(byte[] bytes) {
        this.updateWithInt(bytes.length);
        this.checksum.update(bytes);
    }

    private void updateWithInt(int value) {
        for (int i = 0; i < 4; ++i) {
            this.checksum.update((byte)(value >> 24));
            value <<= 8;
        }
    }

    private void updateWithLong(long value) {
        for (int i = 0; i < 8; ++i) {
            this.checksum.update((byte)(value >> 56));
            value <<= 8;
        }
    }

    public long wholePutAll(List<byte[]> keys, List<byte[]> values) {
        return this.checksumWholeOperation(Op.PUT_ALL, () -> this.updateForPutAll(keys, values));
    }

    private void updateForPutAll(List<byte[]> keys, List<byte[]> values) {
        this.updateWithInt(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            this.updateForPut(keys.get(i), values.get(i));
        }
    }

    public long wholeRemove(byte[] key) {
        return this.checksumWholeOperation(Op.REMOVE, () -> this.updateForRemove(key));
    }

    private void updateForRemove(byte[] key) {
        this.updateWithBytes(key);
    }

    public long wholeRemoveAll(List<byte[]> keys) {
        ArrayList<byte[]> sortedKeys = new ArrayList<byte[]>(keys);
        sortedKeys.sort(Arrays::compare);
        return this.checksumWholeOperation(Op.REMOVE_ALL, () -> this.updateForRemoveAll(sortedKeys));
    }

    private void updateForRemoveAll(List<byte[]> keys) {
        this.updateWithInt(keys.size());
        for (byte[] key : keys) {
            this.updateForRemove(key);
        }
    }

    public long wholeRemoveByPrefix(byte[] prefix) {
        return this.checksumWholeOperation(Op.REMOVE_BY_PREFIX, () -> this.updateWithBytes(prefix));
    }

    public void prepareForInvoke(boolean multiInvoke, int opCount, byte[] updateResult) {
        this.prepareRound(multiInvoke ? Op.MULTI_INVOKE : Op.SINGLE_INVOKE);
        this.updateWithBytes(updateResult);
        this.updateWithInt(opCount);
    }

    public void appendPutAsPart(byte[] key, byte[] value) {
        this.appendPartOfCompound(Op.PUT, () -> this.updateForPut(key, value));
    }

    public void appendRemoveAsPart(byte[] key) {
        this.appendPartOfCompound(Op.REMOVE, () -> this.updateForRemove(key));
    }

    private void appendPartOfCompound(Op operation, Updater updater) {
        this.checksum.update(operation.code);
        updater.update();
    }

    public void commitRound(long newChecksum) {
        this.lastChecksum = newChecksum;
    }

    public long roundValue() {
        return this.checksum.getValue();
    }

    private static enum Op {
        PUT(1),
        PUT_ALL(2),
        REMOVE(3),
        REMOVE_ALL(4),
        SINGLE_INVOKE(5),
        MULTI_INVOKE(6),
        REMOVE_BY_PREFIX(7);

        private final int code;

        private Op(int code) {
            this.code = code;
        }
    }

    @FunctionalInterface
    private static interface Updater {
        public void update();
    }
}

