/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.message.ClusterNodeMessage;
import org.apache.ignite3.internal.network.message.ClusterNodeMessageBuilder;
import org.apache.ignite3.internal.network.message.ClusterNodeMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ClusterNodeMessageImpl
implements ClusterNodeMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 11;
    @IgniteToStringInclude
    private final String host;
    @IgniteToStringInclude
    private final UUID id;
    @IgniteToStringInclude
    private final String name;
    @IgniteToStringInclude
    private final int port;

    private ClusterNodeMessageImpl(String host, UUID id, String name, int port) {
        this.host = host;
        this.id = id;
        this.name = name;
        this.port = port;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int port() {
        return this.port;
    }

    public MessageSerializer serializer() {
        return ClusterNodeMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(ClusterNodeMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 11;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterNodeMessageImpl otherMessage = (ClusterNodeMessageImpl)other;
        return Objects.equals(this.host, otherMessage.host) && Objects.equals(this.id, otherMessage.id) && Objects.equals(this.name, otherMessage.name) && this.port == otherMessage.port;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.port, this.host, this.id, this.name);
        return result;
    }

    @Override
    public ClusterNodeMessageImpl clone() {
        try {
            return (ClusterNodeMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClusterNodeMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ClusterNodeMessageBuilder {
        private String host;
        private UUID id;
        private String name;
        private int port;

        private Builder() {
        }

        @Override
        public ClusterNodeMessageBuilder host(String host) {
            Objects.requireNonNull(host, "host is not marked @Nullable");
            this.host = host;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder id(UUID id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder name(String name) {
            Objects.requireNonNull(name, "name is not marked @Nullable");
            this.name = name;
            return this;
        }

        @Override
        public ClusterNodeMessageBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public ClusterNodeMessage build() {
            return new ClusterNodeMessageImpl(Objects.requireNonNull(this.host, "host is not marked @Nullable"), Objects.requireNonNull(this.id, "id is not marked @Nullable"), Objects.requireNonNull(this.name, "name is not marked @Nullable"), this.port);
        }
    }
}

