/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite3.internal.network.serialization.marshal.DefaultSchemaMismatchHandler;
import org.apache.ignite3.internal.network.serialization.marshal.SchemaMismatchException;
import org.apache.ignite3.internal.network.serialization.marshal.SchemaMismatchHandler;

class SchemaMismatchHandlers {
    private final Map<String, SchemaMismatchHandler<?>> handlers = new HashMap();
    private final SchemaMismatchHandler<Object> defaultHandler = new DefaultSchemaMismatchHandler();

    SchemaMismatchHandlers() {
    }

    <T> void registerHandler(Class<T> layerClass, SchemaMismatchHandler<T> handler) {
        this.registerHandler(layerClass.getName(), handler);
    }

    <T> void registerHandler(String layerClassName, SchemaMismatchHandler<T> handler) {
        this.handlers.put(layerClassName, handler);
    }

    private SchemaMismatchHandler<Object> handlerFor(Class<?> clazz) {
        return this.handlerFor(clazz.getName());
    }

    private SchemaMismatchHandler<Object> handlerFor(String className) {
        SchemaMismatchHandler<Object> handler = this.handlers.get(className);
        if (handler == null) {
            handler = this.defaultHandler;
        }
        return handler;
    }

    void onFieldIgnored(String layerClassName, Object instance, String fieldName, Object fieldValue) throws SchemaMismatchException {
        this.handlerFor(layerClassName).onFieldIgnored(instance, fieldName, fieldValue);
    }

    void onFieldMissed(String layerClassName, Object instance, String fieldName) throws SchemaMismatchException {
        this.handlerFor(layerClassName).onFieldMissed(instance, fieldName);
    }

    void onFieldTypeChanged(String layerClassName, Object instance, String fieldName, Class<?> remoteType, Object fieldValue) throws SchemaMismatchException {
        this.handlerFor(layerClassName).onFieldTypeChanged(instance, fieldName, remoteType, fieldValue);
    }

    void onExternalizableIgnored(Object instance, ObjectInput externalData) throws SchemaMismatchException {
        this.handlerFor(instance.getClass()).onExternalizableIgnored(instance, externalData);
    }

    void onExternalizableMissed(Object instance) throws SchemaMismatchException {
        this.handlerFor(instance.getClass()).onExternalizableMissed(instance);
    }

    boolean onReadResolveAppeared(Object instance) throws SchemaMismatchException {
        return this.handlerFor(instance.getClass()).onReadResolveAppeared(instance);
    }

    void onReadResolveDisappeared(Object instance) throws SchemaMismatchException {
        this.handlerFor(instance.getClass()).onReadResolveDisappeared(instance);
    }

    void onReadObjectIgnored(String layerClassName, Object instance, ObjectInputStream objectData) throws SchemaMismatchException {
        this.handlerFor(layerClassName).onReadObjectIgnored(instance, objectData);
    }

    void onReadObjectMissed(String layerClassName, Object instance) throws SchemaMismatchException {
        this.handlerFor(layerClassName).onReadObjectMissed(instance);
    }
}

