/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.store;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.RunnableX;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.thread.IgniteThread;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.worker.IgniteWorker;

public class LongOperationAsyncExecutor {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String igniteInstanceName;
    private final IgniteLogger log;
    private final Set<IgniteWorker> workers = ConcurrentHashMap.newKeySet();
    private static final AtomicLong WORKER_COUNTER = new AtomicLong(0L);

    public LongOperationAsyncExecutor(String igniteInstanceName, IgniteLogger log) {
        this.igniteInstanceName = igniteInstanceName;
        this.log = log;
    }

    public CompletableFuture<Void> async(final RunnableX operation, String name) {
        String workerName = "async-" + name + "-task-" + WORKER_COUNTER.getAndIncrement();
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        IgniteWorker worker = new IgniteWorker(this.log, this.igniteInstanceName, workerName){

            @Override
            protected void body() {
                LongOperationAsyncExecutor.this.readWriteLock.writeLock().lock();
                try {
                    operation.run();
                    future.complete(null);
                }
                catch (Throwable throwable) {
                    future.completeExceptionally(throwable);
                }
                finally {
                    LongOperationAsyncExecutor.this.readWriteLock.writeLock().unlock();
                    LongOperationAsyncExecutor.this.workers.remove(this);
                }
            }
        };
        this.workers.add(worker);
        new IgniteThread(worker).start();
        return future;
    }

    public CompletableFuture<Void> async(Runnable operation, String name) {
        return this.async(operation::run, name);
    }

    public <T> T afterAsyncCompletion(Supplier<T> supplier) {
        this.readWriteLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void awaitAsyncTaskCompletion(boolean cancel) {
        IgniteUtils.awaitForWorkersStop(this.workers, cancel, this.log);
    }
}

