/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.throttling;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.DoubleGauge;
import org.apache.ignite3.internal.metrics.IntGauge;
import org.apache.ignite3.internal.metrics.LongAdderMetric;
import org.apache.ignite3.internal.metrics.LongGauge;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemoryMetricSource;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite3.internal.pagememory.persistence.throttling.CheckpointBufferOverflowWatchdog;
import org.apache.ignite3.internal.pagememory.persistence.throttling.CheckpointLockStateChecker;
import org.apache.ignite3.internal.pagememory.persistence.throttling.ExponentialBackoffThrottlingStrategy;
import org.apache.ignite3.internal.pagememory.persistence.throttling.IntervalBasedMeasurement;
import org.apache.ignite3.internal.pagememory.persistence.throttling.PagesWriteThrottlePolicy;
import org.apache.ignite3.internal.pagememory.persistence.throttling.SpeedBasedMemoryConsumptionThrottlingStrategy;
import org.jetbrains.annotations.TestOnly;

public class PagesWriteSpeedBasedThrottle
implements PagesWriteThrottlePolicy {
    public static final double DEFAULT_MAX_DIRTY_PAGES = 0.9;
    public static final double DEFAULT_MIN_RATIO_NO_THROTTLE = 0.5;
    private static final IgniteLogger LOG = Loggers.forClass(PagesWriteSpeedBasedThrottle.class);
    private static final int PARKING_UNIT = 10000;
    static final long NO_THROTTLING_MARKER = Long.MIN_VALUE;
    private final long logThresholdNanos;
    private final PersistentPageMemory pageMemory;
    private final Supplier<CheckpointProgress> cpProgress;
    private final Set<Thread> parkedThreads = ConcurrentHashMap.newKeySet();
    private final IntervalBasedMeasurement markSpeedAndAvgParkTime = new IntervalBasedMeasurement(250, 3);
    private final CheckpointLockStateChecker cpLockStateChecker;
    private final AtomicLong prevWarnTime = new AtomicLong();
    private static final long WARN_MIN_DELAY_NS = TimeUnit.SECONDS.toNanos(10L);
    private static final double WARN_THRESHOLD = 0.2;
    private final ExponentialBackoffThrottlingStrategy cpBufferProtector = new ExponentialBackoffThrottlingStrategy();
    private final SpeedBasedMemoryConsumptionThrottlingStrategy cleanPagesProtector;
    private final CheckpointBufferOverflowWatchdog cpBufferWatchdog;
    private final LongAdderMetric totalThrottlingTime = new LongAdderMetric("TotalThrottlingTime", "Total throttling threads time in milliseconds. The Ignite throttles threads that generate dirty pages during the ongoing checkpoint.");

    public PagesWriteSpeedBasedThrottle(long logThresholdNanos, double minDirtyPages, double maxDirtyPages, PersistentPageMemory pageMemory, Supplier<CheckpointProgress> cpProgress, CheckpointLockStateChecker stateChecker, PersistentPageMemoryMetricSource metricSource) {
        this.logThresholdNanos = logThresholdNanos;
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.cpLockStateChecker = stateChecker;
        this.cleanPagesProtector = new SpeedBasedMemoryConsumptionThrottlingStrategy(minDirtyPages, maxDirtyPages, pageMemory, cpProgress, this.markSpeedAndAvgParkTime);
        this.cpBufferWatchdog = new CheckpointBufferOverflowWatchdog(pageMemory);
        this.initMetrics(metricSource);
    }

    @TestOnly
    public PagesWriteSpeedBasedThrottle(PersistentPageMemory pageMemory, Supplier<CheckpointProgress> cpProgress, CheckpointLockStateChecker stateChecker, PersistentPageMemoryMetricSource metricSource) {
        this(DEFAULT_LOGGING_THRESHOLD, 0.5, 0.9, pageMemory, cpProgress, stateChecker, metricSource);
    }

    private void initMetrics(PersistentPageMemoryMetricSource metricSource) {
        metricSource.addMetric(this.totalThrottlingTime);
        metricSource.addMetric(new DoubleGauge("SpeedBasedThrottlingPercentage", "Measurement shows how much throttling time is involved into average marking time.", this::throttleWeight));
        metricSource.addMetric(new LongGauge("MarkDirtySpeed", "Speed of marking pages dirty. Value from past 750-1000 millis only. Pages/second.", this::getMarkDirtySpeed));
        metricSource.addMetric(new LongGauge("CpWriteSpeed", "Speed average checkpoint write speed. Current and 3 past checkpoints used. Pages/second.", this::getCpWriteSpeed));
        metricSource.addMetric(new LongGauge("LastEstimatedSpeedForMarkAll", "Last estimated speed for marking all clear pages as dirty till the end of checkpoint.", this::getLastEstimatedSpeedForMarkAll));
        metricSource.addMetric(new DoubleGauge("CurrDirtyRatio", "Current dirty pages ratio.", this::getCurrDirtyRatio));
        metricSource.addMetric(new DoubleGauge("TargetDirtyRatio", "Target (maximum) dirty pages ratio, after which throttling will start.", this::getTargetDirtyRatio));
        metricSource.addMetric(new LongGauge("ThrottleParkTime", "Exponential backoff counter.", this::throttleParkTime));
        metricSource.addMetric(new IntGauge("CpTotalPages", "Number of pages in current checkpoint.", this.cleanPagesProtector::cpTotalPages));
        metricSource.addMetric(new IntGauge("CpEvictedPages", "Number of evicted pages.", this.cleanPagesProtector::cpEvictedPages));
        metricSource.addMetric(new IntGauge("CpWrittenPages", "Number of written pages.", this::cpWrittenPages));
        metricSource.addMetric(new IntGauge("CpSyncedPages", "Counter for fsynced checkpoint pages.", this.cleanPagesProtector::cpSyncedPages));
        metricSource.addMetric(new DoubleGauge("WriteVsFsyncCoefficient", "Ratio of the write pages duration to the total 'write+fsync' duration", this.cleanPagesProtector::getWriteVsFsyncCoefficient));
    }

    @Override
    public void onMarkDirty(boolean isPageInCheckpoint) {
        assert (this.cpLockStateChecker.checkpointLockIsHeldByThread());
        long startTimeNs = System.nanoTime();
        long throttleParkTimeNs = this.parkAndReturnParkingNanos(isPageInCheckpoint);
        if (throttleParkTimeNs == Long.MIN_VALUE) {
            return;
        }
        if (throttleParkTimeNs > this.logThresholdNanos) {
            LOG.warn("Parking thread={} for timeout(ms)={}", Thread.currentThread().getName(), throttleParkTimeNs / 1000000L);
        }
        this.totalThrottlingTime.add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs));
        this.markSpeedAndAvgParkTime.addMeasurementForAverageCalculation(throttleParkTimeNs);
    }

    private long parkAndReturnParkingNanos(boolean isPageInCheckpoint) {
        if (isPageInCheckpoint && this.isCpBufferOverflowThresholdExceeded()) {
            long parkTimeNanos = this.cpBufferProtector.protectionParkTime();
            this.doPark(parkTimeNanos);
            return parkTimeNanos;
        }
        if (isPageInCheckpoint) {
            this.cpBufferProtector.resetBackoff();
        }
        return this.parkAndReturnParkingNanosWithoutCpBufferProtection();
    }

    private long parkAndReturnParkingNanosWithoutCpBufferProtection() {
        long realParkNanos;
        long calculatedParkNanos;
        long alreadyParkedNanos = 0L;
        long minimalCalculatedParkNanos = Long.MAX_VALUE;
        do {
            if ((calculatedParkNanos = this.cleanPagesProtector.protectionParkTime(System.nanoTime())) == Long.MIN_VALUE) {
                return alreadyParkedNanos == 0L ? Long.MIN_VALUE : alreadyParkedNanos;
            }
            if (alreadyParkedNanos >= (minimalCalculatedParkNanos = Math.min(minimalCalculatedParkNanos, calculatedParkNanos))) {
                return alreadyParkedNanos;
            }
            realParkNanos = Math.min(calculatedParkNanos, 10000L);
            this.doPark(realParkNanos);
            alreadyParkedNanos += realParkNanos;
        } while (calculatedParkNanos != realParkNanos);
        return alreadyParkedNanos;
    }

    protected void doPark(long throttleParkTimeNs) {
        this.recurrentLogIfNeeded();
        this.parkedThreads.add(Thread.currentThread());
        try {
            LockSupport.parkNanos(throttleParkTimeNs);
        }
        finally {
            this.parkedThreads.remove(Thread.currentThread());
        }
    }

    private int cpWrittenPages() {
        CheckpointProgress cpProgress = this.cpProgress.get();
        if (cpProgress == null) {
            return 0;
        }
        return cpProgress.writtenPages();
    }

    private void recurrentLogIfNeeded() {
        long prevWarningNs = this.prevWarnTime.get();
        long curNs = System.nanoTime();
        if (prevWarningNs != 0L && curNs - prevWarningNs <= WARN_MIN_DELAY_NS) {
            return;
        }
        double weight = this.throttleWeight();
        if (weight <= 0.2) {
            return;
        }
        if (this.prevWarnTime.compareAndSet(prevWarningNs, curNs) && LOG.isInfoEnabled()) {
            String msg = String.format("Throttling is applied to page modifications [fractionOfParkTime=%.2f, markDirty=%d pages/sec, checkpointWrite=%d pages/sec, estIdealMarkDirty=%d pages/sec, curDirty=%.2f, maxDirty=%.2f, avgParkTime=%d ns, pages: (total=%d, evicted=%d, written=%d, synced=%d, cpBufUsed=%d, cpBufTotal=%d, writeVsFsyncCoefficient=%.2f)]", weight, this.getMarkDirtySpeed(), this.getCpWriteSpeed(), this.getLastEstimatedSpeedForMarkAll(), this.getCurrDirtyRatio(), this.getTargetDirtyRatio(), this.throttleParkTime(), this.cleanPagesProtector.cpTotalPages(), this.cleanPagesProtector.cpEvictedPages(), this.cpWrittenPages(), this.cleanPagesProtector.cpSyncedPages(), this.pageMemory.usedCheckpointBufferPages(), this.pageMemory.maxCheckpointBufferPages(), this.cleanPagesProtector.getWriteVsFsyncCoefficient());
            LOG.info(msg, new Object[0]);
        }
    }

    @TestOnly
    long getCleanPagesProtectionParkTime(double dirtyPagesRatio, long fullyCompletedPages, int cpTotalPages, int threads, long markDirtySpeed, long curCpWriteSpeed) {
        return this.cleanPagesProtector.getParkTime(dirtyPagesRatio, fullyCompletedPages, cpTotalPages, threads, markDirtySpeed, curCpWriteSpeed);
    }

    @Override
    public void onBeginCheckpoint() {
        this.cleanPagesProtector.reset();
    }

    @Override
    public void onFinishCheckpoint() {
        this.cpBufferProtector.resetBackoff();
        this.cleanPagesProtector.finish();
        this.markSpeedAndAvgParkTime.finishInterval();
        this.unparkParkedThreads();
    }

    private void unparkParkedThreads() {
        this.parkedThreads.forEach(LockSupport::unpark);
    }

    public long throttleParkTime() {
        return this.markSpeedAndAvgParkTime.getAverage();
    }

    public double getTargetDirtyRatio() {
        return this.cleanPagesProtector.getTargetDirtyRatio();
    }

    public double getCurrDirtyRatio() {
        return this.cleanPagesProtector.getCurrDirtyRatio();
    }

    public long getMarkDirtySpeed() {
        return this.markSpeedAndAvgParkTime.getSpeedOpsPerSec(System.nanoTime());
    }

    public long getCpWriteSpeed() {
        return this.cleanPagesProtector.getCpWriteSpeed();
    }

    public long getLastEstimatedSpeedForMarkAll() {
        return this.cleanPagesProtector.getLastEstimatedSpeedForMarkAll();
    }

    public double throttleWeight() {
        long speed = this.markSpeedAndAvgParkTime.getSpeedOpsPerSec(System.nanoTime());
        if (speed <= 0L) {
            return 0.0;
        }
        long timeForOnePage = this.cleanPagesProtector.nsPerOperation(speed);
        if (timeForOnePage == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.throttleParkTime() / (double)timeForOnePage;
    }

    @Override
    public void wakeupThrottledThreads() {
        if (!this.isCpBufferOverflowThresholdExceeded()) {
            this.cpBufferProtector.resetBackoff();
            this.unparkParkedThreads();
        }
    }

    @Override
    public boolean isCpBufferOverflowThresholdExceeded() {
        return this.cpBufferWatchdog.isInDangerZone();
    }
}

