/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.message;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.message.HasDataRequest;
import org.apache.ignite3.internal.partition.replicator.network.message.HasDataRequestBuilder;

class HasDataRequestDeserializer
implements MessageDeserializer<HasDataRequest> {
    private final HasDataRequestBuilder msg;

    HasDataRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.hasDataRequest();
    }

    @Override
    public Class<HasDataRequest> klass() {
        return HasDataRequest.class;
    }

    @Override
    public HasDataRequest getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionId(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HasDataRequest.class);
    }
}

