/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequestImpl;

class ReadOnlyMultiRowPkReplicaRequestSerializer
implements MessageSerializer<ReadOnlyMultiRowPkReplicaRequest> {
    public static final ReadOnlyMultiRowPkReplicaRequestSerializer INSTANCE = new ReadOnlyMultiRowPkReplicaRequestSerializer();

    private ReadOnlyMultiRowPkReplicaRequestSerializer() {
    }

    @Override
    public boolean writeMessage(ReadOnlyMultiRowPkReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadOnlyMultiRowPkReplicaRequestImpl message = (ReadOnlyMultiRowPkReplicaRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)9)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("coordinatorId", message.coordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("primaryKeys", message.primaryKeys(), MessageCollectionItemType.BYTE_BUFFER);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("readTimestamp", message.readTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                int idShifted = message.requestType() == null ? 0 : message.requestType().id() + 1;
                boolean written = writer.writeInt("requestType", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeUuid("transactionId", message.transactionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

