/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.message;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessage;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessageBuilder;
import org.apache.ignite3.internal.placementdriver.message.PlacementDriverMessagesFactory;

class LeaseGrantedMessageDeserializer
implements MessageDeserializer<LeaseGrantedMessage> {
    private final LeaseGrantedMessageBuilder msg;

    LeaseGrantedMessageDeserializer(PlacementDriverMessagesFactory messageFactory) {
        this.msg = messageFactory.leaseGrantedMessage();
    }

    @Override
    public Class<LeaseGrantedMessage> klass() {
        return LeaseGrantedMessage.class;
    }

    @Override
    public LeaseGrantedMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("force");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.force(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readByteArray("groupIdByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupIdByteArray((byte[])tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("leaseExpirationTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseExpirationTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseStartTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LeaseGrantedMessage.class);
    }
}

