/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.apache.ignite3.internal.raft.storage.segstore.IndexFileMeta;
import org.apache.ignite3.internal.raft.storage.segstore.IndexFileMetaArray;
import org.jetbrains.annotations.Nullable;

class GroupIndexMeta {
    private static final VarHandle FILE_METAS_VH;
    private volatile IndexFileMetaArray fileMetas;

    GroupIndexMeta(IndexFileMeta startFileMeta) {
        this.fileMetas = new IndexFileMetaArray(startFileMeta);
    }

    void addIndexMeta(IndexFileMeta indexFileMeta) {
        IndexFileMetaArray fileMetas = this.fileMetas;
        IndexFileMetaArray newFileMetas = fileMetas.add(indexFileMeta);
        boolean updated = FILE_METAS_VH.compareAndSet(this, fileMetas, newFileMetas);
        assert (updated) : "Concurrent writes detected";
    }

    @Nullable
    IndexFileMeta indexMeta(long logIndex) {
        IndexFileMetaArray fileMetas = this.fileMetas;
        return fileMetas.find(logIndex);
    }

    static {
        try {
            FILE_METAS_VH = MethodHandles.lookup().findVarHandle(GroupIndexMeta.class, "fileMetas", IndexFileMetaArray.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

