/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.configuration.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.configuration.exception.ConfigurationApplyException;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Singleton
@Requires(classes={ConfigurationApplyException.class, ExceptionHandler.class})
public class ConfigurationApplyExceptionHandler
implements ExceptionHandler<ConfigurationApplyException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, ConfigurationApplyException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).title("Failed to apply configuration").traceId(exception.traceId()).detail(exception.getMessage()).build());
    }
}

