/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.ignite3.internal.marshaller.BinaryMode;
import org.apache.ignite3.internal.marshaller.MarshallerColumn;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.InvalidTypeException;
import org.apache.ignite3.internal.type.DecimalNativeType;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.util.ObjectFactory;

public final class MarshallerUtil {
    public static int getValueSize(Object val, NativeType type) throws InvalidTypeException {
        switch (type.spec()) {
            case BYTE_ARRAY: {
                if (val instanceof byte[]) {
                    byte[] bytes = (byte[])val;
                    if (bytes.length == 0 || bytes[0] == -128) {
                        return bytes.length + 1;
                    }
                    return bytes.length;
                }
                return 0;
            }
            case STRING: {
                CharSequence chars = (CharSequence)val;
                int length = chars.length();
                return length == 0 ? 1 : length;
            }
            case DECIMAL: {
                return MarshallerUtil.sizeInBytes((BigDecimal)val);
            }
        }
        throw new InvalidTypeException("Unsupported variable-length type: " + type);
    }

    public static <T> ObjectFactory<T> factoryForClass(Class<T> targetCls) {
        if (BinaryMode.forClass(targetCls) == BinaryMode.POJO) {
            return new ObjectFactory<T>(targetCls);
        }
        return null;
    }

    private MarshallerUtil() {
    }

    public static int sizeInBytes(BigInteger val) {
        return val.bitLength() / 8 + 1;
    }

    public static int sizeInBytes(BigDecimal val) {
        return MarshallerUtil.sizeInBytes(val.unscaledValue()) + 2;
    }

    public static MarshallerColumn toMarshallerColumn(Column column) {
        NativeType columnType = column.type();
        return new MarshallerColumn(column.positionInRow(), column.name(), MarshallerUtil.mode(columnType), column.defaultValueProvider()::get, columnType instanceof DecimalNativeType ? ((DecimalNativeType)columnType).scale() : 0);
    }

    public static MarshallerColumn[] toMarshallerColumns(List<Column> columns) {
        MarshallerColumn[] result = new MarshallerColumn[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            result[i] = MarshallerUtil.toMarshallerColumn(columns.get(i));
        }
        return result;
    }

    private static BinaryMode mode(NativeType type) {
        switch (type.spec()) {
            case INT8: {
                return BinaryMode.BYTE;
            }
            case INT16: {
                return BinaryMode.SHORT;
            }
            case INT32: {
                return BinaryMode.INT;
            }
            case INT64: {
                return BinaryMode.LONG;
            }
            case FLOAT: {
                return BinaryMode.FLOAT;
            }
            case DOUBLE: {
                return BinaryMode.DOUBLE;
            }
            case DECIMAL: {
                return BinaryMode.DECIMAL;
            }
            case UUID: {
                return BinaryMode.UUID;
            }
            case STRING: {
                return BinaryMode.STRING;
            }
            case BYTE_ARRAY: {
                return BinaryMode.BYTE_ARR;
            }
            case DATE: {
                return BinaryMode.DATE;
            }
            case TIME: {
                return BinaryMode.TIME;
            }
            case DATETIME: {
                return BinaryMode.DATETIME;
            }
            case TIMESTAMP: {
                return BinaryMode.TIMESTAMP;
            }
            case BOOLEAN: {
                return BinaryMode.BOOLEAN;
            }
        }
        throw new IllegalArgumentException("No matching mode for type " + type);
    }
}

