/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.kill;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite3.internal.sql.engine.api.kill.OperationKillHandler;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationRequest;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationResponse;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;

class LocalToClusterKillHandlerWrapper
implements OperationKillHandler {
    private static final SqlQueryMessagesFactory FACTORY = new SqlQueryMessagesFactory();
    private static final IgniteLogger LOG = Loggers.forClass(LocalToClusterKillHandlerWrapper.class);
    private static final long RESPONSE_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(5L);
    private final OperationKillHandler localHandler;
    private final String localNodeName;
    private final LogicalTopologyService logicalTopologyService;
    private final MessagingService messageService;

    LocalToClusterKillHandlerWrapper(OperationKillHandler localHandler, String localNodeName, LogicalTopologyService logicalTopologyService, MessagingService messageService) {
        assert (localHandler.local()) : "handler must be local";
        this.localHandler = localHandler;
        this.localNodeName = localNodeName;
        this.logicalTopologyService = logicalTopologyService;
        this.messageService = messageService;
    }

    @Override
    public boolean local() {
        return false;
    }

    @Override
    public CancellableOperationType type() {
        return this.localHandler.type();
    }

    @Override
    public CompletableFuture<Boolean> cancelAsync(String operationId) {
        return this.localHandler.cancelAsync(operationId).thenCompose(result -> {
            if (Boolean.TRUE.equals(result)) {
                return CompletableFuture.completedFuture(Boolean.TRUE);
            }
            CancelOperationRequest request = FACTORY.cancelOperationRequest().operationId(operationId).typeId(this.localHandler.type().id()).build();
            return this.broadcastCancel(request);
        });
    }

    private CompletableFuture<Boolean> broadcastCancel(CancelOperationRequest request) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        List futures = this.logicalTopologyService.localLogicalTopology().nodes().stream().filter(node -> !node.name().equals(this.localNodeName)).map(node -> this.messageService.invoke((InternalClusterNode)node, (NetworkMessage)request, RESPONSE_TIMEOUT_MS).whenComplete((msg, invokeErr) -> {
            if (msg != null) {
                CancelOperationResponse response = (CancelOperationResponse)msg;
                Throwable remoteErr = response.error();
                if (remoteErr != null) {
                    String err = IgniteStringFormatter.format("Remote node returned an error while canceling the operation [operationId={}, typeId={}, node={}].", request.operationId(), request.typeId(), node.name());
                    throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, err, remoteErr);
                }
                Boolean res = response.result();
                if (Boolean.TRUE.equals(res)) {
                    result.complete(true);
                }
            }
            if (invokeErr != null) {
                String err = IgniteStringFormatter.format("Failed to send a request to cancel the operation to the remote node [operationId={}, typeId={}, node={}].", request.operationId(), request.typeId(), node.name());
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, err, (Throwable)invokeErr);
            }
        })).collect(Collectors.toList());
        CompletableFutures.allOf(futures).whenComplete((unused, firstErr) -> {
            if (firstErr == null) {
                if (!result.isDone()) {
                    result.complete(Boolean.FALSE);
                }
                return;
            }
            Throwable resultErr = Commons.deriveExceptionFromListOfFutures(futures);
            if (result.isDone()) {
                LOG.warn("Distributed cancel operation succeeded, but the request failed on some nodes [operationId={}, typeId={}]", resultErr, request.operationId(), request.typeId());
                return;
            }
            result.completeExceptionally(resultErr);
        });
        return result;
    }
}

