/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.sql.engine.hint.Hints;
import org.apache.ignite3.internal.sql.engine.hint.IgniteHint;
import org.apache.ignite3.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlToRelConvertor;
import org.apache.ignite3.internal.sql.engine.prepare.OutOfRangeLiteralComparisonReductionShuttle;
import org.apache.ignite3.internal.sql.engine.prepare.PlannerPhase;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public final class PlannerHelper {
    static final RelOptRule JOIN_PUSH_THROUGH_JOIN_RULE = JoinPushThroughJoinRule.Config.RIGHT.withOperandFor(LogicalJoin.class).toRule();
    private static final int MAX_SIZE_OF_JOIN_FOR_EXHAUSTIVE_ENUMERATION = 5;
    private static final IgniteLogger LOG = Loggers.forClass(PlannerHelper.class);

    private PlannerHelper() {
    }

    public static IgniteRel optimize(SqlNode sqlNode, IgnitePlanner planner) {
        try {
            Object simpleOperation;
            IgniteRel result = PlannerHelper.tryOptimizeFast(sqlNode, planner);
            if (result != null) {
                return result;
            }
            RelRoot root = planner.rel(sqlNode);
            Object rel = root.rel;
            Hints hints = Hints.parse(planner.deriveHints(sqlNode));
            List<String> disableRuleParams = hints.params(IgniteHint.DISABLE_RULE);
            if (!disableRuleParams.isEmpty()) {
                planner.disableRules(disableRuleParams);
            }
            rel = planner.transform(PlannerPhase.HEP_SUBQUERIES_TO_CORRELATES, rel.getTraitSet(), (RelNode)rel);
            PlannerHelper.validateIndexesFromHints(rel, hints);
            rel = RelOptUtil.propagateRelHints((RelNode)rel, (boolean)false);
            rel = planner.replaceCorrelatesCollisions((RelNode)rel);
            rel = planner.trimUnusedFields((RelRoot)root.withRel((RelNode)rel)).rel;
            final RelOptCluster cluster = rel.getCluster();
            rel = rel.accept((RelShuttle)new RelHomogeneousShuttle(){

                public RelNode visit(RelNode other) {
                    RelNode next = super.visit(other);
                    return next.accept((RexShuttle)new OutOfRangeLiteralComparisonReductionShuttle(cluster.getRexBuilder()));
                }
            });
            rel = planner.transform(PlannerPhase.HEP_FILTER_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            rel = planner.transform(PlannerPhase.HEP_PROJECT_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            if (Commons.fastQueryOptimizationEnabled() && (simpleOperation = planner.transform(PlannerPhase.HEP_TO_SIMPLE_KEY_VALUE_OPERATION, rel.getTraitSet(), (RelNode)rel)) instanceof IgniteRel) {
                return (IgniteRel)simpleOperation;
            }
            boolean enforceJoinOrder = hints.present(IgniteHint.ENFORCE_JOIN_ORDER);
            boolean fallBackToExhaustiveJoinEnumeration = false;
            if (!enforceJoinOrder) {
                Object optimized = planner.transform(PlannerPhase.HEP_OPTIMIZE_JOIN_ORDER, rel.getTraitSet(), (RelNode)rel);
                if (PlannerHelper.hasMultiJoinNode(optimized)) {
                    fallBackToExhaustiveJoinEnumeration = true;
                } else {
                    rel = optimized;
                }
            }
            if (!fallBackToExhaustiveJoinEnumeration || PlannerHelper.hasTooMuchJoins(rel)) {
                planner.disableRules(PlannerHelper.exhaustiveJoinOrderingRules());
            }
            RelTraitSet desired = rel.getCluster().traitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()).replace((RelTrait)(root.collation == null ? RelCollations.EMPTY : root.collation)).simplify();
            result = (IgniteRel)planner.transform(PlannerPhase.OPTIMIZATION, desired, (RelNode)rel);
            if (!root.isRefTrivial()) {
                LogicalProject project = (LogicalProject)root.project();
                result = new IgniteProject(result.getCluster(), desired, (RelNode)result, project.getProjects(), project.getRowType());
            }
            return result;
        }
        catch (Throwable ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected error at query optimizer", ex);
                LOG.debug(planner.dump(), new Object[0]);
            }
            if (ex.getClass() == RuntimeException.class && ex.getCause() instanceof SqlException) {
                SqlException sqlEx = (SqlException)ex.getCause();
                throw new SqlException(sqlEx.traceId(), sqlEx.code(), sqlEx.getMessage(), ex);
            }
            throw ex;
        }
    }

    private static void validateIndexesFromHints(RelNode rel, Hints hints) {
        List<String> noIdxParams = hints.params(IgniteHint.NO_INDEX);
        List<String> forceIdxParams = hints.params(IgniteHint.FORCE_INDEX);
        if (!noIdxParams.isEmpty() || !forceIdxParams.isEmpty()) {
            final HashSet indexes = new HashSet();
            RelShuttleImpl shuttle = new RelShuttleImpl(){

                public RelNode visit(TableScan rel) {
                    IgniteTable igniteTable = (IgniteTable)rel.getTable().unwrapOrThrow(IgniteTable.class);
                    indexes.addAll(igniteTable.indexes().keySet());
                    return super.visit(rel);
                }
            };
            rel.accept((RelShuttle)shuttle);
            List indexNamesFromHints = Stream.concat(noIdxParams.stream(), forceIdxParams.stream()).filter(name -> !indexes.contains(name)).collect(Collectors.toList());
            if (!indexNamesFromHints.isEmpty()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Hints mentioned indexes " + indexNamesFromHints + " were not found.");
            }
        }
    }

    @Nullable
    private static IgniteRel tryOptimizeFast(SqlNode sqlNode, IgnitePlanner planner) {
        if (!Commons.fastQueryOptimizationEnabled()) {
            return null;
        }
        if (sqlNode instanceof SqlInsert) {
            return PlannerHelper.tryOptimizeInsert((SqlInsert)sqlNode, planner);
        }
        return null;
    }

    @Nullable
    private static IgniteRel tryOptimizeInsert(SqlInsert insertNode, IgnitePlanner planner) {
        RexNode expression;
        SqlNode sourceNode = insertNode.getSource();
        if (!(sourceNode instanceof SqlBasicCall) || sourceNode.getKind() != SqlKind.VALUES) {
            return null;
        }
        List rowConstructors = ((SqlBasicCall)sourceNode).getOperandList();
        if (rowConstructors.size() != 1) {
            return null;
        }
        IgniteSqlToRelConvertor converter = planner.sqlToRelConverter();
        RelOptTable targetTable = converter.getTargetTable((SqlNode)insertNode);
        IgniteTable igniteTable = (IgniteTable)targetTable.unwrap(IgniteTable.class);
        assert (igniteTable != null);
        TableDescriptor descriptor = igniteTable.descriptor();
        SqlBasicCall rowConstructor = (SqlBasicCall)rowConstructors.get(0);
        SqlNodeList targetColumns = insertNode.getTargetColumnList();
        assert (targetColumns != null);
        HashMap<String, RexNode> columnToExpression = new HashMap<String, RexNode>();
        for (int i = 0; i < rowConstructor.getOperandList().size(); ++i) {
            String columnName = ((SqlIdentifier)targetColumns.get(i)).getSimple();
            SqlNode operand = rowConstructor.operand(i);
            if (operand.getKind() == SqlKind.DEFAULT) continue;
            if (SubQueryChecker.hasSubQuery(operand)) {
                return null;
            }
            expression = converter.convertExpression(operand);
            columnToExpression.put(columnName, expression);
        }
        ArrayList<RexNode> expressions = new ArrayList<RexNode>();
        for (ColumnDescriptor column : descriptor) {
            if (column.virtual()) continue;
            expression = (RexNode)columnToExpression.get(column.name());
            if (expression == null) {
                expression = descriptor.newColumnDefaultValue(targetTable, column.logicalIndex(), converter);
            }
            expressions.add(expression);
        }
        return new IgniteKeyValueModify(planner.cluster(), planner.cluster().traitSetOf((RelTrait)IgniteConvention.INSTANCE), targetTable, IgniteKeyValueModify.Operation.INSERT, expressions);
    }

    private static boolean hasTooMuchJoins(RelNode rel) {
        JoinSizeFinder joinSizeFinder = new JoinSizeFinder();
        joinSizeFinder.visit(rel);
        return joinSizeFinder.sizeOfBiggestJoin() > 5;
    }

    private static boolean hasMultiJoinNode(RelNode root) {
        try {
            RelHomogeneousShuttle visitor = new RelHomogeneousShuttle(){

                public RelNode visit(RelNode node) {
                    if (node instanceof MultiJoin) {
                        throw Util.FoundOne.NULL;
                    }
                    return super.visit(node);
                }
            };
            root.accept((RelShuttle)visitor);
            return false;
        }
        catch (Util.FoundOne ignored) {
            return true;
        }
    }

    private static Set<String> exhaustiveJoinOrderingRules() {
        return Set.of(Commons.shortRuleName((RelOptRule)CoreRules.JOIN_COMMUTE), Commons.shortRuleName(JOIN_PUSH_THROUGH_JOIN_RULE));
    }

    @Nullable
    static Pair<IgniteRel, List<String>> tryOptimizeSelectCount(IgnitePlanner planner, SqlNode node) {
        SqlNode from;
        SqlSelect select = PlannerHelper.getSelectCountOptimizationNode(node);
        if (select == null) {
            return null;
        }
        assert (select.getFrom() != null) : "FROM is missing";
        IgniteSqlToRelConvertor converter = planner.sqlToRelConverter();
        RelOptTable targetTable = converter.getTargetTable(from = SqlUtil.stripAs((SqlNode)select.getFrom()));
        IgniteDataSource dataSource = (IgniteDataSource)targetTable.unwrap(IgniteDataSource.class);
        if (!(dataSource instanceof IgniteTable)) {
            return null;
        }
        IgniteTypeFactory typeFactory = planner.getTypeFactory();
        RelDataType countResultType = typeFactory.createSqlType(SqlTypeName.BIGINT);
        ArrayList<RexNode> expressions = new ArrayList<RexNode>();
        ArrayList<String> expressionNames = new ArrayList<String>();
        boolean countAdded = false;
        for (SqlNode selectItem : select.getSelectList()) {
            SqlNode expr = SqlUtil.stripAs((SqlNode)selectItem);
            if (PlannerHelper.isCountStar(expr)) {
                RexBuilder rexBuilder = planner.cluster().getRexBuilder();
                RexInputRef countValRef = rexBuilder.makeInputRef(countResultType, 0);
                expressions.add((RexNode)countValRef);
                countAdded = true;
            } else if (expr instanceof SqlLiteral || expr instanceof SqlDynamicParam) {
                RexNode rexNode = converter.convertExpression(expr);
                expressions.add(rexNode);
            } else {
                return null;
            }
            String alias = planner.validator().deriveAlias(selectItem, expressionNames.size());
            expressionNames.add(alias);
        }
        if (!countAdded) {
            return null;
        }
        IgniteSelectCount rel = new IgniteSelectCount(planner.cluster(), planner.cluster().traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()), targetTable, expressions);
        return new Pair((Object)rel, expressionNames);
    }

    @Nullable
    private static SqlSelect getSelectCountOptimizationNode(SqlNode node) {
        if (node instanceof SqlOrderBy) {
            SqlOrderBy orderBy = (SqlOrderBy)node;
            if (orderBy.fetch != null || orderBy.offset != null) {
                return null;
            }
            for (SqlNode arg : orderBy.orderList) {
                if (SqlUtil.isLiteral((SqlNode)arg)) continue;
                return null;
            }
            assert (orderBy.getOperandList().size() == 4) : "Expected 4 operands, but was " + orderBy.getOperandList().size();
            node = orderBy.query;
        }
        if (!(node instanceof SqlSelect)) {
            return null;
        }
        SqlSelect select = (SqlSelect)node;
        if (select.getGroup() != null || select.getFrom() == null || select.getWhere() != null || select.getHaving() != null || select.getQualify() != null || !select.getWindowList().isEmpty() || select.getOffset() != null || select.getFetch() != null) {
            return null;
        }
        assert (select.getOperandList().size() == 12) : "Expected 12 operands, but was " + select.getOperandList().size();
        SqlNode from = SqlUtil.stripAs((SqlNode)select.getFrom());
        if (from.getKind() == SqlKind.IDENTIFIER) {
            return select;
        }
        return null;
    }

    private static boolean isCountStar(SqlNode node) {
        if (!SqlUtil.isCallTo((SqlNode)node, (SqlOperator)SqlStdOperatorTable.COUNT)) {
            return false;
        }
        SqlCall call = (SqlCall)node;
        if (call.getFunctionQuantifier() != null) {
            return false;
        }
        if (call.getOperandList().isEmpty()) {
            return false;
        }
        SqlNode operand = (SqlNode)call.getOperandList().get(0);
        if (SqlUtil.isNull((SqlNode)operand)) {
            return false;
        }
        if (SqlUtil.isLiteral((SqlNode)operand)) {
            return true;
        }
        return operand instanceof SqlIdentifier && ((SqlIdentifier)operand).isStar();
    }

    private static class SubQueryChecker
    extends SqlShuttle {
        private static final SubQueryChecker INSTANCE = new SubQueryChecker();

        private SubQueryChecker() {
        }

        static boolean hasSubQuery(SqlNode node) {
            try {
                node.accept((SqlVisitor)INSTANCE);
            }
            catch (ControlFlowException e) {
                return true;
            }
            return false;
        }

        @Nullable
        public SqlNode visit(SqlCall call) {
            if (call.getKind() == SqlKind.SCALAR_QUERY) {
                throw new ControlFlowException();
            }
            return super.visit(call);
        }
    }

    private static class JoinSizeFinder
    extends RelHomogeneousShuttle {
        private int countOfSources = 0;
        private int maxCountOfSourcesInSubQuery = 0;

        private JoinSizeFinder() {
        }

        public RelNode visit(RelNode other) {
            if (other.getInputs().isEmpty()) {
                ++this.countOfSources;
                return other;
            }
            return super.visit(other);
        }

        public RelNode visit(LogicalCorrelate correlate) {
            JoinSizeFinder inSubquerySizeFinder = new JoinSizeFinder();
            inSubquerySizeFinder.visit(correlate.getInput(1));
            this.maxCountOfSourcesInSubQuery = Math.max(this.maxCountOfSourcesInSubQuery, inSubquerySizeFinder.sizeOfBiggestJoin());
            return this.visitChild((RelNode)correlate, 0, correlate.getInput(0));
        }

        int sizeOfBiggestJoin() {
            return Math.max(this.countOfSources, this.maxCountOfSourcesInSubQuery);
        }
    }
}

