/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite3.internal.sql.engine.rel.agg.MapReduceAggregates;
import org.apache.ignite3.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.HintUtils;
import org.apache.ignite3.internal.sql.engine.util.PlanUtils;

public class HashAggregateConverterRule {
    public static final RelOptRule COLOCATED = new ColocatedHashAggregateConverterRule();
    public static final RelOptRule MAP_REDUCE = new MapReduceHashAggregateConverterRule();

    private HashAggregateConverterRule() {
    }

    private static class ColocatedHashAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        ColocatedHashAggregateConverterRule() {
            super(LogicalAggregate.class, "ColocatedHashAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelNode input = ColocatedHashAggregateConverterRule.convert((RelNode)agg.getInput(), (RelTraitSet)inTrait);
            return new IgniteColocatedHashAggregate(cluster, outTrait, input, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }
    }

    private static class MapReduceHashAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        MapReduceHashAggregateConverterRule() {
            super(LogicalAggregate.class, "MapReduceHashAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, final LogicalAggregate agg) {
            if (PlanUtils.complexDistinctAgg(agg.getAggCallList()) || !MapReduceAggregates.canBeImplementedAsMapReduce(agg.getAggCallList()) || HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            final RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            final RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            Mapping fieldMappingOnReduce = Commons.trimmingMapping(agg.getGroupSet().length(), agg.getGroupSet());
            final RelTraitSet reducePhaseTraits = outTrait.replace((RelTrait)IgniteDistributions.single());
            MapReduceAggregates.AggregateRelBuilder relBuilder = new MapReduceAggregates.AggregateRelBuilder(){

                @Override
                public IgniteRel makeMapAgg(RelOptCluster cluster, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggregateCalls) {
                    return new IgniteMapHashAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.random()), input, groupSet, groupSets, aggregateCalls);
                }

                @Override
                public IgniteRel makeProject(RelOptCluster cluster, RelNode input, List<RexNode> reduceInputExprs, RelDataType projectRowType) {
                    return new IgniteProject(agg.getCluster(), input.getTraitSet(), input, reduceInputExprs, projectRowType);
                }

                @Override
                public IgniteRel makeReduceAgg(RelOptCluster cluster, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggregateCalls, RelDataType outputType) {
                    return new IgniteReduceHashAggregate(cluster, reducePhaseTraits, RelOptRule.convert((RelNode)input, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), groupSet, groupSets, aggregateCalls, outputType);
                }
            };
            return MapReduceAggregates.buildAggregates(agg, relBuilder, fieldMappingOnReduce);
        }
    }
}

