/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite3.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite3.internal.sql.engine.rule.ImmutableTableModifyToKeyValueDeleteRule;
import org.apache.ignite3.internal.sql.engine.rule.TableScanToKeyValueGetRule;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.util.Pair;
import org.immutables.value.Value;

@Value.Enclosing
public class TableModifyToKeyValueDeleteRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.INSTANCE.toRule();

    private TableModifyToKeyValueDeleteRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public boolean matches(RelOptRuleCall call) {
        TableModify modify = (TableModify)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        RelOptTable relTableToModify = modify.getTable();
        RelOptTable relTableToScan = scan.getTable();
        assert (relTableToModify != null);
        assert (relTableToScan != null);
        IgniteTable igniteTableToModify = (IgniteTable)relTableToModify.unwrap(IgniteTable.class);
        IgniteTable igniteTableToScan = (IgniteTable)relTableToScan.unwrap(IgniteTable.class);
        return igniteTableToModify != null && igniteTableToScan != null && igniteTableToModify.id() == igniteTableToScan.id();
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        Pair<List<RexNode>, RexNode> expressionsAndPostFilter = TableScanToKeyValueGetRule.analyzeCondition(scan);
        if (expressionsAndPostFilter == null || expressionsAndPostFilter.getFirst() == null) {
            return;
        }
        if (expressionsAndPostFilter.getSecond() != null) {
            return;
        }
        call.transformTo((RelNode)new IgniteKeyValueModify(scan.getCluster(), scan.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()), scan.getTable(), IgniteKeyValueModify.Operation.DELETE, expressionsAndPostFilter.getFirst()));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = (Config)ImmutableTableModifyToKeyValueDeleteRule.Config.of().withDescription("TableModifyToKeyValueDeleteRule").withOperandSupplier(o0 -> o0.operand(TableModify.class).predicate(TableModify::isDelete).oneInput(o1 -> o1.operand(ProjectableFilterableTableScan.class).predicate(scan -> scan.condition() != null).noInputs())).as(Config.class);

        default public TableModifyToKeyValueDeleteRule toRule() {
            return new TableModifyToKeyValueDeleteRule(this);
        }
    }
}

